/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2;

import java.io.EOFException;
import java.io.IOException;
import java.nio.channels.WritePendingException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http2.CloseState;
import org.eclipse.jetty.http2.ErrorCode;
import org.eclipse.jetty.http2.HTTP2Session;
import org.eclipse.jetty.http2.ISession;
import org.eclipse.jetty.http2.IStream;
import org.eclipse.jetty.http2.api.Stream;
import org.eclipse.jetty.http2.frames.DataFrame;
import org.eclipse.jetty.http2.frames.FailureFrame;
import org.eclipse.jetty.http2.frames.Frame;
import org.eclipse.jetty.http2.frames.HeadersFrame;
import org.eclipse.jetty.http2.frames.PushPromiseFrame;
import org.eclipse.jetty.http2.frames.ResetFrame;
import org.eclipse.jetty.http2.frames.WindowUpdateFrame;
import org.eclipse.jetty.io.IdleTimeout;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Scheduler;

public class HTTP2Stream
extends IdleTimeout
implements IStream,
Callback,
Dumpable {
    private static final Logger LOG = Log.getLogger(HTTP2Stream.class);
    private final AtomicReference<Object> attachment = new AtomicReference();
    private final AtomicReference<ConcurrentMap<String, Object>> attributes = new AtomicReference();
    private final AtomicReference<CloseState> closeState = new AtomicReference<CloseState>(CloseState.NOT_CLOSED);
    private final AtomicReference<Callback> writing = new AtomicReference();
    private final AtomicInteger sendWindow = new AtomicInteger();
    private final AtomicInteger recvWindow = new AtomicInteger();
    private final long timeStamp = System.nanoTime();
    private final ISession session;
    private final int streamId;
    private final boolean local;
    private boolean localReset;
    private Stream.Listener listener;
    private boolean remoteReset;
    private long dataLength;

    public HTTP2Stream(Scheduler scheduler, ISession session, int streamId, boolean local) {
        super(scheduler);
        this.session = session;
        this.streamId = streamId;
        this.local = local;
        this.dataLength = Long.MIN_VALUE;
    }

    @Override
    public int getId() {
        return this.streamId;
    }

    @Override
    public Object getAttachment() {
        return this.attachment.get();
    }

    @Override
    public void setAttachment(Object attachment) {
        this.attachment.set(attachment);
    }

    @Override
    public boolean isLocal() {
        return this.local;
    }

    @Override
    public ISession getSession() {
        return this.session;
    }

    @Override
    public void headers(HeadersFrame frame, Callback callback) {
        if (this.startWrite(callback)) {
            this.session.frames(this, this, frame, Frame.EMPTY_ARRAY);
        }
    }

    @Override
    public void push(PushPromiseFrame frame, Promise<Stream> promise, Stream.Listener listener) {
        this.session.push(this, promise, frame, listener);
    }

    @Override
    public void data(DataFrame frame, Callback callback) {
        if (this.startWrite(callback)) {
            this.session.data(this, this, frame);
        }
    }

    @Override
    public void reset(ResetFrame frame, Callback callback) {
        if (this.isReset()) {
            return;
        }
        this.localReset = true;
        this.session.frames(this, callback, frame, Frame.EMPTY_ARRAY);
    }

    private boolean startWrite(Callback callback) {
        if (this.writing.compareAndSet(null, callback)) {
            return true;
        }
        callback.failed((Throwable)new WritePendingException());
        return false;
    }

    @Override
    public Object getAttribute(String key) {
        return this.attributes().get(key);
    }

    @Override
    public void setAttribute(String key, Object value) {
        this.attributes().put(key, value);
    }

    @Override
    public Object removeAttribute(String key) {
        return this.attributes().remove(key);
    }

    @Override
    public boolean isReset() {
        return this.localReset || this.remoteReset;
    }

    @Override
    public boolean isClosed() {
        return this.closeState.get() == CloseState.CLOSED;
    }

    @Override
    public boolean isRemotelyClosed() {
        return this.closeState.get() == CloseState.REMOTELY_CLOSED;
    }

    public boolean isLocallyClosed() {
        return this.closeState.get() == CloseState.LOCALLY_CLOSED;
    }

    public boolean isOpen() {
        return !this.isClosed();
    }

    protected void onIdleExpired(TimeoutException timeout) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Idle timeout {}ms expired on {}", new Object[]{this.getIdleTimeout(), this});
        }
        if (this.notifyIdleTimeout(this, timeout)) {
            this.reset(new ResetFrame(this.getId(), ErrorCode.CANCEL_STREAM_ERROR.code), Callback.NOOP);
        }
    }

    private ConcurrentMap<String, Object> attributes() {
        ConcurrentMap<String, Object> map = this.attributes.get();
        if (map == null && !this.attributes.compareAndSet(null, map = new ConcurrentHashMap<String, Object>())) {
            map = this.attributes.get();
        }
        return map;
    }

    @Override
    public Stream.Listener getListener() {
        return this.listener;
    }

    @Override
    public void setListener(Stream.Listener listener) {
        this.listener = listener;
    }

    @Override
    public void process(Frame frame, Callback callback) {
        this.notIdle();
        switch (frame.getType()) {
            case HEADERS: {
                this.onHeaders((HeadersFrame)frame, callback);
                break;
            }
            case DATA: {
                this.onData((DataFrame)frame, callback);
                break;
            }
            case RST_STREAM: {
                this.onReset((ResetFrame)frame, callback);
                break;
            }
            case PUSH_PROMISE: {
                this.onPush((PushPromiseFrame)frame, callback);
                break;
            }
            case WINDOW_UPDATE: {
                this.onWindowUpdate((WindowUpdateFrame)frame, callback);
                break;
            }
            case FAILURE: {
                this.onFailure((FailureFrame)frame, callback);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    private void onHeaders(HeadersFrame frame, Callback callback) {
        MetaData metaData;
        if (this.updateClose(frame.isEndStream(), CloseState.Event.RECEIVED)) {
            this.session.removeStream(this);
        }
        if ((metaData = frame.getMetaData()).isRequest() || metaData.isResponse()) {
            HttpFields fields = metaData.getFields();
            long length = -1L;
            if (fields != null) {
                length = fields.getLongField(HttpHeader.CONTENT_LENGTH.asString());
            }
            this.dataLength = length >= 0L ? length : Long.MIN_VALUE;
        }
        callback.succeeded();
    }

    private void onData(DataFrame frame, Callback callback) {
        if (this.getRecvWindow() < 0) {
            this.session.close(ErrorCode.FLOW_CONTROL_ERROR.code, "stream_window_exceeded", Callback.NOOP);
            callback.failed((Throwable)new IOException("stream_window_exceeded"));
            return;
        }
        if (this.isRemotelyClosed()) {
            this.reset(new ResetFrame(this.streamId, ErrorCode.STREAM_CLOSED_ERROR.code), Callback.NOOP);
            callback.failed((Throwable)new EOFException("stream_closed"));
            return;
        }
        if (this.isReset()) {
            callback.failed((Throwable)new IOException("stream_reset"));
            return;
        }
        if (this.dataLength != Long.MIN_VALUE) {
            this.dataLength -= (long)frame.remaining();
            if (frame.isEndStream() && this.dataLength != 0L) {
                this.reset(new ResetFrame(this.streamId, ErrorCode.PROTOCOL_ERROR.code), Callback.NOOP);
                callback.failed((Throwable)new IOException("invalid_data_length"));
                return;
            }
        }
        if (this.updateClose(frame.isEndStream(), CloseState.Event.RECEIVED)) {
            this.session.removeStream(this);
        }
        this.notifyData(this, frame, callback);
    }

    private void onReset(ResetFrame frame, Callback callback) {
        this.remoteReset = true;
        this.close();
        this.session.removeStream(this);
        this.notifyReset(this, frame, callback);
    }

    private void onPush(PushPromiseFrame frame, Callback callback) {
        this.updateClose(true, CloseState.Event.AFTER_SEND);
        callback.succeeded();
    }

    private void onWindowUpdate(WindowUpdateFrame frame, Callback callback) {
        callback.succeeded();
    }

    private void onFailure(FailureFrame frame, Callback callback) {
        this.notifyFailure(this, frame, callback);
    }

    @Override
    public boolean updateClose(boolean update, CloseState.Event event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Update close for {} update={} event={}", new Object[]{this, update, event});
        }
        if (!update) {
            return false;
        }
        switch (event) {
            case RECEIVED: {
                return this.updateCloseAfterReceived();
            }
            case BEFORE_SEND: {
                return this.updateCloseBeforeSend();
            }
            case AFTER_SEND: {
                return this.updateCloseAfterSend();
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private boolean updateCloseAfterReceived() {
        block5: while (true) {
            current = this.closeState.get();
            switch (1.$SwitchMap$org$eclipse$jetty$http2$CloseState[current.ordinal()]) {
                case 1: {
                    if (!this.closeState.compareAndSet(current, CloseState.REMOTELY_CLOSED)) continue block5;
                    return false;
                }
                case 2: {
                    if (this.closeState.compareAndSet(current, CloseState.CLOSING)) ** break;
                    continue block5;
                    this.updateStreamCount(0, 1);
                    return false;
                }
                case 3: {
                    this.close();
                    return true;
                }
            }
            break;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private boolean updateCloseBeforeSend() {
        block4: while (true) {
            current = this.closeState.get();
            switch (1.$SwitchMap$org$eclipse$jetty$http2$CloseState[current.ordinal()]) {
                case 1: {
                    if (!this.closeState.compareAndSet(current, CloseState.LOCALLY_CLOSING)) continue block4;
                    return false;
                }
                case 4: {
                    if (this.closeState.compareAndSet(current, CloseState.CLOSING)) ** break;
                    continue block4;
                    this.updateStreamCount(0, 1);
                    return false;
                }
            }
            break;
        }
        return false;
    }

    private boolean updateCloseAfterSend() {
        block4: while (true) {
            CloseState current = this.closeState.get();
            switch (current) {
                case NOT_CLOSED: 
                case LOCALLY_CLOSING: {
                    if (!this.closeState.compareAndSet(current, CloseState.LOCALLY_CLOSED)) continue block4;
                    return false;
                }
                case REMOTELY_CLOSED: 
                case CLOSING: {
                    this.close();
                    return true;
                }
            }
            break;
        }
        return false;
    }

    public int getSendWindow() {
        return this.sendWindow.get();
    }

    public int getRecvWindow() {
        return this.recvWindow.get();
    }

    @Override
    public int updateSendWindow(int delta) {
        return this.sendWindow.getAndAdd(delta);
    }

    @Override
    public int updateRecvWindow(int delta) {
        return this.recvWindow.getAndAdd(delta);
    }

    @Override
    public void close() {
        CloseState oldState = this.closeState.getAndSet(CloseState.CLOSED);
        if (oldState != CloseState.CLOSED) {
            int deltaClosing = oldState == CloseState.CLOSING ? -1 : 0;
            this.updateStreamCount(-1, deltaClosing);
            this.onClose();
        }
    }

    private void updateStreamCount(int deltaStream, int deltaClosing) {
        ((HTTP2Session)this.session).updateStreamCount(this.isLocal(), deltaStream, deltaClosing);
    }

    public void succeeded() {
        Callback callback = this.endWrite();
        if (callback != null) {
            callback.succeeded();
        }
    }

    public void failed(Throwable x) {
        Callback callback = this.endWrite();
        if (callback != null) {
            callback.failed(x);
        }
    }

    private Callback endWrite() {
        return this.writing.getAndSet(null);
    }

    private void notifyData(Stream stream, DataFrame frame, Callback callback) {
        Stream.Listener listener = this.listener;
        if (listener != null) {
            try {
                listener.onData(stream, frame, callback);
            }
            catch (Throwable x) {
                LOG.info("Failure while notifying listener " + listener, x);
                callback.failed(x);
            }
        } else {
            callback.succeeded();
        }
    }

    private void notifyReset(Stream stream, ResetFrame frame, Callback callback) {
        Stream.Listener listener = this.listener;
        if (listener != null) {
            try {
                listener.onReset(stream, frame, callback);
            }
            catch (Throwable x) {
                LOG.info("Failure while notifying listener " + listener, x);
                callback.failed(x);
            }
        } else {
            callback.succeeded();
        }
    }

    private boolean notifyIdleTimeout(Stream stream, Throwable failure) {
        Stream.Listener listener = this.listener;
        if (listener == null) {
            return true;
        }
        try {
            return listener.onIdleTimeout(stream, failure);
        }
        catch (Throwable x) {
            LOG.info("Failure while notifying listener " + listener, x);
            return true;
        }
    }

    private void notifyFailure(Stream stream, FailureFrame frame, Callback callback) {
        Stream.Listener listener = this.listener;
        if (listener != null) {
            try {
                listener.onFailure(stream, frame.getError(), frame.getReason(), callback);
            }
            catch (Throwable x) {
                LOG.info("Failure while notifying listener " + listener, x);
                callback.failed(x);
            }
        } else {
            callback.succeeded();
        }
    }

    public String dump() {
        return ContainerLifeCycle.dump((Dumpable)this);
    }

    public void dump(Appendable out, String indent) throws IOException {
        out.append(this.toString()).append(System.lineSeparator());
    }

    public String toString() {
        return String.format("%s@%x#%d{sendWindow=%s,recvWindow=%s,reset=%b,%s,age=%d,attachment=%s}", this.getClass().getSimpleName(), this.hashCode(), this.getId(), this.sendWindow, this.recvWindow, this.isReset(), this.closeState, TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.timeStamp), this.attachment);
    }
}

