/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.generator;

import java.nio.ByteBuffer;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http2.frames.Frame;
import org.eclipse.jetty.http2.frames.FrameType;
import org.eclipse.jetty.http2.frames.HeadersFrame;
import org.eclipse.jetty.http2.generator.FrameGenerator;
import org.eclipse.jetty.http2.generator.HeaderGenerator;
import org.eclipse.jetty.http2.hpack.HpackEncoder;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.BufferUtil;

public class HeadersGenerator
extends FrameGenerator {
    private final HpackEncoder encoder;

    public HeadersGenerator(HeaderGenerator headerGenerator, HpackEncoder encoder) {
        super(headerGenerator);
        this.encoder = encoder;
    }

    @Override
    public void generate(ByteBufferPool.Lease lease, Frame frame) {
        HeadersFrame headersFrame = (HeadersFrame)frame;
        this.generateHeaders(lease, headersFrame.getStreamId(), headersFrame.getMetaData(), !headersFrame.isEndStream());
    }

    public void generateHeaders(ByteBufferPool.Lease lease, int streamId, MetaData metaData, boolean contentFollows) {
        if (streamId < 0) {
            throw new IllegalArgumentException("Invalid stream id: " + streamId);
        }
        int maxFrameSize = this.getMaxFrameSize();
        int leaseSize = lease.getSize();
        long leaseLength = lease.getTotalLength();
        this.encoder.encode(metaData, lease, maxFrameSize);
        long headersLength = lease.getTotalLength() - leaseLength;
        if (headersLength > (long)maxFrameSize) {
            throw new IllegalArgumentException(String.format("Invalid headers, too big for max frame size: %d > %d", headersLength, maxFrameSize));
        }
        int flags = 4;
        if (!contentFollows) {
            flags |= 1;
        }
        ByteBuffer header = this.generateHeader(lease, FrameType.HEADERS, (int)headersLength, flags, streamId);
        BufferUtil.flipToFlush((ByteBuffer)header, (int)0);
        lease.insert(leaseSize, header, true);
    }
}

