/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.client;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.jetty.http2.FlowControl;
import org.eclipse.jetty.http2.HTTP2Connection;
import org.eclipse.jetty.http2.HTTP2FlowControl;
import org.eclipse.jetty.http2.ISession;
import org.eclipse.jetty.http2.api.Session;
import org.eclipse.jetty.http2.client.HTTP2Client;
import org.eclipse.jetty.http2.client.HTTP2ClientSession;
import org.eclipse.jetty.http2.frames.Frame;
import org.eclipse.jetty.http2.frames.PrefaceFrame;
import org.eclipse.jetty.http2.frames.SettingsFrame;
import org.eclipse.jetty.http2.frames.WindowUpdateFrame;
import org.eclipse.jetty.http2.generator.Generator;
import org.eclipse.jetty.http2.parser.Parser;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.thread.Scheduler;

public class HTTP2ClientConnectionFactory
implements ClientConnectionFactory {
    public static final String CLIENT_CONTEXT_KEY = "http2.client";
    public static final String BYTE_BUFFER_POOL_CONTEXT_KEY = "http2.client.byteBufferPool";
    public static final String EXECUTOR_CONTEXT_KEY = "http2.client.executor";
    public static final String SCHEDULER_CONTEXT_KEY = "http2.client.scheduler";
    public static final String SESSION_LISTENER_CONTEXT_KEY = "http2.client.sessionListener";
    public static final String SESSION_PROMISE_CONTEXT_KEY = "http2.client.sessionPromise";
    private int initialSessionWindow = 65535;

    public Connection newConnection(EndPoint endPoint, Map<String, Object> context) throws IOException {
        HTTP2Client client = (HTTP2Client)((Object)context.get(CLIENT_CONTEXT_KEY));
        ByteBufferPool byteBufferPool = (ByteBufferPool)context.get(BYTE_BUFFER_POOL_CONTEXT_KEY);
        Executor executor = (Executor)context.get(EXECUTOR_CONTEXT_KEY);
        Scheduler scheduler = (Scheduler)context.get(SCHEDULER_CONTEXT_KEY);
        Session.Listener listener = (Session.Listener)context.get(SESSION_LISTENER_CONTEXT_KEY);
        Promise promise = (Promise)context.get(SESSION_PROMISE_CONTEXT_KEY);
        Generator generator = new Generator(byteBufferPool, 4096);
        HTTP2ClientSession session = new HTTP2ClientSession(scheduler, endPoint, generator, listener, (FlowControl)new HTTP2FlowControl(65535));
        Parser parser = new Parser(byteBufferPool, (Parser.Listener)session, 4096, 8192);
        return new HTTP2ClientConnection(client, byteBufferPool, executor, endPoint, parser, (ISession)session, 8192, false, (Promise<Session>)promise, listener);
    }

    public int getInitialSessionWindow() {
        return this.initialSessionWindow;
    }

    public void setInitialSessionWindow(int initialSessionWindow) {
        this.initialSessionWindow = initialSessionWindow;
    }

    private class HTTP2ClientConnection
    extends HTTP2Connection
    implements Callback {
        private final HTTP2Client client;
        private final Promise<Session> promise;
        private final Session.Listener listener;

        public HTTP2ClientConnection(HTTP2Client client, ByteBufferPool byteBufferPool, Executor executor, EndPoint endpoint, Parser parser, ISession session, int bufferSize, boolean dispatchIO, Promise<Session> promise, Session.Listener listener) {
            super(byteBufferPool, executor, endpoint, parser, session, bufferSize, dispatchIO);
            this.client = client;
            this.promise = promise;
            this.listener = listener;
        }

        public void onOpen() {
            super.onOpen();
            Map settings = this.listener.onPreface((Session)this.getSession());
            if (settings == null) {
                settings = Collections.emptyMap();
            }
            PrefaceFrame prefaceFrame = new PrefaceFrame();
            SettingsFrame settingsFrame = new SettingsFrame(settings, false);
            int windowDelta = HTTP2ClientConnectionFactory.this.getInitialSessionWindow() - 65535;
            if (windowDelta > 0) {
                this.getSession().control(null, (Callback)this, (Frame)prefaceFrame, new Frame[]{settingsFrame, new WindowUpdateFrame(0, windowDelta)});
            } else {
                this.getSession().control(null, (Callback)this, (Frame)prefaceFrame, new Frame[]{settingsFrame});
            }
        }

        public void onClose() {
            super.onClose();
            this.client.removeSession(this.getSession());
        }

        public void succeeded() {
            this.client.addSession(this.getSession());
            this.promise.succeeded((Object)this.getSession());
        }

        public void failed(Throwable x) {
            this.close();
            this.promise.failed(x);
        }
    }
}

