/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.fcgi.server;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.http.HostPortHttpField;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpInput;
import org.eclipse.jetty.server.HttpTransport;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.thread.AutoLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpChannelOverFCGI
extends HttpChannel {
    private static final Logger LOG = LoggerFactory.getLogger(HttpChannelOverFCGI.class);
    private final Queue<HttpInput.Content> _contentQueue = new LinkedList<HttpInput.Content>();
    private final AutoLock _lock = new AutoLock();
    private HttpInput.Content _specialContent;
    private final HttpFields.Mutable fields = HttpFields.build();
    private final Dispatcher dispatcher;
    private String method;
    private String path;
    private String query;
    private String version;
    private HostPortHttpField hostPort;

    public HttpChannelOverFCGI(Connector connector, HttpConfiguration configuration, EndPoint endPoint, HttpTransport transport) {
        super(connector, configuration, endPoint, transport);
        this.dispatcher = new Dispatcher((Executor)connector.getServer().getThreadPool(), (Runnable)((Object)this));
    }

    public boolean onContent(HttpInput.Content content) {
        Throwable failure;
        boolean b = super.onContent(content);
        try (AutoLock l = this._lock.lock();){
            Throwable throwable = failure = this._specialContent == null ? null : this._specialContent.getError();
            if (failure == null) {
                this._contentQueue.offer(content);
            }
        }
        if (failure != null) {
            content.failed(failure);
        }
        return b;
    }

    public boolean needContent() {
        try (AutoLock l = this._lock.lock();){
            boolean hasContent;
            boolean bl = hasContent = this._specialContent != null || !this._contentQueue.isEmpty();
            if (LOG.isDebugEnabled()) {
                LOG.debug("needContent has content? {}", (Object)hasContent);
            }
            boolean bl2 = hasContent;
            return bl2;
        }
    }

    public HttpInput.Content produceContent() {
        HttpInput.Content content;
        try (AutoLock l = this._lock.lock();){
            content = this._contentQueue.poll();
            if (content == null) {
                content = this._specialContent;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("produceContent has produced {}", (Object)content);
        }
        return content;
    }

    public boolean failAllContent(Throwable failure) {
        boolean atEof;
        ArrayList<HttpInput.Content> copy;
        if (LOG.isDebugEnabled()) {
            LOG.debug("failing all content with {} {}", (Object)failure, (Object)this);
        }
        try (AutoLock l = this._lock.lock();){
            copy = new ArrayList<HttpInput.Content>(this._contentQueue);
            this._contentQueue.clear();
        }
        copy.forEach(c -> c.failed(failure));
        try (AutoLock l = this._lock.lock();){
            atEof = this._specialContent != null && this._specialContent.isEof();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("failed all content, EOF = {}", (Object)atEof);
        }
        return atEof;
    }

    public boolean failed(Throwable x) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("failed " + x);
        }
        try (AutoLock l = this._lock.lock();){
            Throwable error;
            Throwable throwable = error = this._specialContent == null ? null : this._specialContent.getError();
            if (error != null && error != x) {
                error.addSuppressed(x);
            } else {
                this._specialContent = new HttpInput.ErrorContent(x);
            }
        }
        return this.getRequest().getHttpInput().onContentProducible();
    }

    protected boolean eof() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("received EOF");
        }
        try (AutoLock l = this._lock.lock();){
            this._specialContent = new HttpInput.EofContent();
        }
        return this.getRequest().getHttpInput().onContentProducible();
    }

    protected void header(HttpField field) {
        String name = field.getName();
        String value = field.getValue();
        this.getRequest().setAttribute(name, (Object)value);
        if ("REQUEST_METHOD".equalsIgnoreCase(name)) {
            this.method = value;
        } else if ("DOCUMENT_URI".equalsIgnoreCase(name)) {
            this.path = value;
        } else if ("QUERY_STRING".equalsIgnoreCase(name)) {
            this.query = value;
        } else if ("SERVER_PROTOCOL".equalsIgnoreCase(name)) {
            this.version = value;
        } else {
            this.processField(field);
        }
    }

    private void processField(HttpField field) {
        HttpField httpField = this.convertHeader(field);
        if (httpField != null) {
            this.fields.add(httpField);
            if (HttpHeader.HOST.is(httpField.getName())) {
                this.hostPort = (HostPortHttpField)httpField;
            }
        }
    }

    public void onRequest() {
        Object uri = this.path;
        if (!StringUtil.isEmpty((String)this.query)) {
            uri = (String)uri + "?" + this.query;
        }
        this.onRequest(new MetaData.Request(this.method, HttpScheme.HTTP.asString(), this.hostPort, (String)uri, HttpVersion.fromString((String)this.version), (HttpFields)this.fields, Long.MIN_VALUE));
    }

    private HttpField convertHeader(HttpField field) {
        String name = field.getName();
        if (name.startsWith("HTTP_")) {
            String[] parts = name.split("_");
            StringBuilder httpName = new StringBuilder();
            for (int i = 1; i < parts.length; ++i) {
                if (i > 1) {
                    httpName.append("-");
                }
                String part = parts[i];
                httpName.append(Character.toUpperCase(part.charAt(0)));
                httpName.append(part.substring(1).toLowerCase(Locale.ENGLISH));
            }
            String headerName = httpName.toString();
            String value = field.getValue();
            if (HttpHeader.HOST.is(headerName)) {
                return new HostPortHttpField(value);
            }
            return new HttpField(headerName, value);
        }
        return null;
    }

    protected void dispatch() {
        this.dispatcher.dispatch();
    }

    public boolean onIdleTimeout(Throwable timeout) {
        boolean handle = this.doOnIdleTimeout(timeout);
        if (handle) {
            this.execute((Runnable)((Object)this));
        }
        return !handle;
    }

    private boolean doOnIdleTimeout(Throwable x) {
        HttpInput.Content specialContent;
        boolean waitingForContent;
        boolean neverDispatched = this.getState().isIdle();
        try (AutoLock l = this._lock.lock();){
            waitingForContent = this._contentQueue.isEmpty() || this._contentQueue.peek().remaining() == 0;
            specialContent = this._specialContent;
        }
        if ((waitingForContent || neverDispatched) && specialContent == null) {
            x.addSuppressed(new Throwable("HttpInput idle timeout"));
            l = this._lock.lock();
            try {
                this._specialContent = new HttpInput.ErrorContent(x);
            }
            finally {
                if (l != null) {
                    l.close();
                }
            }
            return this.getRequest().getHttpInput().onContentProducible();
        }
        return false;
    }

    public void recycle() {
        try (AutoLock l = this._lock.lock();){
            if (!this._contentQueue.isEmpty()) {
                throw new AssertionError((Object)("unconsumed content: " + this._contentQueue));
            }
            this._specialContent = null;
        }
        super.recycle();
    }

    private static class Dispatcher
    implements Runnable {
        private final AtomicReference<State> state = new AtomicReference<State>(State.IDLE);
        private final Executor executor;
        private final Runnable runnable;

        private Dispatcher(Executor executor, Runnable runnable) {
            this.executor = executor;
            this.runnable = runnable;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void dispatch() {
            block5: while (true) {
                State current = this.state.get();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Dispatching, state={}", (Object)current);
                }
                switch (current) {
                    case IDLE: {
                        if (!this.state.compareAndSet(current, State.DISPATCH)) continue block5;
                        this.executor.execute(this);
                        return;
                    }
                    case DISPATCH: 
                    case EXECUTE: {
                        if (this.state.compareAndSet(current, State.SCHEDULE)) return;
                        continue block5;
                    }
                    case SCHEDULE: {
                        return;
                    }
                }
                break;
            }
            throw new IllegalStateException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            block5: while (true) {
                State current = this.state.get();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Running, state={}", (Object)current);
                }
                switch (current) {
                    case DISPATCH: {
                        if (!this.state.compareAndSet(current, State.EXECUTE)) continue block5;
                        this.runnable.run();
                        continue block5;
                    }
                    case EXECUTE: {
                        if (!this.state.compareAndSet(current, State.IDLE)) continue block5;
                        return;
                    }
                    case SCHEDULE: {
                        if (!this.state.compareAndSet(current, State.DISPATCH)) throw new IllegalStateException();
                        continue block5;
                    }
                }
                break;
            }
            throw new IllegalStateException();
        }

        private static enum State {
            IDLE,
            DISPATCH,
            EXECUTE,
            SCHEDULE;

        }
    }
}

