/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.fcgi.client.http;

import java.io.EOFException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpConnection;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.api.Connection;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.fcgi.FCGI;
import org.eclipse.jetty.fcgi.client.http.HttpChannelOverFCGI;
import org.eclipse.jetty.fcgi.generator.Flusher;
import org.eclipse.jetty.fcgi.parser.ClientParser;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.CompletableCallback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HttpConnectionOverFCGI
extends AbstractConnection
implements Connection {
    private static final Logger LOG = Log.getLogger(HttpConnectionOverFCGI.class);
    private final LinkedList<Integer> requests = new LinkedList();
    private final Map<Integer, HttpChannelOverFCGI> channels = new ConcurrentHashMap<Integer, HttpChannelOverFCGI>();
    private final AtomicBoolean closed = new AtomicBoolean();
    private final Flusher flusher;
    private final HttpDestination destination;
    private final boolean multiplexed;
    private final Delegate delegate;
    private final ClientParser parser;
    private ByteBuffer buffer;

    public HttpConnectionOverFCGI(EndPoint endPoint, HttpDestination destination, boolean multiplexed) {
        super(endPoint, destination.getHttpClient().getExecutor(), destination.getHttpClient().isDispatchIO());
        this.destination = destination;
        this.multiplexed = multiplexed;
        this.flusher = new Flusher(endPoint);
        this.delegate = new Delegate(destination);
        this.parser = new ClientParser(new ResponseListener());
        this.requests.addLast(0);
    }

    public HttpDestination getHttpDestination() {
        return this.destination;
    }

    public void send(Request request, Response.CompleteListener listener) {
        this.delegate.send(request, listener);
    }

    protected void send(HttpExchange exchange) {
        this.delegate.send(exchange);
    }

    public void onOpen() {
        super.onOpen();
        this.fillInterested();
    }

    public void onFillable() {
        HttpClient client = this.destination.getHttpClient();
        ByteBufferPool bufferPool = client.getByteBufferPool();
        this.buffer = bufferPool.acquire(client.getResponseBufferSize(), true);
        this.process();
    }

    private void process() {
        if (this.readAndParse()) {
            HttpClient client = this.destination.getHttpClient();
            ByteBufferPool bufferPool = client.getByteBufferPool();
            bufferPool.release(this.buffer);
            this.buffer = null;
        }
    }

    private boolean readAndParse() {
        EndPoint endPoint = this.getEndPoint();
        ByteBuffer buffer = this.buffer;
        try {
            int read;
            block6: {
                do {
                    if (!this.parse(buffer)) {
                        return false;
                    }
                    read = endPoint.fill(buffer);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Read {} bytes from {}", new Object[]{read, endPoint});
                    }
                    if (read <= 0) break block6;
                } while (this.parse(buffer));
                return false;
            }
            if (read == 0) {
                this.fillInterested();
                return true;
            }
            this.shutdown();
            return true;
        }
        catch (Exception x) {
            LOG.debug((Throwable)x);
            this.close(x);
            return false;
        }
    }

    private boolean parse(ByteBuffer buffer) {
        return !this.parser.parse(buffer);
    }

    private void shutdown() {
        if (this.channels.isEmpty()) {
            this.close();
        } else {
            this.failAndClose(new EOFException());
        }
    }

    protected boolean onReadTimeout() {
        this.close(new TimeoutException());
        return false;
    }

    protected void release(HttpChannelOverFCGI channel) {
        this.channels.remove(channel.getRequest());
        this.destination.release((Connection)this);
    }

    public void close() {
        this.close(new AsynchronousCloseException());
    }

    protected void close(Throwable failure) {
        if (this.closed.compareAndSet(false, true)) {
            this.getHttpDestination().close((Connection)this);
            this.getEndPoint().shutdownOutput();
            LOG.debug("{} oshut", new Object[]{this});
            this.getEndPoint().close();
            LOG.debug("{} closed", new Object[]{this});
            this.abort(failure);
        }
    }

    protected boolean closeByHTTP(HttpFields fields) {
        if (this.multiplexed) {
            return false;
        }
        if (!fields.contains(HttpHeader.CONNECTION, HttpHeaderValue.CLOSE.asString())) {
            return false;
        }
        this.close();
        return true;
    }

    protected void abort(Throwable failure) {
        for (HttpChannelOverFCGI channel : this.channels.values()) {
            HttpExchange exchange = channel.getHttpExchange();
            if (exchange == null) continue;
            exchange.getRequest().abort(failure);
        }
        this.channels.clear();
    }

    private void failAndClose(Throwable failure) {
        boolean result = false;
        for (HttpChannelOverFCGI channel : this.channels.values()) {
            result |= channel.responseFailure(failure);
        }
        if (result) {
            this.close(failure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int acquireRequest() {
        LinkedList<Integer> linkedList = this.requests;
        synchronized (linkedList) {
            int last = this.requests.getLast();
            int request = last + 1;
            this.requests.addLast(request);
            return request;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseRequest(int request) {
        LinkedList<Integer> linkedList = this.requests;
        synchronized (linkedList) {
            this.requests.removeFirstOccurrence(request);
        }
    }

    public String toString() {
        return String.format("%s@%h(l:%s <-> r:%s)", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), this, this.getEndPoint().getLocalAddress(), this.getEndPoint().getRemoteAddress()});
    }

    private class ResponseListener
    implements ClientParser.Listener {
        private ResponseListener() {
        }

        @Override
        public void onBegin(int request, int code, String reason) {
            HttpChannelOverFCGI channel = (HttpChannelOverFCGI)((Object)HttpConnectionOverFCGI.this.channels.get(request));
            if (channel != null) {
                channel.responseBegin(code, reason);
            } else {
                this.noChannel(request);
            }
        }

        @Override
        public void onHeader(int request, HttpField field) {
            HttpChannelOverFCGI channel = (HttpChannelOverFCGI)((Object)HttpConnectionOverFCGI.this.channels.get(request));
            if (channel != null) {
                channel.responseHeader(field);
            } else {
                this.noChannel(request);
            }
        }

        @Override
        public void onHeaders(int request) {
            HttpChannelOverFCGI channel = (HttpChannelOverFCGI)((Object)HttpConnectionOverFCGI.this.channels.get(request));
            if (channel != null) {
                channel.responseHeaders();
            } else {
                this.noChannel(request);
            }
        }

        @Override
        public boolean onContent(int request, FCGI.StreamType stream, ByteBuffer buffer) {
            switch (stream) {
                case STD_OUT: {
                    HttpChannelOverFCGI channel = (HttpChannelOverFCGI)((Object)HttpConnectionOverFCGI.this.channels.get(request));
                    if (channel != null) {
                        CompletableCallback callback = new CompletableCallback(){

                            public void resume() {
                                LOG.debug("Content consumed asynchronously, resuming processing", new Object[0]);
                                HttpConnectionOverFCGI.this.process();
                            }

                            public void abort(Throwable x) {
                                HttpConnectionOverFCGI.this.close(x);
                            }
                        };
                        channel.content(buffer, (Callback)callback);
                        return callback.tryComplete();
                    }
                    this.noChannel(request);
                    break;
                }
                case STD_ERR: {
                    LOG.info(BufferUtil.toUTF8String((ByteBuffer)buffer), new Object[0]);
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            return false;
        }

        @Override
        public void onEnd(int request) {
            HttpChannelOverFCGI channel = (HttpChannelOverFCGI)((Object)HttpConnectionOverFCGI.this.channels.get(request));
            if (channel != null) {
                if (channel.responseSuccess()) {
                    HttpConnectionOverFCGI.this.releaseRequest(request);
                }
            } else {
                this.noChannel(request);
            }
        }

        @Override
        public void onFailure(int request, Throwable failure) {
            HttpChannelOverFCGI channel = (HttpChannelOverFCGI)((Object)HttpConnectionOverFCGI.this.channels.get(request));
            if (channel != null) {
                if (channel.responseFailure(failure)) {
                    HttpConnectionOverFCGI.this.releaseRequest(request);
                }
            } else {
                this.noChannel(request);
            }
        }

        private void noChannel(int request) {
        }
    }

    private class Delegate
    extends HttpConnection {
        private Delegate(HttpDestination destination) {
            super(destination);
        }

        protected void send(HttpExchange exchange) {
            Request request = exchange.getRequest();
            this.normalizeRequest(request);
            int id = HttpConnectionOverFCGI.this.acquireRequest();
            HttpChannelOverFCGI channel = new HttpChannelOverFCGI(HttpConnectionOverFCGI.this, HttpConnectionOverFCGI.this.flusher, id, request.getIdleTimeout());
            HttpConnectionOverFCGI.this.channels.put(id, channel);
            channel.associate(exchange);
            channel.send();
        }

        public void close() {
            HttpConnectionOverFCGI.this.close();
        }

        public String toString() {
            return HttpConnectionOverFCGI.this.toString();
        }
    }
}

