/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.compression.server;

import java.util.ListIterator;
import org.eclipse.jetty.compression.Compression;
import org.eclipse.jetty.compression.DecoderSource;
import org.eclipse.jetty.compression.server.CompressionConfig;
import org.eclipse.jetty.compression.server.CompressionHandler;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.component.Destroyable;

public class DecompressionRequest
extends Request.Wrapper
implements Destroyable {
    private Compression compression;
    private HttpFields fields;
    private DecoderSource decoderSource;

    public DecompressionRequest(Compression compression, Request request, CompressionConfig config) {
        super(request);
        this.compression = compression;
        this.fields = this.updateRequestFields(request);
        this.decoderSource = compression.newDecoderSource((Content.Source)request);
    }

    public void demand(Runnable demandCallback) {
        this.decoderSource.demand(demandCallback);
    }

    public void destroy() {
        DecoderSource decoderSource = this.decoderSource;
        if (decoderSource instanceof Destroyable) {
            Destroyable destroyable = (Destroyable)decoderSource;
            destroyable.destroy();
        }
    }

    public HttpFields getHeaders() {
        if (this.fields == null) {
            return super.getHeaders();
        }
        return this.fields;
    }

    public Content.Chunk read() {
        return this.decoderSource.read();
    }

    private HttpFields updateRequestFields(Request request) {
        HttpFields fields = request.getHeaders();
        HttpFields.Mutable newFields = HttpFields.build((HttpFields)fields);
        boolean contentEncodingSeen = false;
        ListIterator i = newFields.listIterator(newFields.size());
        block5: while (i.hasPrevious()) {
            HttpField field = (HttpField)i.previous();
            HttpHeader header = field.getHeader();
            if (header == null) continue;
            switch (header) {
                case CONTENT_ENCODING: {
                    if (contentEncodingSeen) break;
                    contentEncodingSeen = true;
                    if (field.getValue().equalsIgnoreCase(this.compression.getEncodingName())) {
                        i.set(this.compression.getXContentEncodingField());
                        break;
                    }
                    if (!field.containsLast(this.compression.getEncodingName())) break;
                    String v = field.getValue();
                    v = v.substring(0, v.lastIndexOf(44));
                    i.set(new HttpField(HttpHeader.CONTENT_ENCODING, v));
                    i.add(this.compression.getXContentEncodingField());
                    break;
                }
                case IF_MATCH: 
                case IF_NONE_MATCH: {
                    String etags = field.getValue();
                    String etagsNoSuffix = this.compression.stripSuffixes(etags);
                    if (etagsNoSuffix.equals(etags)) continue block5;
                    i.set(new HttpField(field.getHeader(), etagsNoSuffix));
                    request.setAttribute(CompressionHandler.HANDLER_ETAGS, (Object)etags);
                    break;
                }
                case CONTENT_LENGTH: {
                    i.set(new HttpField("X-Content-Length", field.getValue()));
                }
            }
        }
        return newFields.asImmutable();
    }
}

