/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket;

import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.util.Utf8StringBuilder;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.websocket.WebSocket;
import org.eclipse.jetty.websocket.WebSocketConnectionD00;
import org.eclipse.jetty.websocket.WebSocketParser;

final class FrameHandlerD1
implements WebSocketParser.FrameHandler {
    public static final byte PING = 1;
    public static final byte PONG = 1;
    final WebSocketConnectionD00 _connection;
    final WebSocket _websocket;
    final Utf8StringBuilder _utf8 = new Utf8StringBuilder();
    boolean _fragmented = false;

    FrameHandlerD1(WebSocketConnectionD00 connection, WebSocket websocket) {
        this._connection = connection;
        this._websocket = websocket;
    }

    @Override
    public void onFrame(boolean more, byte flags, byte opcode, Buffer buffer) {
        try {
            byte[] array = buffer.array();
            if (opcode == 0) {
                if (more) {
                    this._utf8.append(buffer.array(), buffer.getIndex(), buffer.length());
                    this._fragmented = true;
                } else if (this._fragmented) {
                    this._utf8.append(buffer.array(), buffer.getIndex(), buffer.length());
                    this._websocket.onMessage(opcode, this._utf8.toString());
                    this._utf8.reset();
                    this._fragmented = false;
                } else {
                    this._websocket.onMessage(opcode, buffer.toString("utf-8"));
                }
            } else if (opcode == 1) {
                this._connection.sendMessage((byte)1, buffer.array(), buffer.getIndex(), buffer.length());
            } else if (opcode != 1) {
                if (more) {
                    this._websocket.onFragment(true, opcode, array, buffer.getIndex(), buffer.length());
                } else if (this._fragmented) {
                    this._websocket.onFragment(false, opcode, array, buffer.getIndex(), buffer.length());
                } else {
                    this._websocket.onMessage(opcode, array, buffer.getIndex(), buffer.length());
                }
            }
        }
        catch (ThreadDeath th) {
            throw th;
        }
        catch (Throwable th) {
            Log.warn(th);
        }
    }
}

