/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpException;
import org.eclipse.jetty.http.HttpParser;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.ConnectedEndPoint;
import org.eclipse.jetty.server.AbstractHttpConnection;
import org.eclipse.jetty.server.BlockingHttpConnection;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.DeflateFrameExtension;
import org.eclipse.jetty.websocket.Extension;
import org.eclipse.jetty.websocket.FragmentExtension;
import org.eclipse.jetty.websocket.IdentityExtension;
import org.eclipse.jetty.websocket.WebSocket;
import org.eclipse.jetty.websocket.WebSocketBuffers;
import org.eclipse.jetty.websocket.WebSocketConnectionD00;
import org.eclipse.jetty.websocket.WebSocketConnectionD06;
import org.eclipse.jetty.websocket.WebSocketConnectionD08;
import org.eclipse.jetty.websocket.WebSocketConnectionD13;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebSocketFactory {
    private static final Logger LOG = Log.getLogger(WebSocketFactory.class);
    private final Map<String, Class<? extends Extension>> _extensionClasses = new HashMap<String, Class<? extends Extension>>();
    private final Acceptor _acceptor;
    private WebSocketBuffers _buffers;
    private int _maxIdleTime;
    private int _maxTextMessageSize;
    private int _maxBinaryMessageSize;

    public WebSocketFactory(Acceptor acceptor) {
        this(acceptor, 65536);
    }

    public WebSocketFactory(Acceptor acceptor, int bufferSize) {
        this._extensionClasses.put("identity", IdentityExtension.class);
        this._extensionClasses.put("fragment", FragmentExtension.class);
        this._extensionClasses.put("x-deflate-frame", DeflateFrameExtension.class);
        this._maxIdleTime = 300000;
        this._maxTextMessageSize = 16384;
        this._maxBinaryMessageSize = -1;
        this._buffers = new WebSocketBuffers(bufferSize);
        this._acceptor = acceptor;
    }

    public Map<String, Class<? extends Extension>> getExtensionClassesMap() {
        return this._extensionClasses;
    }

    public long getMaxIdleTime() {
        return this._maxIdleTime;
    }

    public void setMaxIdleTime(int maxIdleTime) {
        this._maxIdleTime = maxIdleTime;
    }

    public int getBufferSize() {
        return this._buffers.getBufferSize();
    }

    public void setBufferSize(int bufferSize) {
        if (bufferSize != this.getBufferSize()) {
            this._buffers = new WebSocketBuffers(bufferSize);
        }
    }

    public int getMaxTextMessageSize() {
        return this._maxTextMessageSize;
    }

    public void setMaxTextMessageSize(int maxTextMessageSize) {
        this._maxTextMessageSize = maxTextMessageSize;
    }

    public int getMaxBinaryMessageSize() {
        return this._maxBinaryMessageSize;
    }

    public void setMaxBinaryMessageSize(int maxBinaryMessageSize) {
        this._maxBinaryMessageSize = maxBinaryMessageSize;
    }

    public void upgrade(HttpServletRequest request, HttpServletResponse response, WebSocket websocket, String protocol) throws IOException {
        AbstractConnection connection;
        AbstractHttpConnection http;
        if (!"websocket".equalsIgnoreCase(request.getHeader("Upgrade"))) {
            throw new IllegalStateException("!Upgrade:websocket");
        }
        if (!"HTTP/1.1".equals(request.getProtocol())) {
            throw new IllegalStateException("!HTTP/1.1");
        }
        int draft = request.getIntHeader("Sec-WebSocket-Version");
        if (draft < 0) {
            draft = request.getIntHeader("Sec-WebSocket-Draft");
        }
        if ((http = AbstractHttpConnection.getCurrentConnection()) instanceof BlockingHttpConnection) {
            throw new IllegalStateException("Websockets not supported on blocking connectors");
        }
        ConnectedEndPoint endp = (ConnectedEndPoint)http.getEndPoint();
        ArrayList<String> extensions_requested = new ArrayList<String>();
        Enumeration e = request.getHeaders("Sec-WebSocket-Extensions");
        while (e.hasMoreElements()) {
            QuotedStringTokenizer tok = new QuotedStringTokenizer((String)e.nextElement(), ",");
            while (tok.hasMoreTokens()) {
                extensions_requested.add(tok.nextToken());
            }
        }
        switch (draft) {
            case -1: 
            case 0: {
                List<Extension> extensions = Collections.emptyList();
                connection = new WebSocketConnectionD00(websocket, endp, this._buffers, http.getTimeStamp(), this._maxIdleTime, protocol);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                List<Extension> extensions = Collections.emptyList();
                connection = new WebSocketConnectionD06(websocket, endp, this._buffers, http.getTimeStamp(), this._maxIdleTime, protocol);
                break;
            }
            case 7: 
            case 8: {
                List<Extension> extensions = this.initExtensions(extensions_requested, 5, 5, 3);
                connection = new WebSocketConnectionD08(websocket, endp, this._buffers, http.getTimeStamp(), this._maxIdleTime, protocol, extensions, draft);
                break;
            }
            case 13: {
                List<Extension> extensions = this.initExtensions(extensions_requested, 5, 5, 3);
                connection = new WebSocketConnectionD13(websocket, endp, this._buffers, http.getTimeStamp(), this._maxIdleTime, protocol, extensions, draft);
                break;
            }
            default: {
                LOG.warn("Unsupported Websocket version: " + draft, new Object[0]);
                response.setHeader("Sec-WebSocket-Version", "0,6,8,13");
                throw new HttpException(400, "Unsupported draft specification: " + draft);
            }
        }
        connection.getConnection().setMaxBinaryMessageSize(this._maxBinaryMessageSize);
        connection.getConnection().setMaxTextMessageSize(this._maxTextMessageSize);
        connection.handshake(request, response, protocol);
        response.flushBuffer();
        connection.fillBuffersFrom(((HttpParser)http.getParser()).getHeaderBuffer());
        connection.fillBuffersFrom(((HttpParser)http.getParser()).getBodyBuffer());
        LOG.debug("Websocket upgrade {} {} {} {}", request.getRequestURI(), draft, protocol, connection);
        request.setAttribute("org.eclipse.jetty.io.Connection", (Object)connection);
    }

    protected String[] parseProtocols(String protocol) {
        if (protocol == null) {
            return new String[]{null};
        }
        if ((protocol = protocol.trim()) == null || protocol.length() == 0) {
            return new String[]{null};
        }
        String[] passed = protocol.split("\\s*,\\s*");
        String[] protocols = new String[passed.length + 1];
        System.arraycopy(passed, 0, protocols, 0, passed.length);
        return protocols;
    }

    public boolean acceptWebSocket(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if ("websocket".equalsIgnoreCase(request.getHeader("Upgrade"))) {
            String origin = request.getHeader("Origin");
            if (origin == null) {
                origin = request.getHeader("Sec-WebSocket-Origin");
            }
            if (!this._acceptor.checkOrigin(request, origin)) {
                response.sendError(403);
                return false;
            }
            WebSocket websocket = null;
            Enumeration protocols = request.getHeaders("Sec-WebSocket-Protocol");
            String protocol = null;
            block0: while (protocol == null && protocols != null && protocols.hasMoreElements()) {
                String candidate = (String)protocols.nextElement();
                for (String p : this.parseProtocols(candidate)) {
                    websocket = this._acceptor.doWebSocketConnect(request, p);
                    if (websocket == null) continue;
                    protocol = p;
                    continue block0;
                }
            }
            if (websocket == null && (websocket = this._acceptor.doWebSocketConnect(request, null)) == null) {
                response.sendError(503);
                return false;
            }
            this.upgrade(request, response, websocket, protocol);
            return true;
        }
        return false;
    }

    public List<Extension> initExtensions(List<String> requested, int maxDataOpcodes, int maxControlOpcodes, int maxReservedBits) {
        ArrayList<Extension> extensions = new ArrayList<Extension>();
        for (String rExt : requested) {
            QuotedStringTokenizer tok = new QuotedStringTokenizer(rExt, ";");
            String extName = tok.nextToken().trim();
            HashMap<String, String> parameters = new HashMap<String, String>();
            while (tok.hasMoreTokens()) {
                QuotedStringTokenizer nv = new QuotedStringTokenizer(tok.nextToken().trim(), "=");
                String name = nv.nextToken().trim();
                String value = nv.hasMoreTokens() ? nv.nextToken().trim() : null;
                parameters.put(name, value);
            }
            Extension extension = this.newExtension(extName);
            if (extension == null || !extension.init(parameters)) continue;
            LOG.debug("add {} {}", extName, parameters);
            extensions.add(extension);
        }
        LOG.debug("extensions={}", extensions);
        return extensions;
    }

    private Extension newExtension(String name) {
        try {
            Class<? extends Extension> extClass = this._extensionClasses.get(name);
            if (extClass != null) {
                return extClass.newInstance();
            }
        }
        catch (Exception e) {
            LOG.warn(e);
        }
        return null;
    }

    public static interface Acceptor {
        public WebSocket doWebSocketConnect(HttpServletRequest var1, String var2);

        public boolean checkOrigin(HttpServletRequest var1, String var2);
    }
}

