/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket;

import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.websocket.WebSocket;
import org.eclipse.jetty.websocket.WebSocketClient;

public class TestClient
implements WebSocket.OnFrame {
    private static WebSocketClient __client = new WebSocketClient();
    private static boolean _verbose = false;
    private static final Random __random = new Random();
    private final String _host;
    private final int _port;
    private final String _protocol;
    private final int _timeout;
    private static boolean __quiet;
    private static int __framesSent;
    private static int __messagesSent;
    private static AtomicInteger __framesReceived;
    private static AtomicInteger __messagesReceived;
    private static AtomicLong __totalTime;
    private static AtomicLong __minDuration;
    private static AtomicLong __maxDuration;
    private static long __start;
    private BlockingQueue<Long> _starts = new LinkedBlockingQueue<Long>();
    int _messageBytes;
    int _frames;
    byte _opcode = (byte)-1;
    private volatile WebSocket.FrameConnection _connection;
    private final CountDownLatch _handshook = new CountDownLatch(1);

    public void onOpen(WebSocket.Connection connection) {
    }

    public void onClose(int closeCode, String message) {
        this._handshook.countDown();
    }

    public boolean onFrame(byte flags, byte opcode, byte[] data, int offset, int length) {
        try {
            if (this._connection.isClose(opcode)) {
                return false;
            }
            __framesReceived.incrementAndGet();
            ++this._frames;
            this._messageBytes += length;
            if (this._opcode == -1) {
                this._opcode = opcode;
            }
            if (this._connection.isControl(opcode) || this._connection.isMessageComplete(flags)) {
                int recv = __messagesReceived.incrementAndGet();
                Long start = (Long)this._starts.poll();
                if (start != null) {
                    long duration = System.nanoTime() - start;
                    long max = __maxDuration.get();
                    while (duration > max && !__maxDuration.compareAndSet(max, duration)) {
                        max = __maxDuration.get();
                    }
                    long min = __minDuration.get();
                    while (duration < min && !__minDuration.compareAndSet(min, duration)) {
                        min = __minDuration.get();
                    }
                    __totalTime.addAndGet(duration);
                    if (!__quiet) {
                        System.out.printf("%d bytes from %s: frames=%d req=%d time=%.1fms opcode=0x%s\n", this._messageBytes, this._host, this._frames, recv, (double)duration / 1000000.0, TypeUtil.toHexString(this._opcode));
                    }
                }
                this._frames = 0;
                this._messageBytes = 0;
                this._opcode = (byte)-1;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public void onHandshake(WebSocket.FrameConnection connection) {
        this._connection = connection;
        this._handshook.countDown();
    }

    public TestClient(String host, int port, String protocol, int timeoutMS) throws Exception {
        this._host = host;
        this._port = port;
        this._protocol = protocol;
        this._timeout = timeoutMS;
    }

    private void open() throws Exception {
        WebSocketClient client = new WebSocketClient(__client);
        client.setProtocol(this._protocol);
        client.setMaxIdleTime(this._timeout);
        client.open(new URI("ws://" + this._host + ":" + this._port + "/"), this).get(10L, TimeUnit.SECONDS);
    }

    public void ping(byte opcode, byte[] data, int fragment) throws Exception {
        this._starts.add(System.nanoTime());
        int off = 0;
        int len = data.length;
        if (fragment > 0 && len > fragment) {
            len = fragment;
        }
        ++__messagesSent;
        while (off < data.length) {
            byte op;
            ++__framesSent;
            byte flags = (byte)(off + len == data.length ? 8 : 0);
            byte by = op = off == 0 ? opcode : (byte)0;
            if (_verbose) {
                System.err.printf("%s#addFrame %s|%s %s\n", this.getClass().getSimpleName(), TypeUtil.toHexString(flags), TypeUtil.toHexString(op), TypeUtil.toHexString(data, off, len));
            }
            this._connection.sendFrame(flags, op, data, off, len);
            if (data.length - (off += len) > len) {
                len = data.length - off;
            }
            if (fragment <= 0 || len <= fragment) continue;
            len = fragment;
        }
    }

    public void disconnect() throws Exception {
        if (this._connection != null) {
            this._connection.disconnect();
        }
    }

    private static void usage(String[] args) {
        System.err.println("ERROR: " + Arrays.asList(args));
        System.err.println("USAGE: java -cp CLASSPATH " + TestClient.class + " [ OPTIONS ]");
        System.err.println("  -h|--host HOST  (default localhost)");
        System.err.println("  -p|--port PORT  (default 8080)");
        System.err.println("  -b|--binary");
        System.err.println("  -v|--verbose");
        System.err.println("  -c|--count n    (default 10)");
        System.err.println("  -s|--size n     (default 64)");
        System.err.println("  -f|--fragment n (default 4000) ");
        System.err.println("  -P|--protocol echo|echo-assemble|echo-fragment|echo-broadcast");
        System.err.println("  -C|--clients n  (default 1) ");
        System.err.println("  -d|--delay n    (default 1000ms) ");
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        __client.start();
        String host = "localhost";
        int port = 8080;
        String protocol = null;
        int count = 10;
        int size = 64;
        int fragment = 4000;
        boolean binary = false;
        int clients = 1;
        int delay = 1000;
        for (int i = 0; i < args.length; ++i) {
            String a = args[i];
            if ("-p".equals(a) || "--port".equals(a)) {
                port = Integer.parseInt(args[++i]);
                continue;
            }
            if ("-h".equals(a) || "--host".equals(a)) {
                port = Integer.parseInt(args[++i]);
                continue;
            }
            if ("-c".equals(a) || "--count".equals(a)) {
                count = Integer.parseInt(args[++i]);
                continue;
            }
            if ("-s".equals(a) || "--size".equals(a)) {
                size = Integer.parseInt(args[++i]);
                continue;
            }
            if ("-f".equals(a) || "--fragment".equals(a)) {
                fragment = Integer.parseInt(args[++i]);
                continue;
            }
            if ("-P".equals(a) || "--protocol".equals(a)) {
                protocol = args[++i];
                continue;
            }
            if ("-v".equals(a) || "--verbose".equals(a)) {
                _verbose = true;
                continue;
            }
            if ("-b".equals(a) || "--binary".equals(a)) {
                binary = true;
                continue;
            }
            if ("-C".equals(a) || "--clients".equals(a)) {
                clients = Integer.parseInt(args[++i]);
                continue;
            }
            if ("-d".equals(a) || "--delay".equals(a)) {
                delay = Integer.parseInt(args[++i]);
                continue;
            }
            if ("-q".equals(a) || "--quiet".equals(a)) {
                __quiet = true;
                continue;
            }
            if (!a.startsWith("-")) continue;
            TestClient.usage(args);
        }
        TestClient[] client = new TestClient[clients];
        try {
            __start = System.currentTimeMillis();
            for (int i = 0; i < clients; ++i) {
                client[i] = new TestClient(host, port, protocol == null ? null : protocol, 60000);
                client[i].open();
            }
            System.out.println("Jetty WebSocket PING " + host + ":" + port + " (" + new InetSocketAddress(host, port) + ") " + clients + " clients");
            for (int p = 0; p < count; ++p) {
                long next = System.currentTimeMillis() + (long)delay;
                byte opcode = binary ? (byte)2 : 1;
                byte[] data = null;
                if (opcode == 1) {
                    StringBuilder b = new StringBuilder();
                    while (b.length() < size) {
                        b.append(65 + __random.nextInt(26));
                    }
                    data = b.toString().getBytes("UTF-8");
                } else {
                    data = new byte[size];
                    __random.nextBytes(data);
                }
                for (int i = 0; i < clients; ++i) {
                    client[i].ping(opcode, data, opcode == 9 ? -1 : fragment);
                }
                while (System.currentTimeMillis() < next) {
                    Thread.sleep(10L);
                }
            }
            Object var18_19 = null;
        }
        catch (Throwable throwable) {
            Object var18_20 = null;
            for (int i = 0; i < clients; ++i) {
                if (client[i] == null) continue;
                client[i].disconnect();
            }
            long duration = System.currentTimeMillis() - __start;
            System.out.println("--- " + host + " websocket ping statistics using " + clients + " connection" + (clients > 1 ? "s" : "") + " ---");
            System.out.println(__framesSent + " frames transmitted, " + __framesReceived + " received, " + __messagesSent + " messages transmitted, " + __messagesReceived + " received, " + "time " + duration + "ms " + 1000L * (long)__messagesReceived.get() / duration + " req/s");
            System.out.printf("rtt min/ave/max = %.3f/%.3f/%.3f ms\n", (double)__minDuration.get() / 1000000.0, __messagesReceived.get() == 0 ? 0.0 : (double)(__totalTime.get() / (long)__messagesReceived.get()) / 1000000.0, (double)__maxDuration.get() / 1000000.0);
            __client.stop();
            throw throwable;
        }
        for (int i = 0; i < clients; ++i) {
            if (client[i] == null) continue;
            client[i].disconnect();
        }
        {
        }
        long duration = System.currentTimeMillis() - __start;
        System.out.println("--- " + host + " websocket ping statistics using " + clients + " connection" + (clients > 1 ? "s" : "") + " ---");
        System.out.println(__framesSent + " frames transmitted, " + __framesReceived + " received, " + __messagesSent + " messages transmitted, " + __messagesReceived + " received, " + "time " + duration + "ms " + 1000L * (long)__messagesReceived.get() / duration + " req/s");
        System.out.printf("rtt min/ave/max = %.3f/%.3f/%.3f ms\n", (double)__minDuration.get() / 1000000.0, __messagesReceived.get() == 0 ? 0.0 : (double)(__totalTime.get() / (long)__messagesReceived.get()) / 1000000.0, (double)__maxDuration.get() / 1000000.0);
        __client.stop();
    }

    static {
        __framesReceived = new AtomicInteger();
        __messagesReceived = new AtomicInteger();
        __totalTime = new AtomicLong();
        __minDuration = new AtomicLong(Long.MAX_VALUE);
        __maxDuration = new AtomicLong(Long.MIN_VALUE);
    }
}

