/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.webapp;

import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.xml.XmlConfiguration;

public class JettyWebXmlConfiguration
implements Configuration {
    public void preConfigure(WebAppContext context) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure(WebAppContext context) throws Exception {
        Resource web_inf;
        if (context.isStarted()) {
            if (Log.isDebugEnabled()) {
                Log.debug("Cannot configure webapp after it is started");
            }
            return;
        }
        if (Log.isDebugEnabled()) {
            Log.debug("Configuring web-jetty.xml");
        }
        if ((web_inf = context.getWebInf()) != null && web_inf.isDirectory()) {
            Resource jetty = web_inf.addPath("jetty6-web.xml");
            if (!jetty.exists()) {
                jetty = web_inf.addPath("jetty-web.xml");
            }
            if (!jetty.exists()) {
                jetty = web_inf.addPath("web-jetty.xml");
            }
            if (jetty.exists()) {
                String[] old_server_classes = context.getServerClasses();
                try {
                    context.setServerClasses(null);
                    if (Log.isDebugEnabled()) {
                        Log.debug("Configure: " + jetty);
                    }
                    XmlConfiguration jetty_config = new XmlConfiguration(jetty.getURL());
                    jetty_config.configure(context);
                }
                finally {
                    if (context.getServerClasses() == null) {
                        context.setServerClasses(old_server_classes);
                    }
                }
            }
        }
    }

    public void postConfigure(WebAppContext context) throws Exception {
    }

    public void deconfigure(WebAppContext context) throws Exception {
    }
}

