/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.security;

import java.io.IOException;
import java.security.MessageDigest;
import java.util.Map;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.security.Authorization;
import org.eclipse.jetty.client.security.Realm;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.TypeUtil;

public class DigestAuthorization
implements Authorization {
    private static final String NC = "00000001";
    Realm securityRealm;
    Map details;

    public DigestAuthorization(Realm realm, Map details) {
        this.securityRealm = realm;
        this.details = details;
    }

    public void setCredentials(HttpExchange exchange) throws IOException {
        StringBuilder buffer = new StringBuilder().append("Digest");
        buffer.append(" ").append("username").append('=').append('\"').append(this.securityRealm.getPrincipal()).append('\"');
        buffer.append(", ").append("realm").append('=').append('\"').append(String.valueOf(this.details.get("realm"))).append('\"');
        buffer.append(", ").append("nonce").append('=').append('\"').append(String.valueOf(this.details.get("nonce"))).append('\"');
        buffer.append(", ").append("uri").append('=').append('\"').append(exchange.getURI()).append('\"');
        buffer.append(", ").append("algorithm").append('=').append(String.valueOf(this.details.get("algorithm")));
        String cnonce = this.newCnonce(exchange, this.securityRealm, this.details);
        buffer.append(", ").append("response").append('=').append('\"').append(this.newResponse(cnonce, exchange, this.securityRealm, this.details)).append('\"');
        buffer.append(", ").append("qop").append('=').append(String.valueOf(this.details.get("qop")));
        buffer.append(", ").append("nc").append('=').append(NC);
        buffer.append(", ").append("cnonce").append('=').append('\"').append(cnonce).append('\"');
        exchange.setRequestHeader("Authorization", new String(buffer.toString().getBytes(StringUtil.__ISO_8859_1)));
    }

    protected String newResponse(String cnonce, HttpExchange exchange, Realm securityRealm, Map details) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(securityRealm.getPrincipal().getBytes(StringUtil.__ISO_8859_1));
            md.update((byte)58);
            md.update(String.valueOf(details.get("realm")).getBytes(StringUtil.__ISO_8859_1));
            md.update((byte)58);
            md.update(securityRealm.getCredentials().getBytes(StringUtil.__ISO_8859_1));
            byte[] ha1 = md.digest();
            md.reset();
            md.update(exchange.getMethod().getBytes(StringUtil.__ISO_8859_1));
            md.update((byte)58);
            md.update(exchange.getURI().getBytes(StringUtil.__ISO_8859_1));
            byte[] ha2 = md.digest();
            md.update(TypeUtil.toString(ha1, 16).getBytes(StringUtil.__ISO_8859_1));
            md.update((byte)58);
            md.update(String.valueOf(details.get("nonce")).getBytes(StringUtil.__ISO_8859_1));
            md.update((byte)58);
            md.update(NC.getBytes(StringUtil.__ISO_8859_1));
            md.update((byte)58);
            md.update(cnonce.getBytes(StringUtil.__ISO_8859_1));
            md.update((byte)58);
            md.update(String.valueOf(details.get("qop")).getBytes(StringUtil.__ISO_8859_1));
            md.update((byte)58);
            md.update(TypeUtil.toString(ha2, 16).getBytes(StringUtil.__ISO_8859_1));
            byte[] digest = md.digest();
            return DigestAuthorization.encode(digest);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected String newCnonce(HttpExchange exchange, Realm securityRealm, Map details) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] b = md.digest(String.valueOf(System.currentTimeMillis()).getBytes(StringUtil.__ISO_8859_1));
            return DigestAuthorization.encode(b);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String encode(byte[] data) {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < data.length; ++i) {
            buffer.append(Integer.toHexString((data[i] & 0xF0) >>> 4));
            buffer.append(Integer.toHexString(data[i] & 0xF));
        }
        return buffer.toString();
    }
}

