/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui;

import com.sun.jdi.ClassNotLoadedException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.jdt.debug.core.IJavaArrayType;
import org.eclipse.jdt.debug.core.IJavaClassType;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.internal.debug.core.model.JDINullValue;
import org.eclipse.jdt.internal.debug.core.model.JDIObjectValue;
import org.eclipse.jdt.internal.debug.core.model.JDIPlaceholderValue;
import org.eclipse.jdt.internal.debug.core.model.JDIReferenceListVariable;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.JavaDetailFormattersManager;
import org.eclipse.jdt.internal.debug.ui.display.JavaInspectExpression;
import org.eclipse.ui.IActionFilter;

public class JavaVarActionFilter
implements IActionFilter {
    private static final Set<String> fgPrimitiveTypes = JavaVarActionFilter.initPrimitiveTypes();

    private static Set<String> initPrimitiveTypes() {
        HashSet<String> set = new HashSet<String>(8);
        set.add("short");
        set.add("int");
        set.add("long");
        set.add("float");
        set.add("double");
        set.add("boolean");
        set.add("byte");
        set.add("char");
        set.add("null");
        return set;
    }

    protected boolean isDeclaredSameAsConcrete(IJavaVariable var) {
        IValue value;
        block3: {
            try {
                value = var.getValue();
                if (!(value instanceof JDINullValue)) break block3;
                return false;
            }
            catch (DebugException e) {
                JDIDebugUIPlugin.log(e);
                return false;
            }
        }
        return !var.getReferenceTypeName().equals(value.getReferenceTypeName());
    }

    protected boolean isPrimitiveType(Object obj) {
        if (obj instanceof IJavaVariable) {
            try {
                return !fgPrimitiveTypes.contains(this.removeArray(((IJavaVariable)obj).getReferenceTypeName()));
            }
            catch (DebugException e) {
                if (!(e.getStatus().getException() instanceof ClassNotLoadedException)) {
                    JDIDebugUIPlugin.log(e);
                }
                return false;
            }
        }
        if (obj instanceof JavaInspectExpression) {
            try {
                JavaInspectExpression exp = (JavaInspectExpression)((Object)obj);
                IValue value = exp.getValue();
                if (value != null) {
                    return fgPrimitiveTypes.contains(this.removeArray(value.getReferenceTypeName()));
                }
            }
            catch (DebugException e) {
                JDIDebugUIPlugin.log(e);
            }
        }
        return false;
    }

    protected boolean isArrayType(Object object) {
        if (object instanceof IJavaVariable) {
            try {
                IJavaType type = ((IJavaVariable)object).getJavaType();
                if (type != null) {
                    return type instanceof IJavaArrayType;
                }
            }
            catch (DebugException e) {
                JDIDebugUIPlugin.log(e);
            }
        }
        return false;
    }

    protected boolean isValuePrimitiveType(IValue value) {
        try {
            return !fgPrimitiveTypes.contains(this.removeArray(value.getReferenceTypeName()));
        }
        catch (DebugException e) {
            JDIDebugUIPlugin.log(e);
            return false;
        }
    }

    protected String removeArray(String type) {
        int index;
        if (type != null && (index = type.indexOf(91)) > 0) {
            return type.substring(0, index);
        }
        return type;
    }

    public boolean testAttribute(Object target, String name, String value) {
        if (target instanceof IJavaVariable) {
            IJavaVariable var = (IJavaVariable)target;
            try {
                IValue varValue = var.getValue();
                if (name.equals("PrimitiveVariableActionFilter")) {
                    if (value.equals("isPrimitive")) {
                        return this.isPrimitiveType(var);
                    }
                    if (value.equals("isArray")) {
                        return this.isArrayType(var);
                    }
                    if (value.equals("isValuePrimitive")) {
                        return this.isValuePrimitiveType(varValue);
                    }
                }
                if (name.equals("JavaVariableFilter")) {
                    if (value.equals("isInstanceRetrievalAvailable")) {
                        return this.isInstanceRetrievalAvailable(var);
                    }
                    if (value.equals("isNullValue")) {
                        return varValue instanceof JDINullValue;
                    }
                    if (value.equals("isReferenceListVariable")) {
                        return var instanceof JDIReferenceListVariable;
                    }
                    if (value.equals("isPlaceholderValue")) {
                        return varValue instanceof JDIPlaceholderValue;
                    }
                    if (value.equals("isObjectValue")) {
                        return varValue != null && JDIObjectValue.class.isAssignableFrom(varValue.getClass());
                    }
                } else {
                    if (name.equals("ConcreteVariableActionFilter") && value.equals("isConcrete")) {
                        return this.isDeclaredSameAsConcrete(var);
                    }
                    if (name.equals("JavaVariableActionFilter")) {
                        if (value.equals("instanceFilter")) {
                            return !var.isStatic() && varValue instanceof IJavaObject && ((IJavaObject)varValue).getJavaType() instanceof IJavaClassType && ((IJavaDebugTarget)var.getDebugTarget()).supportsInstanceBreakpoints();
                        }
                        if (value.equals("isValidField")) {
                            return !var.isFinal() & !(var.isFinal() & var.isStatic());
                        }
                    } else if (name.equals("DetailFormatterFilter") && varValue instanceof IJavaObject) {
                        if (value.equals("isDefined")) {
                            return JavaDetailFormattersManager.getDefault().hasAssociatedDetailFormatter(((IJavaObject)varValue).getJavaType());
                        }
                        if (value.equals("inInterface")) {
                            return JavaDetailFormattersManager.getDefault().hasInterfaceDetailFormatter(((IJavaObject)varValue).getJavaType());
                        }
                        if (value.equals("inSuperclass")) {
                            return JavaDetailFormattersManager.getDefault().hasSuperclassDetailFormatter(((IJavaObject)varValue).getJavaType());
                        }
                    }
                }
            }
            catch (DebugException debugException) {}
        } else if (target instanceof JavaInspectExpression) {
            JavaInspectExpression exp = (JavaInspectExpression)((Object)target);
            if (name.equals("PrimitiveVariableActionFilter") && value.equals("isNotPrimitive")) {
                return !this.isPrimitiveType((Object)exp);
            }
            if (name.equals("DetailFormatterFilter")) {
                try {
                    IValue varValue = exp.getValue();
                    if (varValue instanceof IJavaObject) {
                        if (value.equals("isDefined")) {
                            return JavaDetailFormattersManager.getDefault().hasAssociatedDetailFormatter(((IJavaObject)varValue).getJavaType());
                        }
                        if (value.equals("inInterface")) {
                            return JavaDetailFormattersManager.getDefault().hasInterfaceDetailFormatter(((IJavaObject)varValue).getJavaType());
                        }
                        if (value.equals("inSuperclass")) {
                            return JavaDetailFormattersManager.getDefault().hasSuperclassDetailFormatter(((IJavaObject)varValue).getJavaType());
                        }
                    }
                }
                catch (DebugException debugException) {}
            }
        }
        return false;
    }

    protected boolean isInstanceRetrievalAvailable(IJavaVariable var) {
        return ((IJavaDebugTarget)var.getDebugTarget()).supportsInstanceRetrieval() && !(var instanceof JDIReferenceListVariable);
    }
}

