/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm.browsers;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.scm.EditType;
import hudson.scm.RepositoryBrowser;
import hudson.scm.SubversionChangeLogSet;
import hudson.scm.SubversionRepositoryBrowser;
import hudson.util.FormValidation;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class FishEyeSVN
extends SubversionRepositoryBrowser {
    public final URL url;
    private final String rootModule;
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public FishEyeSVN(URL url, String rootModule) throws MalformedURLException {
        this.url = FishEyeSVN.normalizeToEndWithSlash((URL)url);
        rootModule = rootModule.trim();
        if (rootModule.startsWith("/")) {
            rootModule = rootModule.substring(1);
        }
        if (rootModule.endsWith("/")) {
            rootModule = rootModule.substring(0, rootModule.length() - 1);
        }
        this.rootModule = rootModule;
    }

    public String getRootModule() {
        if (this.rootModule == null) {
            return "";
        }
        return this.rootModule;
    }

    public URL getDiffLink(SubversionChangeLogSet.Path path) throws IOException {
        if (path.getEditType() != EditType.EDIT) {
            return null;
        }
        int r = path.getLogEntry().getRevision();
        return new URL(this.url, this.getPath(path) + String.format("?r1=%d&r2=%d", r - 1, r));
    }

    public URL getFileLink(SubversionChangeLogSet.Path path) throws IOException {
        return new URL(this.url, this.getPath(path));
    }

    private String getPath(SubversionChangeLogSet.Path path) {
        String s = FishEyeSVN.trimHeadSlash((String)path.getValue());
        if (s.startsWith(this.rootModule)) {
            s = FishEyeSVN.trimHeadSlash((String)s.substring(this.rootModule.length()));
        }
        return s;
    }

    private String getProjectName() {
        String p = this.url.getPath();
        if (p.endsWith("/")) {
            p = p.substring(0, p.length() - 1);
        }
        int idx = p.lastIndexOf(47);
        return p.substring(idx + 1);
    }

    public URL getChangeSetLink(SubversionChangeLogSet.LogEntry changeSet) throws IOException {
        return new URL(this.url, "../../changelog/" + this.getProjectName() + "/?cs=" + changeSet.getRevision());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        FishEyeSVN that = (FishEyeSVN)((Object)o);
        return new EqualsBuilder().append((Object)this.url, (Object)that.url).append((Object)this.rootModule, (Object)that.rootModule).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.url).append((Object)this.rootModule).toHashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends Descriptor<RepositoryBrowser<?>> {
        private static final Pattern URL_PATTERN = Pattern.compile(".+/browse/[^/]+/");

        public String getDisplayName() {
            return "FishEye";
        }

        public FormValidation doCheckUrl(@QueryParameter(fixEmpty=true) String value) throws IOException, ServletException {
            if (value == null) {
                return FormValidation.ok();
            }
            if (!value.endsWith("/")) {
                value = value + '/';
            }
            if (!URL_PATTERN.matcher(value).matches()) {
                return FormValidation.errorWithMarkup((String)"The URL should end like <tt>.../browse/foobar/</tt>");
            }
            if (!Hudson.getInstance().hasPermission(Hudson.ADMINISTER)) {
                return FormValidation.ok();
            }
            final String finalValue = value;
            return new FormValidation.URLCheck(){

                protected FormValidation check() throws IOException, ServletException {
                    try {
                        if (this.findText(this.open(new URL(finalValue)), "FishEye")) {
                            return FormValidation.ok();
                        }
                        return FormValidation.error((String)"This is a valid URL but it doesn't look like FishEye");
                    }
                    catch (IOException e) {
                        return this.handleIOException(finalValue, e);
                    }
                }
            }.check();
        }
    }
}

