/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.vertx.example.base;

import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.proton.ProtonClientOptions;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.function.Consumer;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.message.Message;
import org.eclipse.hono.client.CommandClient;
import org.eclipse.hono.client.HonoClient;
import org.eclipse.hono.client.impl.HonoClientImpl;
import org.eclipse.hono.config.ClientConfigProperties;
import org.eclipse.hono.util.MessageHelper;
import org.eclipse.hono.util.MessageTap;
import org.eclipse.hono.util.TimeUntilDisconnectNotification;

public class HonoConsumerBase {
    public static final String HONO_CLIENT_USER = "consumer@HONO";
    public static final String HONO_CLIENT_PASSWORD = "verysecret";
    private final Vertx vertx = Vertx.vertx();
    private final HonoClient honoClient;
    private MODE mode = MODE.TELEMETRY;

    public HonoConsumerBase() {
        ClientConfigProperties props = new ClientConfigProperties();
        props.setHost("127.0.0.1");
        props.setPort(15671);
        props.setUsername(HONO_CLIENT_USER);
        props.setPassword(HONO_CLIENT_PASSWORD);
        props.setTrustStorePath("target/config/hono-demo-certs-jar/trusted-certs.pem");
        props.setHostnameVerificationRequired(false);
        this.honoClient = new HonoClientImpl(this.vertx, props);
    }

    protected void consumeData() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        Future consumerFuture = Future.future();
        consumerFuture.setHandler(result -> {
            if (!result.succeeded()) {
                System.err.println("honoClient could not create telemetry consumer for 127.0.0.1:15671 : " + result.cause());
            }
            latch.countDown();
        });
        this.honoClient.connect(new ProtonClientOptions()).compose(connectedClient -> {
            switch (this.mode) {
                case EVENT: {
                    Consumer eventHandler = MessageTap.getConsumer(this::handleEventMessage, this::handleCommandReadinessNotification);
                    return connectedClient.createEventConsumer("DEFAULT_TENANT", eventHandler, closeHook -> System.err.println("remotely detached consumer link"));
                }
                case TELEMETRY: {
                    Consumer telemetryHandler = MessageTap.getConsumer(this::handleTelemetryMessage, this::handleCommandReadinessNotification);
                    return connectedClient.createTelemetryConsumer("DEFAULT_TENANT", telemetryHandler, closeHook -> System.err.println("remotely detached consumer link"));
                }
            }
            return null;
        }).setHandler(consumerFuture.completer());
        latch.await();
        if (consumerFuture.succeeded()) {
            System.in.read();
        }
        this.vertx.close();
    }

    private void printMessage(String tenantId, Message msg, String messageType) {
        String content = ((Data)msg.getBody()).getValue().toString();
        String deviceId = MessageHelper.getDeviceId((Message)msg);
        StringBuilder sb = new StringBuilder("received ").append(messageType).append(" [tenant: ").append(tenantId).append(", device: ").append(deviceId).append(", content-type: ").append(msg.getContentType()).append(" ]: ").append(content);
        System.out.println(sb.toString());
    }

    private void handleCommandReadinessNotification(TimeUntilDisconnectNotification notification) {
        System.out.println(String.format("Device is ready to receive a command : <%s>.", notification.toString()));
        String tenantId = notification.getTenantId();
        String deviceId = notification.getDeviceId();
        this.honoClient.getOrCreateCommandClient(tenantId, deviceId).map(commandClient -> {
            JsonObject jsonCmd = new JsonObject().put("brightness", Integer.valueOf((int)(Math.random() * 100.0)));
            Buffer commandBuffer = Buffer.buffer((String)jsonCmd.encodePrettily());
            this.sendCommandToAdapter((CommandClient)commandClient, commandBuffer);
            return commandClient;
        }).otherwise(t -> {
            System.err.println(String.format("Could not create command client : %s", t.getMessage()));
            return null;
        });
    }

    private void sendCommandToAdapter(CommandClient commandClient, Buffer commandBuffer) {
        commandClient.sendCommand("setBrightness", commandBuffer).map(result -> {
            System.out.println(String.format("Successfully sent command and received response: %s", Optional.ofNullable(result).orElse(Buffer.buffer()).toString()));
            commandClient.close(v -> {});
            return result;
        }).otherwise(t -> {
            System.out.println(String.format("Could not send command or did not receive a response : %s", t.getMessage()));
            commandClient.close(v -> {});
            return null;
        });
    }

    private void handleTelemetryMessage(Message msg) {
        this.printMessage("DEFAULT_TENANT", msg, "telemetry");
    }

    private void handleEventMessage(Message msg) {
        this.printMessage("DEFAULT_TENANT", msg, "event");
    }

    public MODE getMode() {
        return this.mode;
    }

    public void setMode(MODE value) {
        this.mode = value;
    }

    public static enum MODE {
        TELEMETRY,
        EVENT;

    }
}

