/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.example;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.proton.ProtonConnection;
import javax.annotation.PostConstruct;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.message.Message;
import org.eclipse.hono.client.MessageConsumer;
import org.eclipse.hono.example.AbstractExampleClient;
import org.eclipse.hono.util.MessageHelper;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"receiver"})
public class ExampleReceiver
extends AbstractExampleClient {
    private static final String PROFILE_TELEMETRY = "telemetry";
    private static final String PROFILE_EVENT = "event";

    @PostConstruct
    private void start() {
        Future startupTracker = Future.future();
        startupTracker.setHandler(startup -> {
            if (startup.succeeded()) {
                String consumerType = this.activeProfiles.contains(PROFILE_EVENT) ? PROFILE_EVENT : PROFILE_TELEMETRY;
                this.LOG.info("Receiver [tenant: {}, type: {}] created successfully, hit ctrl-c to exit", (Object)this.tenantId, (Object)consumerType);
            } else {
                this.LOG.error("Error occurred during initialization of receiver: {}", (Object)startup.cause().getMessage());
                this.vertx.close();
            }
        });
        Future connectionTracker = Future.future();
        this.client.connect(this.getClientOptions(), connectionTracker.completer(), this::onDisconnect);
        connectionTracker.compose(honoClient -> this.onConnectionEstablished((Handler<AsyncResult<MessageConsumer>>)startupTracker.completer()), startupTracker);
    }

    private void onConnectionEstablished(Handler<AsyncResult<MessageConsumer>> handler) {
        if (this.activeProfiles.contains(PROFILE_EVENT)) {
            this.client.createEventConsumer(this.tenantId, msg -> this.handleMessage(PROFILE_EVENT, (Message)msg), handler);
        } else {
            this.client.createTelemetryConsumer(this.tenantId, msg -> this.handleMessage(PROFILE_TELEMETRY, (Message)msg), handler);
        }
    }

    private void onDisconnect(ProtonConnection con) {
        this.vertx.setTimer(1000L, reconnect -> {
            this.LOG.info("attempting to re-connect to Hono ...");
            this.client.connect(this.getClientOptions(), connectionAttempt -> this.onConnectionEstablished((Handler<AsyncResult<MessageConsumer>>)((Handler)done -> {})), this::onDisconnect);
        });
    }

    private void handleMessage(String endpoint, Message msg) {
        String deviceId = MessageHelper.getDeviceId((Message)msg);
        Section body = msg.getBody();
        String content = null;
        if (body instanceof Data) {
            content = ((Data)msg.getBody()).getValue().toString();
        } else if (body instanceof AmqpValue) {
            content = ((AmqpValue)msg.getBody()).getValue().toString();
        }
        this.LOG.info("received {} message [device: {}, content-type: {}]: {}", new Object[]{endpoint, deviceId, msg.getContentType(), content});
        if (msg.getApplicationProperties() != null) {
            this.LOG.info("... with application properties: {}", (Object)msg.getApplicationProperties().getValue());
        }
    }
}

