/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.pubsub;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.pubsub.v1.stub.PublisherStubSettings;
import com.google.pubsub.v1.PubsubMessage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public final class PubSubMessageHelper {
    public static final String PUBSUB_PROPERTY_PROJECT_ID = "projectId";
    public static final String PUBSUB_PROPERTY_RESPONSE_REQUIRED = "response-required";
    public static final String DELIVERY_FAILURE_NOTIFICATION_METADATA_PREFIX = "delivery-failure-notification-metadata";

    private PubSubMessageHelper() {
    }

    public static Optional<CredentialsProvider> getCredentialsProvider() {
        return Optional.ofNullable(PubSubMessageHelper.getCredentials()).map(FixedCredentialsProvider::create);
    }

    private static GoogleCredentials getCredentials() {
        try {
            return GoogleCredentials.getApplicationDefault().createScoped((Collection)PublisherStubSettings.getDefaultServiceScopes());
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String getTopicName(String topic, String prefix) {
        return PubSubMessageHelper.getTopicName(topic, prefix, Collections.emptyList());
    }

    public static String getTopicName(String topic, String prefix, List<String> subtopics) {
        StringBuilder topicBuilder = new StringBuilder();
        topicBuilder.append(prefix).append(".").append(topic);
        for (String subtopic : subtopics) {
            topicBuilder.append(".").append(subtopic);
        }
        return topicBuilder.toString();
    }

    public static List<String> getSubtopics(String origAddress) {
        String trimmedOrigAddress = origAddress.startsWith("/") ? origAddress.substring(1) : origAddress;
        ArrayList<String> origAddressSplit = new ArrayList<String>(Arrays.stream(trimmedOrigAddress.split("/")).toList());
        if (origAddressSplit.size() < 4) {
            return Collections.emptyList();
        }
        origAddressSplit.subList(0, 3).clear();
        if (((String)origAddressSplit.get(origAddressSplit.size() - 1)).startsWith("?")) {
            origAddressSplit.remove(origAddressSplit.size() - 1);
        }
        return Collections.unmodifiableList(origAddressSplit);
    }

    public static String getSubFolder(List<String> subtopics) {
        return String.join((CharSequence)"/", subtopics);
    }

    public static String getTopicEndpointFromTopic(String topic, String tenantId) {
        String topicWithoutTenant = topic.replace(tenantId, "");
        String[] fallbackTopics = topicWithoutTenant.split("\\.");
        if (fallbackTopics.length <= 2) {
            return null;
        }
        return fallbackTopics[1];
    }

    public static byte[] getPayload(PubsubMessage message) {
        Objects.requireNonNull(message);
        return message.getData().toByteArray();
    }

    public static Optional<String> getDeviceId(Map<String, String> attributesMap) {
        return PubSubMessageHelper.getAttributesValue(attributesMap, "device_id");
    }

    public static Optional<String> getTenantId(Map<String, String> attributesMap) {
        return PubSubMessageHelper.getAttributesValue(attributesMap, "tenant_id");
    }

    public static Optional<String> getCorrelationId(Map<String, String> attributesMap) {
        return PubSubMessageHelper.getAttributesValue(attributesMap, "correlation-id");
    }

    public static boolean isResponseRequired(Map<String, String> attributesMap) {
        return Boolean.parseBoolean(PubSubMessageHelper.getAttributesValue(attributesMap, PUBSUB_PROPERTY_RESPONSE_REQUIRED).orElse("false"));
    }

    public static Optional<String> getContentType(Map<String, String> attributesMap) {
        return PubSubMessageHelper.getAttributesValue(attributesMap, "content-type");
    }

    public static Optional<String> getSubject(Map<String, String> attributesMap) {
        return PubSubMessageHelper.getAttributesValue(attributesMap, "subject");
    }

    public static Map<String, String> getDeliveryFailureNotificationMetadata(Map<String, String> attributesMap) {
        Objects.requireNonNull(attributesMap);
        return attributesMap.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(DELIVERY_FAILURE_NOTIFICATION_METADATA_PREFIX)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static Optional<String> getVia(Map<String, String> attributesMap) {
        return PubSubMessageHelper.getAttributesValue(attributesMap, "via");
    }

    private static Optional<String> getAttributesValue(Map<String, String> attributesMap, String key) {
        Objects.requireNonNull(attributesMap);
        Objects.requireNonNull(key);
        return Optional.ofNullable(attributesMap.get(key));
    }
}

