/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.notification;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.MessageCodec;
import io.vertx.core.tracing.TracingPolicy;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import org.eclipse.hono.notification.AbstractNotification;
import org.eclipse.hono.notification.NotificationType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationEventBusSupport {
    private static final Logger LOG = LoggerFactory.getLogger(NotificationEventBusSupport.class);
    private static final String NOTIFICATION_EVENT_BUS_CONTAINER_LOCAL_CODEC = "NotificationEventBusContainerLocalCodec";
    private static final Map<Vertx, Boolean> VERTX_INSTANCES_WITH_REGISTERED_CODEC_MAP = Collections.synchronizedMap(new WeakHashMap());

    private NotificationEventBusSupport() {
    }

    public static <T extends AbstractNotification> void registerConsumer(Vertx vertx, NotificationType<T> notificationType, Handler<T> consumer) {
        Objects.requireNonNull(vertx);
        Objects.requireNonNull(notificationType);
        Objects.requireNonNull(consumer);
        vertx.eventBus().consumer(NotificationEventBusSupport.getEventBusAddress(notificationType), msg -> {
            AbstractNotification notification = (AbstractNotification)msg.body();
            if (notification != null && notificationType.equals(notification.getType())) {
                consumer.handle((Object)notification);
            } else {
                LOG.warn("got event bus message with unexpected body on address [{}]", (Object)NotificationEventBusSupport.getEventBusAddress(notificationType));
            }
        });
    }

    public static <T extends AbstractNotification> Handler<T> getNotificationSender(Vertx vertx) {
        Objects.requireNonNull(vertx);
        if (VERTX_INSTANCES_WITH_REGISTERED_CODEC_MAP.putIfAbsent(vertx, true) == null) {
            vertx.eventBus().registerCodec((MessageCodec)new NotificationEventBusContainerLocalCodec());
        }
        return notification -> NotificationEventBusSupport.sendNotification(vertx, notification);
    }

    private static <T extends AbstractNotification> void sendNotification(Vertx vertx, T notification) {
        Objects.requireNonNull(vertx);
        Objects.requireNonNull(notification);
        DeliveryOptions options = new DeliveryOptions();
        options.setCodecName(NOTIFICATION_EVENT_BUS_CONTAINER_LOCAL_CODEC);
        options.setLocalOnly(true);
        options.setTracingPolicy(TracingPolicy.IGNORE);
        vertx.eventBus().publish(NotificationEventBusSupport.getEventBusAddress(notification.getType()), notification, options);
    }

    public static <T extends AbstractNotification> String getEventBusAddress(NotificationType<T> notificationType) {
        return "notification." + notificationType.getTypeName();
    }

    static class NotificationEventBusContainerLocalCodec
    implements MessageCodec<AbstractNotification, AbstractNotification> {
        NotificationEventBusContainerLocalCodec() {
        }

        public void encodeToWire(Buffer buffer, AbstractNotification t) {
            throw new UnsupportedOperationException(this.name() + " can only be used for local delivery");
        }

        public AbstractNotification decodeFromWire(int pos, Buffer buffer) {
            throw new UnsupportedOperationException(this.name() + " can only be used for local delivery");
        }

        public AbstractNotification transform(AbstractNotification instance) {
            return instance;
        }

        public String name() {
            return NotificationEventBusSupport.NOTIFICATION_EVENT_BUS_CONTAINER_LOCAL_CODEC;
        }

        public byte systemCodecID() {
            return -1;
        }
    }
}

