/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.command;

import io.opentracing.Span;
import io.opentracing.tag.Tags;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.hono.client.command.Command;
import org.eclipse.hono.client.command.CommandContext;
import org.eclipse.hono.client.command.CommandResponse;
import org.eclipse.hono.client.command.CommandResponseSender;
import org.eclipse.hono.tracing.TracingHelper;
import org.eclipse.hono.util.MapBasedExecutionContext;
import org.eclipse.hono.util.MessagingType;
import org.eclipse.hono.util.RegistrationAssertion;
import org.eclipse.hono.util.TenantObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCommandContext<T extends Command>
extends MapBasedExecutionContext
implements CommandContext {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractCommandContext.class);
    protected final T command;
    private final CommandResponseSender commandResponseSender;
    private String completedOutcome;

    public AbstractCommandContext(Span span, T command, CommandResponseSender commandResponseSender) {
        super(span);
        this.command = (Command)Objects.requireNonNull(command);
        this.commandResponseSender = Objects.requireNonNull(commandResponseSender);
    }

    @Override
    public final boolean isCompleted() {
        return this.completedOutcome != null;
    }

    @Override
    public void logCommandToSpan(Span span) {
        this.command.logToSpan(span);
    }

    public T getCommand() {
        return this.command;
    }

    @Override
    public void accept() {
        if (!this.setCompleted("accepted")) {
            return;
        }
        Span span = this.getTracingSpan();
        LOG.debug("accepted command message [{}]", this.getCommand());
        Tags.HTTP_STATUS.set(span, Integer.valueOf(202));
        span.log("command for device handled with outcome 'accepted'");
        span.finish();
    }

    protected boolean setCompleted(String outcome) {
        if (this.completedOutcome != null) {
            LOG.warn("can't apply '{}' outcome, context already completed with '{}' outcome [{}]", new Object[]{outcome, this.completedOutcome, this.getCommand()});
            return false;
        }
        this.completedOutcome = outcome;
        return true;
    }

    protected boolean isRequestResponseCommand() {
        return !this.command.isOneWay();
    }

    protected Future<Void> sendDeliveryFailureCommandResponseMessage(int status, String error, Span span, Throwable cause, String correlationId, MessagingType messagingType) {
        if (correlationId == null) {
            TracingHelper.logError((Span)span, (String)"can't send command response message - no correlation id set");
            return Future.failedFuture((String)"missing correlation id");
        }
        JsonObject payloadJson = new JsonObject();
        payloadJson.put("error", (Object)(error != null ? error : ""));
        CommandResponse commandResponse = new CommandResponse(this.command.getTenant(), this.command.getDeviceId(), payloadJson.toBuffer(), "application/vnd.eclipse-hono-delivery-failure-notification+json", status, correlationId, "", messagingType);
        commandResponse.setAdditionalProperties(Collections.unmodifiableMap(this.command.getDeliveryFailureNotificationProperties()));
        return this.commandResponseSender.sendCommandResponse(Optional.ofNullable(this.get("tenant-config")).filter(TenantObject.class::isInstance).map(TenantObject.class::cast).orElseGet(() -> TenantObject.from((String)this.command.getTenant())), new RegistrationAssertion(this.command.getDeviceId()), commandResponse, span.context()).onFailure(thr -> {
            LOG.debug("failed to publish command response [{}]", (Object)commandResponse, thr);
            TracingHelper.logError((Span)span, (String)"failed to publish command response message", (Throwable)thr);
        }).onSuccess(v -> {
            LOG.debug("published error command response [{}, cause: {}]", (Object)commandResponse, (Object)(cause != null ? cause.getMessage() : error));
            span.log("published error command response");
        });
    }
}

