/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.command;

import io.opentracing.SpanContext;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import java.util.Objects;
import java.util.function.Function;
import org.eclipse.hono.client.command.CommandContext;

public final class CommandHandlerWrapper {
    private final String tenantId;
    private final String deviceId;
    private final String gatewayId;
    private final Function<CommandContext, Future<Void>> commandHandler;
    private final Context context;
    private final SpanContext consumerCreationSpanContext;

    public CommandHandlerWrapper(String tenantId, String deviceId, String gatewayId, Function<CommandContext, Future<Void>> commandHandler, Context context, SpanContext consumerCreationSpanContext) {
        this.tenantId = Objects.requireNonNull(tenantId);
        this.deviceId = Objects.requireNonNull(deviceId);
        this.gatewayId = gatewayId;
        this.commandHandler = Objects.requireNonNull(commandHandler);
        this.context = context;
        this.consumerCreationSpanContext = consumerCreationSpanContext;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getGatewayId() {
        return this.gatewayId;
    }

    public SpanContext getConsumerCreationSpanContext() {
        return this.consumerCreationSpanContext;
    }

    public Future<Void> handleCommand(CommandContext commandContext) {
        if (this.context == null || Vertx.currentContext() == this.context) {
            return this.commandHandler.apply(commandContext);
        }
        Promise resultPromise = Promise.promise();
        this.context.runOnContext(go -> this.commandHandler.apply(commandContext).onComplete((Handler)resultPromise));
        return resultPromise.future();
    }

    public String toString() {
        return "CommandHandlerWrapper{tenantId='" + this.tenantId + "', deviceId='" + this.deviceId + "'" + (String)(this.gatewayId != null ? ", gatewayId='" + this.gatewayId + "'" : "") + "}";
    }
}

