/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawkbit.app;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.autoconfigure.web.servlet.error.BasicErrorController;
import org.springframework.boot.web.servlet.error.ErrorAttributes;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class ErrorController
extends BasicErrorController {
    private static final String PATH = "path";

    public ErrorController(ErrorAttributes errorAttributes, ServerProperties serverProperties) {
        super(errorAttributes, serverProperties.getError());
    }

    @RequestMapping(produces={"application/octet-stream"})
    public ResponseEntity<Void> errorStream(HttpServletRequest request, HttpServletResponse response) {
        HttpStatus status = this.getStatus(request);
        return new ResponseEntity(status);
    }

    @RequestMapping
    public ResponseEntity<Map<String, Object>> error(HttpServletRequest request) {
        HttpStatus status = this.getStatus(request);
        Map body = this.getErrorAttributesWithoutPath(request);
        return new ResponseEntity((Object)body, status);
    }

    private Map<String, Object> getErrorAttributesWithoutPath(HttpServletRequest request) {
        Map body = this.getErrorAttributes(request, this.isIncludeStackTrace(request, MediaType.ALL));
        if (body != null && body.containsKey(PATH)) {
            body.remove(PATH);
        }
        return body;
    }
}

