/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.ecl.trace;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.epsilon.common.concurrent.ConcurrencyUtils;
import org.eclipse.epsilon.ecl.dom.MatchRule;
import org.eclipse.epsilon.ecl.trace.Match;
import org.eclipse.epsilon.eol.execute.context.IEolContext;

public class MatchTrace
implements Collection<Match> {
    protected Collection<Match> matches;
    protected boolean concurrent;
    protected String toStringCached;

    public MatchTrace() {
        this(false);
    }

    public MatchTrace(boolean concurrent) {
        this.concurrent = concurrent;
        this.matches = this.concurrent ? ConcurrencyUtils.concurrentOrderedCollection() : new ArrayList();
    }

    public MatchTrace(MatchTrace copy) {
        this(Objects.requireNonNull(copy).concurrent);
        this.matches.addAll(copy.matches);
    }

    public MatchTrace getReduced() {
        MatchTrace reduced = new MatchTrace(this.concurrent);
        for (Match match : this.matches) {
            if (!match.isMatching()) continue;
            reduced.add(match);
        }
        return reduced;
    }

    public Match add(Object left, Object right, boolean matching, MatchRule rule) {
        Match match = new Match(left, right, matching, rule);
        this.add(match);
        return match;
    }

    public Match getMatch(Object left, Object right) {
        for (Match match : this.matches) {
            if (!match.contains(left, right)) continue;
            return match;
        }
        return null;
    }

    public Collection<Match> getMatches(Object object) {
        return this.matches.stream().filter(match -> match.isMatching() && match.contains(object)).collect(Collectors.toList());
    }

    public Match getMatch(Object object) {
        for (Match match : this.matches) {
            if (!match.contains(object) || !match.isMatching()) continue;
            return match;
        }
        return null;
    }

    public Match getMatch(Object left, MatchRule rule) {
        for (Match match : this.matches) {
            if (!match.isMatching() || match.left != left || match.getRule() != rule) continue;
            return match;
        }
        return null;
    }

    public boolean hasBeenMatched(Object object) {
        for (Match match : this.matches) {
            if (!match.contains(object)) continue;
            return true;
        }
        return false;
    }

    public String toString(IEolContext context) {
        String str = "";
        for (Match match : this.matches) {
            str = String.valueOf(str) + "[" + match.isMatching() + "]\n";
            str = String.valueOf(str) + context.getPrettyPrinterManager().toString(match.getLeft());
            str = String.valueOf(str) + "\n ->" + context.getPrettyPrinterManager().toString(match.getRight());
        }
        this.toStringCached = str = String.valueOf(str) + "\n-------------------------------------------";
        return this.toStringCached;
    }

    public Collection<Match> getMatches() {
        return Collections.unmodifiableCollection(this.matches);
    }

    @Override
    public Stream<Match> stream() {
        return this.matches.stream();
    }

    public String toString() {
        return this.toStringCached != null ? this.toStringCached : super.toString();
    }

    @Override
    public int hashCode() {
        return this.matches.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MatchTrace)) {
            return false;
        }
        MatchTrace other = (MatchTrace)obj;
        return this.matches.size() == other.matches.size() && this.matches.containsAll(other.matches);
    }

    @Override
    public boolean add(Match match) {
        return this.matches.add(match);
    }

    @Override
    public boolean remove(Object o) {
        return this.matches.remove(o);
    }

    @Override
    public int size() {
        return this.matches.size();
    }

    @Override
    public boolean isEmpty() {
        return this.matches.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.matches.contains(o);
    }

    @Override
    public Iterator<Match> iterator() {
        return this.matches.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.matches.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.matches.toArray(a);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.matches.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends Match> c) {
        return this.matches.addAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.matches.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.matches.retainAll(c);
    }

    @Override
    public void clear() {
        this.matches.clear();
    }

    @Override
    public Stream<Match> parallelStream() {
        return this.matches.parallelStream();
    }
}

