/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.ecl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.epsilon.ecl.dom.MatchRule;
import org.eclipse.epsilon.ecl.execute.context.IEclContext;
import org.eclipse.epsilon.ecl.trace.Match;
import org.eclipse.epsilon.ecl.trace.MatchTrace;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.erl.IErlModule;

public interface IEclModule
extends IErlModule {
    public List<MatchRule> getMatchRules();

    public List<MatchRule> getDeclaredMatchRules();

    public MatchTrace execute() throws EolRuntimeException;

    default public IEclContext getContext() {
        return (IEclContext)super.getContext();
    }

    public void matchModels() throws EolRuntimeException;

    default public Match match(Object left, Object right, boolean forcedMatch) throws EolRuntimeException {
        IEclContext context = this.getContext();
        Match traceMatch = context.getMatchTrace().getMatch(left, right);
        if (traceMatch != null) {
            return traceMatch;
        }
        List<MatchRule> matchRules = this.getRulesFor(left, right, context, true);
        if (!matchRules.isEmpty()) {
            MatchRule matchRule = (MatchRule)((Object)matchRules.iterator().next());
            return matchRule.match(left, right, context, null, forcedMatch);
        }
        matchRules = this.getRulesFor(left, right, context, false);
        Match match = new Match(left, right, !matchRules.isEmpty(), null);
        for (MatchRule matchRule : matchRules) {
            if (!matchRule.isGreedy((IEolContext)context)) continue;
            Match tempMatch = matchRule.match(left, right, context, match.getInfo(), forcedMatch);
            match.setMatching(match.isMatching() && tempMatch.isMatching());
            match.setRule(matchRule);
        }
        context.getMatchTrace().add(match);
        return match;
    }

    default public List<MatchRule> getRulesFor(Object left, Object right, IEclContext context, boolean ofClassOnly) throws EolRuntimeException {
        ArrayList<MatchRule> rules = new ArrayList<MatchRule>();
        for (MatchRule matchRule : this.getMatchRules()) {
            if (matchRule.isAbstract((IEolContext)context) || !matchRule.appliesTo(left, right, context, ofClassOnly)) continue;
            rules.add(matchRule);
        }
        return rules;
    }
}

