/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.ecl.execute.operations;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.util.CollectionUtil;
import org.eclipse.epsilon.ecl.execute.context.IEclContext;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.operations.simple.SimpleOperation;
import org.eclipse.epsilon.eol.types.EolBag;
import org.eclipse.epsilon.eol.types.EolOrderedSet;

public class MatchesOperation
extends SimpleOperation {
    protected boolean forcedMatch = false;

    protected boolean matchInstances(Object left, Object right, IEclContext context) throws EolRuntimeException {
        return context.getModule().match(left, right, this.forcedMatch).isMatching();
    }

    protected boolean matchCollectionOrdered(Collection<?> leftColFlat, Collection<?> rightColFlat, IEclContext context) throws EolRuntimeException {
        Iterator<?> lit = leftColFlat.iterator();
        Iterator<?> rit = rightColFlat.iterator();
        while (lit.hasNext() && rit.hasNext()) {
            if (this.matchInstances(lit.next(), rit.next(), context)) continue;
            return false;
        }
        return true;
    }

    protected boolean matchCollectionUnordered(Collection<?> leftColFlat, Collection<?> rightColFlat, IEclContext context) throws EolRuntimeException {
        boolean match = true;
        for (Object left : leftColFlat) {
            match = false;
            for (Object right : rightColFlat) {
                match = this.matchInstances(left, right, context);
                if (match) break;
            }
            if (!match) break;
        }
        return match;
    }

    public Boolean execute(Object source, List<?> parameters, IEolContext context_, ModuleElement ast) throws EolRuntimeException {
        IEclContext context = (IEclContext)context_;
        Object parameter = parameters.get(0);
        if (source == parameter || source.equals(parameter)) {
            return true;
        }
        if (source instanceof Collection && parameter instanceof Collection) {
            Collection rightColFlat;
            Collection leftCol = (Collection)source;
            Collection rightCol = (Collection)parameter;
            Collection leftColFlat = CollectionUtil.flatten((Collection)leftCol);
            if (leftColFlat.equals(rightColFlat = CollectionUtil.flatten((Collection)rightCol))) {
                return true;
            }
            if (leftColFlat.size() != rightColFlat.size()) {
                return false;
            }
            if ((leftCol instanceof Set || leftCol instanceof EolBag) && !(leftCol instanceof EolOrderedSet) && (rightCol instanceof Set || rightCol instanceof EolBag) && !(rightCol instanceof EolOrderedSet)) {
                return this.matchCollectionUnordered(leftColFlat, rightColFlat, context);
            }
            return this.matchCollectionOrdered(leftColFlat, rightColFlat, context);
        }
        if (source instanceof Collection ^ parameter instanceof Collection) {
            return false;
        }
        return this.matchInstances(source, parameter, context);
    }
}

