/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edit.ui;

import com.google.gwt.cell.client.AbstractCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.FocusEvent;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.user.cellview.client.CellTree;
import com.google.gwt.user.cellview.client.TreeNode;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.DockLayoutPanel;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.SplitLayoutPanel;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Tree;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.datepicker.client.DateBox;
import com.google.gwt.view.client.AbstractDataProvider;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.ListDataProvider;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SelectionModel;
import com.google.gwt.view.client.SingleSelectionModel;
import com.google.gwt.view.client.TreeViewModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.Callback;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIService;
import org.eclipse.emf.ecore.resource.URIServiceAsync;
import org.eclipse.emf.ecore.resource.URIServiceCallback;
import org.eclipse.emf.ecore.resource.impl.BinaryResourceImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceFactoryImpl;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.CopyToClipboardCommand;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.command.CutToClipboardCommand;
import org.eclipse.emf.edit.command.DeleteCommand;
import org.eclipse.emf.edit.command.MoveCommand;
import org.eclipse.emf.edit.command.PasteFromClipboardCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.ItemProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EditorEntryPoint
implements EntryPoint {
    public void onModuleLoad() {
        ComposedAdapterFactory composedAdapterFactory = new ComposedAdapterFactory();
        composedAdapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        this.configureItemProviderAdapterFactories(composedAdapterFactory);
        composedAdapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        final BasicCommandStack commandStack = new BasicCommandStack();
        final AdapterFactoryEditingDomain editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)composedAdapterFactory, (CommandStack)commandStack);
        final ResourceSet resourceSet = editingDomain.getResourceSet();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new ResourceFactoryImpl(){

            public Resource createResource(URI uri) {
                return new BinaryResourceImpl(uri);
            }
        });
        URIServiceAsync uriService = (URIServiceAsync)GWT.create(URIService.class);
        URIServiceCallback uriServiceCallback = new URIServiceCallback(uriService);
        resourceSet.getURIConverter().getURIHandlers().add((Object)uriServiceCallback);
        final ArrayList originalResources = new ArrayList();
        Resource listingResource = resourceSet.getResource(URI.createURI((String)"datastore:/"), (Callback)new Callback<Resource>(){

            public void onFailure(Throwable caught) {
                System.err.println("Failed");
                caught.printStackTrace();
            }

            public void onSuccess(Resource result) {
                EAnnotation eAnnotation = (EAnnotation)result.getContents().get(0);
                for (Map.Entry entry : eAnnotation.getDetails()) {
                    resourceSet.createResource(URI.createURI((String)((String)entry.getKey())));
                }
                originalResources.clear();
                originalResources.addAll(resourceSet.getResources());
            }
        });
        resourceSet.getResources().remove((Object)listingResource);
        this.registerPackages(resourceSet.getPackageRegistry());
        final AdapterFactoryItemDelegator itemDelegator = new AdapterFactoryItemDelegator((AdapterFactory)composedAdapterFactory);
        DockLayoutPanel mainPanel = new DockLayoutPanel(Style.Unit.PX);
        mainPanel.setStyleName("Main", true);
        mainPanel.setHeight("100%");
        FlowPanel headerPanel = new FlowPanel();
        headerPanel.setStyleName("Header", true);
        Label header = new Label(this.getApplicationTitle());
        header.setStyleName("HeaderLabel", true);
        headerPanel.add((Widget)header);
        mainPanel.addNorth((Widget)headerPanel, 56.0);
        DockLayoutPanel bodyPanel = new DockLayoutPanel(Style.Unit.PX);
        bodyPanel.setStyleName("Body", true);
        bodyPanel.setHeight("100%");
        mainPanel.add((Widget)bodyPanel);
        FlowPanel toolBar = new FlowPanel();
        toolBar.setStyleName("ToolBar", true);
        SplitLayoutPanel contentPanel = new SplitLayoutPanel();
        contentPanel.setStyleName("Content", true);
        DockLayoutPanel propertiesPanel = new DockLayoutPanel(Style.Unit.PX);
        propertiesPanel.setStyleName("Properties", true);
        propertiesPanel.setHeight("100%");
        FlowPanel propertiesTitlePanel = new FlowPanel();
        propertiesTitlePanel.setStyleName("PropertiesTitle", true);
        Label title = new Label("Properties");
        title.setStyleName("PropertiesTitleLabel", true);
        propertiesTitlePanel.add((Widget)title);
        propertiesPanel.addNorth((Widget)propertiesTitlePanel, 28.0);
        final Grid properties = new Grid();
        properties.setWidth("100%");
        ScrollPanel propertiesScrollPanel = new ScrollPanel();
        propertiesScrollPanel.add((Widget)properties);
        propertiesPanel.add((Widget)propertiesScrollPanel);
        final Button createButton = new Button();
        createButton.setText("Create...");
        createButton.setStyleName("ToolBarButtonLeftMargin");
        toolBar.add((Widget)createButton);
        Button deleteButton = new Button();
        deleteButton.setText("Delete");
        final CommandHandler deleteCommandHandler = new CommandHandler((EditingDomain)editingDomain, deleteButton){

            public Command createCommand(Object value) {
                if (value instanceof Resource) {
                    Resource resource = (Resource)value;
                    final Command deleteContentsCommand = DeleteCommand.create((EditingDomain)this.editingDomain, (Collection)resource.getContents());
                    final RemoveCommand removeResourceCommand = new RemoveCommand(this.editingDomain, resourceSet.getResources(), (Object)resource);
                    return new CompoundCommand(){

                        protected boolean prepare() {
                            return true;
                        }

                        public void execute() {
                            this.appendAndExecute(deleteContentsCommand);
                            this.appendAndExecute((Command)removeResourceCommand);
                        }
                    };
                }
                return DeleteCommand.create((EditingDomain)this.editingDomain, (Object)value);
            }
        };
        deleteButton.setStyleName("ToolBarButton");
        toolBar.add((Widget)deleteButton);
        Button validateButton = new Button();
        validateButton.setText("Validate");
        validateButton.setStyleName("ToolBarButtonLeftMargin");
        toolBar.add((Widget)validateButton);
        final Button saveButton = new Button();
        saveButton.setText("Save");
        saveButton.setStyleName("ToolBarButton");
        toolBar.add((Widget)saveButton);
        final Button undoButton = new Button();
        undoButton.setText("Undo");
        undoButton.setStyleName("ToolBarButtonLeftMargin");
        toolBar.add((Widget)undoButton);
        final Button redoButton = new Button();
        redoButton.setText("Redo");
        redoButton.setStyleName("ToolBarButton");
        toolBar.add((Widget)redoButton);
        Button cutButton = new Button();
        cutButton.setText("Cut");
        final CommandHandler cutCommandHandler = new CommandHandler((EditingDomain)editingDomain, cutButton){

            public Command createCommand(Object value) {
                return CutToClipboardCommand.create((EditingDomain)this.editingDomain, (Object)value);
            }
        };
        cutButton.setStyleName("ToolBarButtonLeftMargin");
        toolBar.add((Widget)cutButton);
        Button copyButton = new Button();
        copyButton.setText("Copy");
        final CommandHandler copyCommandHandler = new CommandHandler((EditingDomain)editingDomain, copyButton){

            public Command createCommand(Object value) {
                return value instanceof EObject ? CopyToClipboardCommand.create((EditingDomain)this.editingDomain, (Object)value) : UnexecutableCommand.INSTANCE;
            }
        };
        copyButton.setStyleName("ToolBarButton");
        toolBar.add((Widget)copyButton);
        Button pasteButton = new Button();
        pasteButton.setText("Paste");
        final CommandHandler pasteCommandHandler = new CommandHandler((EditingDomain)editingDomain, pasteButton){

            public Command createCommand(Object value) {
                return PasteFromClipboardCommand.create((EditingDomain)this.editingDomain, (Object)value, null);
            }
        };
        pasteButton.setStyleName("ToolBarButton");
        toolBar.add((Widget)pasteButton);
        Button upButton = new Button();
        upButton.setText("Up ^");
        final CommandHandler upCommandHandler = new CommandHandler((EditingDomain)editingDomain, upButton){

            public Command createCommand(Object value) {
                ArrayList children;
                int index;
                Object owner = this.editingDomain.getParent(value);
                if (owner != null && (index = (children = new ArrayList(this.editingDomain.getChildren(owner))).indexOf(value)) != -1) {
                    return MoveCommand.create((EditingDomain)this.editingDomain, (Object)owner, null, (Object)value, (int)(index - 1));
                }
                return UnexecutableCommand.INSTANCE;
            }
        };
        upButton.setStyleName("ToolBarButtonLeftMargin");
        toolBar.add((Widget)upButton);
        Button downButton = new Button();
        downButton.setText("Down v");
        final CommandHandler downCommandHandler = new CommandHandler((EditingDomain)editingDomain, downButton){

            public Command createCommand(Object value) {
                ArrayList children;
                int index;
                Object owner = this.editingDomain.getParent(value);
                if (owner != null && (index = (children = new ArrayList(this.editingDomain.getChildren(owner))).indexOf(value)) != -1) {
                    return MoveCommand.create((EditingDomain)this.editingDomain, (Object)owner, null, (Object)value, (int)(index + 1));
                }
                return UnexecutableCommand.INSTANCE;
            }
        };
        downButton.setStyleName("ToolBarButton");
        toolBar.add((Widget)downButton);
        Button navigateButton = new Button();
        navigateButton.setText("Navigate");
        navigateButton.setEnabled(false);
        navigateButton.setStyleName("ToolBarButtonLeftMargin");
        toolBar.add((Widget)navigateButton);
        final SingleSelectionModel treeSelection = new SingleSelectionModel();
        final HashSet propertyUpdater = new HashSet();
        TreeViewModel treeViewModel = new TreeViewModel(){

            public <T> TreeViewModel.NodeInfo<?> getNodeInfo(final T value) {
                ListDataProvider<Object> abstractListViewAdapter = new ListDataProvider<Object>(propertyUpdater){
                    int size;
                    protected NodeAdapter nodeAdapter;
                    {
                        this.nodeAdapter = new NodeAdapter(collection, object);
                    }

                    protected void onRangeChanged(HasData<Object> display) {
                        Resource resource;
                        if (value instanceof Resource && !(resource = (Resource)value).isLoaded()) {
                            try {
                                resource.load(resourceSet.getLoadOptions());
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        this.update();
                    }

                    protected void update() {
                        Collection children = itemDelegator.getChildren(value);
                        ArrayList<Object> childrenList = new ArrayList<Object>(children);
                        this.nodeAdapter.listenTo(childrenList);
                        int size = children.size();
                        if (this.size < size) {
                            this.updateRowCount(size, true);
                            this.size = size;
                        } else {
                            int i = size;
                            while (i < this.size) {
                                childrenList.add(new Object());
                                ++i;
                            }
                        }
                        this.updateRowData(0, childrenList);
                        if (this.size > size) {
                            this.updateRowCount(size, true);
                            this.size = size;
                        }
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    class NodeAdapter
                    extends AdapterImpl
                    implements INotifyChangedListener {
                        Set<Object> children = new HashSet<Object>();
                        private final /* synthetic */ Collection val$propertyUpdater;
                        private final /* synthetic */ Object val$value;

                        NodeAdapter(Collection collection, Object object) {
                            this.val$propertyUpdater = collection;
                            this.val$value = object;
                        }

                        public void notifyChanged(Notification msg) {
                            if (msg.getEventType() != 8) {
                                this.update();
                                if (!(msg.getNotifier() instanceof EObject)) {
                                    for (Runnable runnable : this.val$propertyUpdater) {
                                        runnable.run();
                                    }
                                }
                            }
                        }

                        public void listenTo(Object target) {
                            if (target instanceof Notifier) {
                                ((Notifier)target).eAdapters().add((Object)this);
                            } else if (target instanceof IChangeNotifier) {
                                ((IChangeNotifier)target).addListener((INotifyChangedListener)this);
                            }
                        }

                        public void stopListeningTo(Object target) {
                            if (target instanceof Notifier) {
                                ((Notifier)target).eAdapters().remove((Object)this);
                            } else if (target instanceof IChangeNotifier) {
                                ((IChangeNotifier)target).removeListener((INotifyChangedListener)this);
                            }
                        }

                        public void listenTo(List<Object> children) {
                            boolean isListeningToValue = !this.children.isEmpty();
                            HashSet<Object> oldChildren = new HashSet<Object>(this.children);
                            for (Object child : children) {
                                if (this.children.contains(child)) {
                                    oldChildren.remove(child);
                                    continue;
                                }
                                this.children.add(child);
                                this.listenTo(child);
                            }
                            for (Object child : oldChildren) {
                                this.stopListeningTo(child);
                                this.children.remove(child);
                            }
                            if (isListeningToValue) {
                                if (children.isEmpty()) {
                                    this.stopListeningTo(this.val$value);
                                }
                            } else if (!children.isEmpty()) {
                                this.listenTo(this.val$value);
                            }
                        }
                    }
                };
                AbstractCell<Object> cell = new AbstractCell<Object>(new String[0]){

                    public void render(Cell.Context context, Object value, SafeHtmlBuilder safeHtmlBuilder) {
                        StringBuilder sb = new StringBuilder();
                        Object image = itemDelegator.getImage(value);
                        if (image instanceof ImageResource) {
                            ImageResource imageResource = (ImageResource)image;
                            sb.append("<div style='position:relative;padding-left:");
                            sb.append(imageResource.getWidth() + 6);
                            sb.append("px;'>");
                            sb.append("<div style=\"position:absolute;left:0px;top:0px;height:100%;");
                            sb.append("width:").append(imageResource.getWidth()).append("px;");
                            sb.append("background:url('").append(imageResource.getSafeUri()).append("') ");
                            sb.append("no-repeat scroll center center transparent;");
                            sb.append("\"></div>");
                            sb.append(itemDelegator.getText(value));
                            sb.append("</div>");
                        } else if (image instanceof ComposedImage) {
                            ComposedImage composedImage = (ComposedImage)image;
                            ArrayList<ComposedImage.Size> sizes = new ArrayList<ComposedImage.Size>();
                            ArrayList images = new ArrayList(composedImage.getImages());
                            ArrayList<ImageData> nestedImagesData = new ArrayList<ImageData>();
                            for (Object nestedImage : images) {
                                ImageData nestedImageData = EditorEntryPoint.this.getImageData(nestedImage);
                                ComposedImage.Size size = new ComposedImage.Size();
                                size.height = nestedImageData.height;
                                size.width = nestedImageData.width;
                                sizes.add(size);
                                nestedImagesData.add(nestedImageData);
                            }
                            ComposedImage.Size size = composedImage.getSize(sizes);
                            sb.append("<div style='position:relative;padding-left:");
                            sb.append(size.width + 6);
                            sb.append("px;'>");
                            List drawPoints = composedImage.getDrawPoints(size);
                            int i = 0;
                            for (ComposedImage.Point drawPoint : drawPoints) {
                                ImageResource nestedImage = (ImageResource)images.get(i++);
                                sb.append("<div style=\"position:absolute;left:").append(drawPoint.x).append("px;top:").append(drawPoint.y).append("px;height:100%;");
                                sb.append("width:").append(nestedImage.getWidth()).append("px;");
                                sb.append("background:url('").append(nestedImage.getSafeUri()).append("') ");
                                sb.append("no-repeat scroll center center transparent;");
                                sb.append("\"></div>");
                            }
                            sb.append(itemDelegator.getText(value));
                            sb.append("</div>");
                        } else {
                            sb.append(itemDelegator.getText(value));
                        }
                        safeHtmlBuilder.appendHtmlConstant(sb.toString());
                    }
                };
                return new TreeViewModel.DefaultNodeInfo((AbstractDataProvider)abstractListViewAdapter, (Cell)cell, (SelectionModel)treeSelection, null);
            }

            public boolean isLeaf(Object value) {
                return !itemDelegator.hasChildren(value);
            }
        };
        treeSelection.setSelected((Object)resourceSet, true);
        final MyCellTree cellTree = new MyCellTree(treeViewModel, new ItemProvider(Collections.singleton(resourceSet)));
        ScrollPanel treeScrollPanel = new ScrollPanel();
        treeScrollPanel.add((Widget)cellTree);
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class NavigationListener {
            Object selection;
            private final /* synthetic */ Button val$navigateButton;

            NavigationListener(Button button, final SingleSelectionModel singleSelectionModel, final MyCellTree myCellTree, final AdapterFactoryEditingDomain adapterFactoryEditingDomain) {
                this.val$navigateButton = button;
                button.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        final Object oldSelection = singleSelectionModel.getSelectedObject();
                        Object newSelection = selection;
                        myCellTree.expand(adapterFactoryEditingDomain.getTreePath(adapterFactoryEditingDomain.getParent(newSelection)));
                        singleSelectionModel.setSelected(newSelection, true);
                        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                            public void execute() {
                                this.setSelection(oldSelection);
                            }
                        });
                    }
                });
            }

            public void listenTo(final ListBox listBox, final List<?> values) {
                listBox.addFocusHandler(new FocusHandler(){
                    protected HandlerRegistration changeHandlerRegistration;
                    {
                        listBox2.addBlurHandler(new BlurHandler(){

                            public void onBlur(BlurEvent event) {
                                if (changeHandlerRegistration != null) {
                                    changeHandlerRegistration.removeHandler();
                                    changeHandlerRegistration = null;
                                }
                            }
                        });
                    }

                    public void onFocus(FocusEvent event) {
                        this.updateSelection();
                        this.changeHandlerRegistration = listBox.addChangeHandler(new ChangeHandler(){

                            public void onChange(ChangeEvent event) {
                                this.updateSelection();
                            }
                        });
                    }

                    void updateSelection() {
                        int selectedIndex = listBox.getSelectedIndex();
                        this.setSelection(selectedIndex == -1 || selectedIndex >= values.size() ? null : values.get(selectedIndex));
                    }
                });
            }

            protected void setSelection(Object object) {
                if (object != this.selection) {
                    this.selection = object;
                    this.val$navigateButton.setEnabled(this.selection != null);
                }
            }
        }
        final NavigationListener navigationListener = new NavigationListener(navigateButton, treeSelection, cellTree, editingDomain);
        treeSelection.addSelectionChangeHandler(new SelectionChangeEvent.Handler(){
            protected Object oldSelection;
            {
            }

            public void onSelectionChange(SelectionChangeEvent event) {
                block24: {
                    Object object;
                    block23: {
                        object = treeSelection.getSelectedObject();
                        deleteCommandHandler.setSelection(object);
                        cutCommandHandler.setSelection(object);
                        pasteCommandHandler.setSelection(object);
                        copyCommandHandler.setSelection(object);
                        upCommandHandler.setSelection(object);
                        downCommandHandler.setSelection(object);
                        createButton.setEnabled(object instanceof Resource || object instanceof ResourceSet || !editingDomain.getNewChildDescriptors(object, null).isEmpty());
                        if (this.oldSelection != object) break block23;
                        for (Runnable runnable : propertyUpdater) {
                            runnable.run();
                        }
                        break block24;
                    }
                    navigationListener.setSelection(null);
                    this.oldSelection = object;
                    List propertyDescriptors = itemDelegator.getPropertyDescriptors(object);
                    if (propertyDescriptors == null) break block24;
                    properties.clear();
                    propertyUpdater.clear();
                    int size = propertyDescriptors.size();
                    properties.resize(size, 2);
                    properties.getColumnFormatter().setWidth(0, "10%");
                    properties.getColumnFormatter().setWidth(1, "90%");
                    int i = 0;
                    while (i < size) {
                        final IItemPropertyDescriptor propertyDescriptor = (IItemPropertyDescriptor)propertyDescriptors.get(i);
                        properties.setText(i, 0, propertyDescriptor.getDisplayName(object));
                        Object widget = null;
                        final IItemLabelProvider itemLabelProvider = propertyDescriptor.getLabelProvider(object);
                        Object feature = propertyDescriptor.getFeature(object);
                        if (feature instanceof EReference[]) {
                            final ItemPropertyDescriptorFeatureEditor dialog = new ItemPropertyDescriptorFeatureEditor(object, true, propertyDescriptor){
                                {
                                    super($anonymous0, $anonymous1, $anonymous2);
                                }

                                @Override
                                protected void hook(ListBox listBox, List<?> values) {
                                    navigationListener.listenTo(listBox, values);
                                }
                            };
                            dialog.update();
                            widget = dialog;
                            propertyUpdater.add(new Runnable(){

                                public void run() {
                                    dialog.update();
                                }
                            });
                        } else if (feature instanceof EStructuralFeature) {
                            EDataType eDataType;
                            Runnable runnable;
                            EStructuralFeature eStructureFeature = (EStructuralFeature)feature;
                            EClassifier eType = eStructureFeature.getEType();
                            final Collection choiceOfValues = propertyDescriptor.getChoiceOfValues(object);
                            if (choiceOfValues != null) {
                                final ArrayList listOfValues = new ArrayList(propertyDescriptor.getChoiceOfValues(object));
                                if (propertyDescriptor.isMany(object)) {
                                    boolean valid = true;
                                    for (Object choice : choiceOfValues) {
                                        if (eType.isInstance(choice)) continue;
                                        valid = false;
                                        break;
                                    }
                                    if (valid) {
                                        final ItemPropertyDescriptorFeatureEditor dialog = new ItemPropertyDescriptorFeatureEditor(object, true, propertyDescriptor){
                                            {
                                                super($anonymous0, $anonymous1, $anonymous2);
                                            }

                                            @Override
                                            protected void hook(ListBox listBox, List<?> values) {
                                                navigationListener.listenTo(listBox, values);
                                            }
                                        };
                                        dialog.update();
                                        widget = dialog;
                                        propertyUpdater.add(new Runnable(){

                                            public void run() {
                                                dialog.update();
                                            }
                                        });
                                    }
                                }
                                if (widget == null) {
                                    final ListBox listBox = new ListBox();
                                    widget = listBox;
                                    listBox.setVisibleItemCount(1);
                                    runnable = new Runnable(){
                                        {
                                        }

                                        public void run() {
                                            listBox.clear();
                                            navigationListener.listenTo(listBox, listOfValues);
                                            Object propertyValue = itemDelegator.getEditableValue(propertyDescriptor.getPropertyValue(object));
                                            for (Object value : choiceOfValues) {
                                                listBox.addItem(itemLabelProvider.getText(value));
                                                if (!(value == null ? propertyValue == null : value.equals(propertyValue))) continue;
                                                listBox.setSelectedIndex(listBox.getItemCount() - 1);
                                            }
                                        }
                                    };
                                    listBox.addChangeHandler(new ChangeHandler(){

                                        public void onChange(ChangeEvent event) {
                                            Object value = listOfValues.get(listBox.getSelectedIndex());
                                            propertyDescriptor.setPropertyValue(object, value);
                                        }
                                    });
                                    runnable.run();
                                    propertyUpdater.add(runnable);
                                }
                            } else if (eType instanceof EDataType && (eDataType = (EDataType)eType).isSerializable()) {
                                if (propertyDescriptor.isMany(object)) {
                                    final ItemPropertyDescriptorFeatureEditor dialog = new ItemPropertyDescriptorFeatureEditor(object, propertyDescriptor){
                                        {
                                            super($anonymous0, $anonymous1);
                                        }

                                        @Override
                                        protected void hook(ListBox listBox, List<?> values) {
                                            navigationListener.listenTo(listBox, values);
                                        }
                                    };
                                    dialog.update();
                                    widget = dialog;
                                    propertyUpdater.add(new Runnable(){

                                        public void run() {
                                            dialog.update();
                                        }
                                    });
                                } else if (eDataType.getInstanceClass() == Date.class) {
                                    final DateBox dateBox = new DateBox();
                                    widget = dateBox;
                                    runnable = new Runnable(){

                                        public void run() {
                                            Object propertyValue = itemDelegator.getEditableValue(propertyDescriptor.getPropertyValue(object));
                                            dateBox.setValue((Date)propertyValue);
                                        }
                                    };
                                    dateBox.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Date>(){

                                        public void onValueChange(ValueChangeEvent<Date> event) {
                                            propertyDescriptor.setPropertyValue(object, event.getValue());
                                        }
                                    });
                                    runnable.run();
                                    propertyUpdater.add(runnable);
                                } else if (eDataType.getInstanceClass() == Boolean.class || eDataType.getInstanceClass() == Boolean.TYPE) {
                                    final CheckBox checkBox = new CheckBox();
                                    widget = checkBox;
                                    runnable = new Runnable(){

                                        public void run() {
                                            Object propertyValue = itemDelegator.getEditableValue(propertyDescriptor.getPropertyValue(object));
                                            checkBox.setValue(Boolean.valueOf(Boolean.TRUE.equals(propertyValue)));
                                        }
                                    };
                                    checkBox.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                                        public void onValueChange(ValueChangeEvent<Boolean> event) {
                                            propertyDescriptor.setPropertyValue(object, event.getValue());
                                        }
                                    });
                                    runnable.run();
                                    propertyUpdater.add(runnable);
                                } else if (propertyDescriptor.isMultiLine(object)) {
                                    final TextArea textArea = new TextArea();
                                    widget = textArea;
                                    runnable = new Runnable(){

                                        public void run() {
                                            Object propertyValue = itemDelegator.getEditableValue(propertyDescriptor.getPropertyValue(object));
                                            textArea.setText(EcoreUtil.convertToString((EDataType)eDataType, (Object)propertyValue));
                                        }
                                    };
                                    textArea.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

                                        public void onValueChange(ValueChangeEvent<String> event) {
                                            propertyDescriptor.setPropertyValue(object, EcoreUtil.createFromString((EDataType)eDataType, (String)((String)event.getValue())));
                                        }
                                    });
                                    runnable.run();
                                    propertyUpdater.add(runnable);
                                } else {
                                    TextBox textBox;
                                    widget = textBox = new TextBox();
                                    textBox.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

                                        public void onValueChange(ValueChangeEvent<String> event) {
                                            String value = (String)event.getValue();
                                            propertyDescriptor.setPropertyValue(object, EcoreUtil.createFromString((EDataType)eDataType, (String)value));
                                        }
                                    });
                                    runnable = new Runnable(){

                                        public void run() {
                                            Object propertyValue = itemDelegator.getEditableValue(propertyDescriptor.getPropertyValue(object));
                                            String stringValue = EcoreUtil.convertToString((EDataType)eDataType, (Object)propertyValue);
                                            if (!textBox.getText().equals(stringValue)) {
                                                textBox.setText(stringValue);
                                            }
                                        }
                                    };
                                    runnable.run();
                                    propertyUpdater.add(runnable);
                                }
                            }
                        } else {
                            TextBox textBox;
                            widget = textBox = new TextBox();
                            textBox.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

                                public void onValueChange(ValueChangeEvent<String> event) {
                                    String value = (String)event.getValue();
                                    propertyDescriptor.setPropertyValue(object, (Object)value);
                                }
                            });
                            Runnable runnable = new Runnable(){

                                public void run() {
                                    String stringValue;
                                    Object propertyValue = itemDelegator.getEditableValue(propertyDescriptor.getPropertyValue(object));
                                    String string = stringValue = propertyValue == null ? null : propertyDescriptor.getLabelProvider(object).getText(propertyValue);
                                    if (!textBox.getText().equals(stringValue)) {
                                        textBox.setText(stringValue);
                                    }
                                }
                            };
                            runnable.run();
                            propertyUpdater.add(runnable);
                        }
                        if (widget != null) {
                            widget.setWidth("95%");
                            properties.setWidget(i, 1, (Widget)widget);
                            if (!propertyDescriptor.canSetProperty(object) && widget instanceof FocusWidget) {
                                ((FocusWidget)widget).setEnabled(false);
                            }
                        }
                        ++i;
                    }
                }
            }
        });
        contentPanel.addWest((Widget)treeScrollPanel, 400.0);
        contentPanel.add((Widget)propertiesPanel);
        bodyPanel.addNorth((Widget)toolBar, 28.0);
        bodyPanel.add((Widget)contentPanel);
        RootPanel.get((String)"main").add((Widget)mainPanel);
        createButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                Object selection = treeSelection.getSelectedObject();
                if (selection instanceof ResourceSet) {
                    final DialogBox dialogBox = new DialogBox();
                    dialogBox.setText("Create Resource");
                    final Button okButton = new Button("OK");
                    Button cancelButton = new Button("Cancel");
                    VerticalPanel verticalPanel = new VerticalPanel();
                    Grid grid = new Grid();
                    grid.setWidth("50em");
                    grid.resize(3, 2);
                    grid.getColumnFormatter().setWidth(0, "15%");
                    grid.getColumnFormatter().setWidth(1, "85%");
                    Label uriLabel = new Label();
                    uriLabel.setText("URI");
                    final TextBox uriText = new TextBox();
                    uriText.setWidth("90%");
                    int count = 1;
                    while (resourceSet.getResource(URI.createURI((String)("datastore:/resource" + count)), false) != null) {
                        ++count;
                    }
                    uriText.setValue((Object)("datastore:/resource" + count));
                    uriText.selectAll();
                    final Label message = new Label();
                    uriText.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

                        public void onValueChange(ValueChangeEvent<String> event) {
                            String value = (String)event.getValue();
                            try {
                                if (resourceSet.getResource(URI.createURI((String)value), false) != null) {
                                    message.setText("This URI a duplicate");
                                    okButton.setEnabled(false);
                                } else {
                                    message.setText("");
                                    okButton.setEnabled(true);
                                }
                            }
                            catch (RuntimeException exception) {
                                message.setText("This URI is not a well formed");
                                okButton.setEnabled(false);
                            }
                        }
                    });
                    grid.setWidget(0, 0, (Widget)uriLabel);
                    grid.setWidget(0, 1, (Widget)uriText);
                    verticalPanel.add((Widget)grid);
                    grid.setWidget(1, 1, (Widget)message);
                    grid.setWidget(2, 0, (Widget)okButton);
                    grid.setWidget(2, 1, (Widget)cancelButton);
                    dialogBox.setWidget((Widget)verticalPanel);
                    dialogBox.show();
                    uriText.setFocus(true);
                    okButton.addClickHandler(new ClickHandler(){

                        public void onClick(ClickEvent event) {
                            dialogBox.hide();
                            commandStack.execute((Command)new AbstractCommand(){
                                Collection<?> affectedObjects;
                                Resource resource;

                                protected boolean prepare() {
                                    return true;
                                }

                                public void redo() {
                                    resourceSet.getResources().add((Object)this.resource);
                                    this.affectedObjects = Collections.singleton(this.resource);
                                }

                                public void undo() {
                                    resourceSet.getResources().remove((Object)this.resource);
                                    this.affectedObjects = Collections.singleton(resourceSet);
                                }

                                public void execute() {
                                    this.resource = resourceSet.createResource(URI.createURI((String)uriText.getValue()));
                                    this.resource.getContents().clear();
                                    this.affectedObjects = Collections.singleton(this.resource);
                                }

                                public Collection<?> getAffectedObjects() {
                                    return this.affectedObjects;
                                }
                            });
                        }
                    });
                    cancelButton.addClickHandler(new ClickHandler(){

                        public void onClick(ClickEvent event) {
                            dialogBox.hide();
                        }
                    });
                } else if (selection instanceof Resource) {
                    final Resource resource = (Resource)selection;
                    final DialogBox dialogBox = new DialogBox();
                    dialogBox.setText("Create Object");
                    final ListBox listBox = new ListBox();
                    listBox.setVisibleItemCount(1);
                    EPackage.Registry packageRegistry = resourceSet.getPackageRegistry();
                    for (String nsURI : packageRegistry.keySet()) {
                        EPackage ePackage = packageRegistry.getEPackage(nsURI);
                        for (EClassifier eClassifier : ePackage.getEClassifiers()) {
                            EClass eClass;
                            if (!(eClassifier instanceof EClass) || (eClass = (EClass)eClassifier).isAbstract()) continue;
                            EObject eObject = EcoreUtil.create((EClass)eClass);
                            listBox.addItem("New " + itemDelegator.getText((Object)eObject), EcoreUtil.getURI((EObject)eClass).toString());
                        }
                    }
                    Button okButton = new Button("OK");
                    Button cancelButton = new Button("Cancel");
                    VerticalPanel verticalPanel = new VerticalPanel();
                    Grid grid = new Grid();
                    grid.setWidth("50em");
                    grid.resize(2, 2);
                    grid.getColumnFormatter().setWidth(0, "15%");
                    grid.getColumnFormatter().setWidth(1, "85%");
                    Label classLabel = new Label();
                    classLabel.setText("Class");
                    grid.setWidget(0, 0, (Widget)classLabel);
                    grid.setWidget(0, 1, (Widget)listBox);
                    verticalPanel.add((Widget)grid);
                    grid.setWidget(1, 0, (Widget)okButton);
                    grid.setWidget(1, 1, (Widget)cancelButton);
                    dialogBox.setWidget((Widget)verticalPanel);
                    dialogBox.show();
                    listBox.setFocus(true);
                    okButton.addClickHandler(new ClickHandler(){

                        public void onClick(ClickEvent event) {
                            dialogBox.hide();
                            commandStack.execute((Command)new AbstractCommand(){
                                EObject eObject;
                                Collection<?> affectedObjects;

                                protected boolean prepare() {
                                    return true;
                                }

                                public void redo() {
                                    resource.getContents().add((Object)this.eObject);
                                    this.affectedObjects = Collections.singleton(this.eObject);
                                }

                                public void undo() {
                                    resource.getContents().remove((Object)this.eObject);
                                    this.affectedObjects = Collections.singleton(resource);
                                }

                                public void execute() {
                                    this.eObject = EcoreUtil.create((EClass)((EClass)resourceSet.getEObject(URI.createURI((String)listBox.getValue(listBox.getSelectedIndex())), false)));
                                    resource.getContents().add((Object)this.eObject);
                                    this.affectedObjects = Collections.singleton(this.eObject);
                                }

                                public Collection<?> getAffectedObjects() {
                                    return this.affectedObjects;
                                }
                            });
                        }
                    });
                    cancelButton.addClickHandler(new ClickHandler(){

                        public void onClick(ClickEvent event) {
                            dialogBox.hide();
                        }
                    });
                } else {
                    Collection newChildDescriptors = editingDomain.getNewChildDescriptors(selection, null);
                    final DialogBox dialogBox = new DialogBox();
                    dialogBox.setText("Create Object");
                    final ListBox listBox = new ListBox();
                    final ArrayList<Command> commands = new ArrayList<Command>();
                    listBox.setVisibleItemCount(1);
                    for (Object descriptor : newChildDescriptors) {
                        Command command = CreateChildCommand.create((EditingDomain)editingDomain, (Object)selection, descriptor, Collections.singleton(selection));
                        commands.add(command);
                        listBox.addItem(command.getLabel());
                    }
                    Button okButton = new Button("OK");
                    Button cancelButton = new Button("Cancel");
                    VerticalPanel verticalPanel = new VerticalPanel();
                    Grid grid = new Grid();
                    grid.setWidth("50em");
                    grid.resize(2, 2);
                    grid.getColumnFormatter().setWidth(0, "15%");
                    grid.getColumnFormatter().setWidth(1, "85%");
                    Label classLabel = new Label();
                    classLabel.setText("Class");
                    grid.setWidget(0, 0, (Widget)classLabel);
                    grid.setWidget(0, 1, (Widget)listBox);
                    verticalPanel.add((Widget)grid);
                    grid.setWidget(1, 0, (Widget)okButton);
                    grid.setWidget(1, 1, (Widget)cancelButton);
                    dialogBox.setWidget((Widget)verticalPanel);
                    dialogBox.show();
                    listBox.setFocus(true);
                    okButton.addClickHandler(new ClickHandler(){

                        public void onClick(ClickEvent event) {
                            dialogBox.hide();
                            commandStack.execute((Command)commands.get(listBox.getSelectedIndex()));
                        }
                    });
                    cancelButton.addClickHandler(new ClickHandler(){

                        public void onClick(ClickEvent event) {
                            dialogBox.hide();
                        }
                    });
                }
            }
        });
        saveButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                HashMap<String, Long> options;
                EList resources = resourceSet.getResources();
                for (Resource resource : resources) {
                    try {
                        if (!resource.isLoaded()) continue;
                        options = null;
                        if (originalResources.contains(resource)) {
                            options = new HashMap<String, Long>();
                            options.put("UPDATE_ONLY_IF_TIME_STAMP_MATCHES", resource.getTimeStamp());
                        }
                        resource.save(options, (Callback)new Callback<Resource>(){

                            public void onFailure(Throwable caught) {
                                final DialogBox dialogBox = new DialogBox();
                                dialogBox.setText("Save conflict");
                                Button okButton = new Button("OK");
                                Tree tree = new Tree();
                                tree.addItem(SafeHtmlUtils.fromString((String)caught.getLocalizedMessage()));
                                Grid grid = new Grid();
                                grid.setWidth("150em");
                                grid.resize(2, 1);
                                grid.setWidget(0, 0, (Widget)tree);
                                grid.setWidget(1, 0, (Widget)okButton);
                                dialogBox.setWidget((Widget)grid);
                                dialogBox.show();
                                okButton.addClickHandler(new ClickHandler(){

                                    public void onClick(ClickEvent event) {
                                        dialogBox.hide();
                                    }
                                });
                            }

                            public void onSuccess(Resource result) {
                            }
                        });
                    }
                    catch (IOException exception) {
                        EMFEditUIPlugin.INSTANCE.log(exception);
                    }
                }
                for (Resource resource : originalResources) {
                    if (resources.contains((Object)resource)) continue;
                    options = null;
                    if (resource.isLoaded()) {
                        options = new HashMap();
                        options.put("UPDATE_ONLY_IF_TIME_STAMP_MATCHES", resource.getTimeStamp());
                    }
                    resourceSet.getURIConverter().delete(resource.getURI(), options, new Callback<Map<?, ?>>(){

                        public void onFailure(Throwable caught) {
                            final DialogBox dialogBox = new DialogBox();
                            dialogBox.setText("Delete conflict");
                            Button okButton = new Button("OK");
                            Tree tree = new Tree();
                            tree.addItem(SafeHtmlUtils.fromString((String)caught.getLocalizedMessage()));
                            Grid grid = new Grid();
                            grid.setWidth("150em");
                            grid.resize(2, 1);
                            grid.setWidget(0, 0, (Widget)tree);
                            grid.setWidget(1, 0, (Widget)okButton);
                            dialogBox.setWidget((Widget)grid);
                            dialogBox.show();
                            okButton.addClickHandler(new ClickHandler(){

                                public void onClick(ClickEvent event) {
                                    dialogBox.hide();
                                }
                            });
                        }

                        public void onSuccess(Map<?, ?> result) {
                        }
                    });
                }
                originalResources.clear();
                originalResources.addAll(resources);
                commandStack.saveIsDone();
                saveButton.setEnabled(false);
            }
        });
        validateButton.addClickHandler(new ClickHandler(){

            protected TreeItem createTreeItems(Diagnostic diagnostic) {
                TreeItem treeItem = new TreeItem(SafeHtmlUtils.fromString((String)diagnostic.getMessage()));
                List data = diagnostic.getData();
                if (!data.isEmpty()) {
                    treeItem.setUserObject(data.get(0));
                }
                for (Diagnostic child : diagnostic.getChildren()) {
                    treeItem.addItem(this.createTreeItems(child));
                }
                return treeItem;
            }

            public void onClick(ClickEvent event) {
                Diagnostician diagnostician = new Diagnostician(){

                    public String getObjectLabel(EObject eObject) {
                        return !eObject.eIsProxy() ? itemDelegator.getText((Object)eObject) : super.getObjectLabel(eObject);
                    }
                };
                Map context = diagnostician.createDefaultContext();
                EList resources = resourceSet.getResources();
                BasicDiagnostic diagnostics = new BasicDiagnostic();
                for (Resource resource : resources) {
                    if (!resource.isLoaded()) continue;
                    for (EObject eObject : resource.getContents()) {
                        diagnostician.validate(eObject, (DiagnosticChain)diagnostics, context);
                    }
                }
                final DialogBox dialogBox = new DialogBox();
                dialogBox.setText("Problems");
                Button okButton = new Button("OK");
                final Tree tree = new Tree();
                if (diagnostics.getSeverity() == 0) {
                    tree.addItem(SafeHtmlUtils.fromString((String)"No problems detected"));
                } else {
                    for (Diagnostic child : diagnostics.getChildren()) {
                        tree.addItem(this.createTreeItems(child));
                    }
                }
                Grid grid = new Grid();
                grid.setWidth("150em");
                grid.resize(2, 1);
                grid.setWidget(0, 0, (Widget)tree);
                grid.setWidget(1, 0, (Widget)okButton);
                dialogBox.setWidget((Widget)grid);
                dialogBox.show();
                okButton.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        Object newSelection;
                        TreeItem treeItem = tree.getSelectedItem();
                        if (treeItem != null && (newSelection = treeItem.getUserObject()) != null) {
                            cellTree.expand(editingDomain.getTreePath(editingDomain.getParent(newSelection)));
                            treeSelection.setSelected(newSelection, true);
                        }
                        dialogBox.hide();
                    }
                });
            }
        });
        saveButton.setEnabled(false);
        undoButton.setEnabled(false);
        redoButton.setEnabled(false);
        commandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(EventObject event) {
                Collection affectedObjects;
                saveButton.setEnabled(commandStack.isSaveNeeded());
                undoButton.setEnabled(commandStack.canUndo());
                redoButton.setEnabled(commandStack.canRedo());
                Command mostRecentCommand = ((CommandStack)event.getSource()).getMostRecentCommand();
                if (mostRecentCommand != null && !(affectedObjects = mostRecentCommand.getAffectedObjects()).isEmpty()) {
                    Object newSelection = affectedObjects.iterator().next();
                    cellTree.expand(editingDomain.getTreePath(editingDomain.getParent(newSelection)));
                    if (treeSelection.getSelectedObject() == newSelection) {
                        for (Runnable runnable : propertyUpdater) {
                            runnable.run();
                        }
                    } else {
                        treeSelection.setSelected(newSelection, true);
                    }
                }
            }
        });
        undoButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                commandStack.undo();
            }
        });
        redoButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                commandStack.redo();
            }
        });
    }

    protected abstract void registerPackages(EPackage.Registry var1);

    protected void configureItemProviderAdapterFactories(ComposedAdapterFactory adapterFactory) {
    }

    protected abstract String getApplicationTitle();

    protected ImageData getImageData(Object image) {
        ImageData imageData = new ImageData();
        if (image instanceof ImageResource) {
            ImageResource imageResource = (ImageResource)image;
            imageData.height = imageResource.getHeight();
            imageData.width = imageResource.getWidth();
        } else if (image instanceof ComposedImage) {
            ComposedImage composedImage = (ComposedImage)image;
            ArrayList<ComposedImage.Size> sizes = new ArrayList<ComposedImage.Size>();
            ArrayList images = new ArrayList(composedImage.getImages());
            ArrayList<ImageData> nestedImagesData = new ArrayList<ImageData>();
            for (Object nestedImage : images) {
                ImageData nestedImageData = this.getImageData(nestedImage);
                ComposedImage.Size size = new ComposedImage.Size();
                size.height = nestedImageData.height;
                size.width = nestedImageData.width;
                sizes.add(size);
                nestedImagesData.add(nestedImageData);
            }
        }
        return imageData;
    }

    public static <T> String[] createItems(List<T> list, IItemLabelProvider labelProvider, String filter, boolean sorted) {
        String[] result;
        if (filter != null && filter.length() > 0) {
            sorted = true;
        }
        if (list != null && list.size() > 0) {
            if (sorted) {
                ArrayList<T> unsortedList = new ArrayList<T>(list.size());
                if (filter != null && filter.length() > 0) {
                    int i = 0;
                    while (i < list.size()) {
                        if (EditorEntryPoint.select(filter, labelProvider.getText(list.get(i)))) {
                            unsortedList.add(list.get(i));
                        }
                        ++i;
                    }
                } else {
                    unsortedList.addAll(list);
                }
                list.clear();
                Object[] pairs = new StringPositionPair[unsortedList.size()];
                int i = 0;
                int size = unsortedList.size();
                while (i < size) {
                    Object object = unsortedList.get(i);
                    pairs[i] = new StringPositionPair(labelProvider.getText(object), i);
                    ++i;
                }
                Arrays.sort(pairs);
                result = new String[unsortedList.size()];
                i = 0;
                size = unsortedList.size();
                while (i < size) {
                    result[i] = ((StringPositionPair)pairs[i]).key;
                    list.add(unsortedList.get(((StringPositionPair)pairs[i]).position));
                    ++i;
                }
            } else {
                result = new String[list.size()];
                int i = 0;
                int size = list.size();
                while (i < size) {
                    T object = list.get(i);
                    result[i] = labelProvider.getText(object);
                    ++i;
                }
            }
        } else {
            result = new String[]{""};
        }
        return result;
    }

    public static boolean select(String filter, String labelValue) {
        if (filter != null && filter.length() > 0) {
            if (filter.length() > labelValue.length()) {
                return false;
            }
            int i = 0;
            while (i < filter.length()) {
                if (Character.toLowerCase(filter.charAt(i)) != Character.toLowerCase(labelValue.charAt(i))) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public static abstract class CommandHandler
    implements ClickHandler {
        protected Command command;
        protected EditingDomain editingDomain;
        protected Button button;

        public CommandHandler(EditingDomain editingDomain, Button button) {
            this.editingDomain = editingDomain;
            this.button = button;
            button.addClickHandler((ClickHandler)this);
            button.setEnabled(false);
        }

        public void setSelection(Object value) {
            this.command = this.createCommand(value);
            this.button.setEnabled(this.command.canExecute());
        }

        public abstract Command createCommand(Object var1);

        public void onClick(ClickEvent event) {
            this.editingDomain.getCommandStack().execute(this.command);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class FeatureEditor
    extends Composite {
        protected Object object;
        protected boolean isSortChoices;
        protected List<?> values;
        protected List<?> choiceOfValues;
        protected ListBox valueBox;
        protected ListBox choiceBox;
        protected EDataType eDataType;
        protected TextBox textBox;

        protected FeatureEditor(Object object, boolean isSortChoices, final EDataType eDataType) {
            this.object = object;
            this.isSortChoices = isSortChoices;
            this.eDataType = eDataType;
            Grid grid = new Grid();
            grid.resize(1, 3);
            grid.getColumnFormatter().setWidth(0, "40%");
            grid.getColumnFormatter().setWidth(1, "20%");
            grid.getColumnFormatter().setWidth(2, "40%");
            this.valueBox = new ListBox();
            this.valueBox.setMultipleSelect(true);
            this.valueBox.setVisibleItemCount(4);
            this.valueBox.setWidth("100%");
            grid.setWidget(0, 0, (Widget)this.valueBox);
            Grid buttonGrid = new Grid();
            buttonGrid.resize(2, 2);
            Button upButton = new Button("Up ^");
            buttonGrid.setWidget(0, 0, (Widget)upButton);
            Button downButton = new Button("Down v");
            buttonGrid.setWidget(1, 0, (Widget)downButton);
            Button addButton = new Button("< Add");
            buttonGrid.setWidget(0, 1, (Widget)addButton);
            Button removeButton = new Button("Remove >");
            buttonGrid.setWidget(1, 1, (Widget)removeButton);
            grid.setWidget(0, 1, (Widget)buttonGrid);
            if (eDataType != null) {
                this.textBox = new TextBox();
                this.textBox.setWidth("100%");
                grid.setWidget(0, 2, (Widget)this.textBox);
            } else {
                this.choiceBox = new ListBox();
                this.choiceBox.setMultipleSelect(true);
                this.choiceBox.setVisibleItemCount(4);
                this.choiceBox.setWidth("100%");
                grid.setWidget(0, 2, (Widget)this.choiceBox);
            }
            addButton.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    Object result;
                    Object object = result = FeatureEditor.this.isUnique() ? new UniqueEList(FeatureEditor.this.values) : new ArrayList(FeatureEditor.this.values);
                    if (eDataType != null) {
                        try {
                            Object value = EcoreUtil.createFromString((EDataType)eDataType, (String)FeatureEditor.this.textBox.getValue());
                            result.add(value);
                        }
                        catch (RuntimeException value) {}
                    } else {
                        int i = 0;
                        int size = FeatureEditor.this.choiceBox.getItemCount();
                        while (i < size) {
                            if (FeatureEditor.this.choiceBox.isItemSelected(i)) {
                                result.add(FeatureEditor.this.choiceOfValues.get(i));
                            }
                            ++i;
                        }
                    }
                    FeatureEditor.this.setValue(result);
                }
            });
            removeButton.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    Object result = FeatureEditor.this.isUnique() ? new UniqueEList(FeatureEditor.this.values) : new ArrayList(FeatureEditor.this.values);
                    int i = 0;
                    int size = FeatureEditor.this.valueBox.getItemCount();
                    while (i < size) {
                        if (FeatureEditor.this.valueBox.isItemSelected(i)) {
                            result.remove(FeatureEditor.this.values.get(i));
                        }
                        ++i;
                    }
                    FeatureEditor.this.setValue(result);
                }
            });
            upButton.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    BasicEList result = new BasicEList(FeatureEditor.this.values);
                    int i = 0;
                    int size = FeatureEditor.this.valueBox.getItemCount();
                    while (i < size) {
                        if (FeatureEditor.this.valueBox.isItemSelected(i) && i != 0) {
                            result.move(i, i - 1);
                        }
                        ++i;
                    }
                    FeatureEditor.this.setValue(result);
                }
            });
            downButton.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    BasicEList result = new BasicEList(FeatureEditor.this.values);
                    int i = 0;
                    int size = FeatureEditor.this.valueBox.getItemCount();
                    while (i < size) {
                        if (FeatureEditor.this.valueBox.isItemSelected(i) && i + 1 < size) {
                            result.move(i, i + 1);
                        }
                        ++i;
                    }
                    FeatureEditor.this.setValue(result);
                }
            });
            this.initWidget((Widget)grid);
        }

        protected void hook(ListBox listBox, List<?> values) {
        }

        public void update() {
            IItemLabelProvider labelProvider = this.getLabelProvider();
            List<?> oldValues = this.values;
            this.values = new ArrayList(this.getValues());
            ArrayList oldValueSelection = new ArrayList();
            int valueBoxItemCount = this.valueBox.getItemCount();
            if (valueBoxItemCount != 0) {
                int i = 0;
                while (i < valueBoxItemCount) {
                    if (this.valueBox.isItemSelected(i)) {
                        oldValueSelection.add(oldValues.get(i));
                    }
                    ++i;
                }
                this.valueBox.clear();
            }
            for (Object value : this.values) {
                this.valueBox.addItem(labelProvider.getText(value));
                if (!oldValueSelection.contains(value) && (oldValues == null || oldValues.contains(value))) continue;
                this.valueBox.setItemSelected(this.valueBox.getItemCount() - 1, true);
            }
            this.hook(this.valueBox, this.values);
            if (this.eDataType != null) {
                this.textBox.setValue((Object)"");
            } else {
                Collection<?> basicChoices;
                ArrayList oldChoiceSelection = new ArrayList();
                int choiceBoxItemCount = this.choiceBox.getItemCount();
                if (choiceBoxItemCount != 0) {
                    int i = 0;
                    while (i < choiceBoxItemCount) {
                        if (this.choiceBox.isItemSelected(i)) {
                            oldChoiceSelection.add(this.choiceOfValues.get(i));
                        }
                        ++i;
                    }
                    this.choiceBox.clear();
                }
                if ((basicChoices = this.getChoiceOfValues()) == null) {
                    this.choiceOfValues = null;
                } else {
                    this.choiceOfValues = new ArrayList(basicChoices);
                    if (this.isSortChoices) {
                        EditorEntryPoint.createItems(this.choiceOfValues, labelProvider, null, true);
                    }
                    for (Object value : this.choiceOfValues) {
                        this.choiceBox.addItem(labelProvider.getText(value));
                        if (!oldChoiceSelection.contains(value) && (oldValues == null || !oldValues.contains(value) || this.values.contains(value))) continue;
                        this.choiceBox.setItemSelected(this.choiceBox.getItemCount() - 1, true);
                    }
                    this.hook(this.choiceBox, this.choiceOfValues);
                }
            }
        }

        protected abstract IItemLabelProvider getLabelProvider();

        protected abstract List<?> getValues();

        protected abstract Collection<?> getChoiceOfValues();

        protected abstract boolean isMultiLine();

        protected abstract boolean isUnique();

        protected abstract void setValue(Object var1);
    }

    public static class ImageData {
        public int width;
        public int height;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ItemPropertyDescriptorFeatureEditor
    extends FeatureEditor {
        protected IItemPropertyDescriptor propertyDescriptor;

        public ItemPropertyDescriptorFeatureEditor(Object object, IItemPropertyDescriptor propertyDescriptor) {
            super(object, false, ((EAttribute)propertyDescriptor.getFeature(object)).getEAttributeType());
            this.propertyDescriptor = propertyDescriptor;
        }

        public ItemPropertyDescriptorFeatureEditor(Object object, boolean isSortChoices, IItemPropertyDescriptor propertyDescriptor) {
            super(object, isSortChoices, null);
            this.propertyDescriptor = propertyDescriptor;
        }

        @Override
        protected IItemLabelProvider getLabelProvider() {
            return this.propertyDescriptor.getLabelProvider(this.object);
        }

        @Override
        protected List<?> getValues() {
            Object propertyValue = this.propertyDescriptor.getPropertyValue(this.object);
            if (propertyValue instanceof IItemPropertySource) {
                propertyValue = ((IItemPropertySource)propertyValue).getEditableValue(propertyValue);
            }
            return (List)propertyValue;
        }

        @Override
        protected Collection<?> getChoiceOfValues() {
            return this.propertyDescriptor.getChoiceOfValues(this.object);
        }

        @Override
        protected boolean isMultiLine() {
            return this.propertyDescriptor.isMultiLine(this.object);
        }

        @Override
        protected boolean isUnique() {
            Object feature = this.propertyDescriptor.getFeature(this.object);
            return !(feature instanceof EStructuralFeature) || ((EStructuralFeature)feature).isUnique();
        }

        @Override
        protected void setValue(Object value) {
            this.propertyDescriptor.setPropertyValue(this.object, value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MyCellTree
    extends CellTree {
        public <T> MyCellTree(TreeViewModel viewModel, T rootValue) {
            super(viewModel, rootValue, (CellTree.Resources)GWT.create(CellTree.BasicResources.class));
        }

        public void expand(List<?> path) {
            TreeNode node = this.getRootTreeNode();
            if (node != null) {
                int i = 0;
                int size = path.size();
                block0: while (i < size) {
                    Object segment = path.get(i);
                    int j = 0;
                    int count = node.getChildCount();
                    while (j < count) {
                        Object childValue = node.getChildValue(j);
                        if (!childValue.equals(segment)) {
                            ++j;
                            continue;
                        }
                        node = node.setChildOpen(j, true);
                        ++i;
                        continue block0;
                    }
                    break block0;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StringPositionPair
    implements Comparable<StringPositionPair> {
        public String key;
        public int position;

        StringPositionPair(String key, int position) {
            this.key = key;
            this.position = position;
        }

        @Override
        public int compareTo(StringPositionPair object) {
            if (object == this || this.key == object.key) {
                return 0;
            }
            if (this.key == null) {
                return -1;
            }
            return this.key.compareTo(object.key);
        }
    }
}

