/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.common.util;

import java.io.PrintStream;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.Monitor;

public class BasicMonitor
implements Monitor {
    private boolean isCanceled;
    private Diagnostic blockedReason;

    @Override
    public boolean isCanceled() {
        return this.isCanceled;
    }

    @Override
    public void setCanceled(boolean isCanceled) {
        this.isCanceled = isCanceled;
    }

    public Diagnostic getBlockedReason() {
        return this.blockedReason;
    }

    @Override
    public void setBlocked(Diagnostic reason) {
        this.blockedReason = reason;
    }

    @Override
    public void clearBlocked() {
        this.blockedReason = null;
    }

    @Override
    public void beginTask(String name, int totalWork) {
    }

    @Override
    public void setTaskName(String name) {
    }

    @Override
    public void subTask(String name) {
    }

    @Override
    public void worked(int work) {
    }

    @Override
    public void internalWorked(double work) {
    }

    @Override
    public void done() {
    }

    public static class Delegating
    implements Monitor {
        protected Monitor monitor;

        public Delegating(Monitor monitor) {
            this.monitor = monitor;
        }

        @Override
        public boolean isCanceled() {
            return this.monitor.isCanceled();
        }

        @Override
        public void setCanceled(boolean value) {
            this.monitor.setCanceled(value);
        }

        @Override
        public void setBlocked(Diagnostic reason) {
            this.monitor.setBlocked(reason);
        }

        @Override
        public void clearBlocked() {
            this.monitor.clearBlocked();
        }

        @Override
        public void beginTask(String name, int totalWork) {
            this.monitor.beginTask(name, totalWork);
        }

        @Override
        public void setTaskName(String name) {
            this.monitor.setTaskName(name);
        }

        @Override
        public void subTask(String name) {
            this.monitor.subTask(name);
        }

        @Override
        public void worked(int work) {
            this.monitor.worked(work);
        }

        @Override
        public void internalWorked(double work) {
            this.monitor.internalWorked(work);
        }

        @Override
        public void done() {
            this.monitor.done();
        }
    }

    public static class Printing
    extends BasicMonitor {
        protected PrintStream printStream;

        public Printing(PrintStream printStream) {
            this.printStream = printStream;
        }

        @Override
        public void beginTask(String name, int totalWork) {
            if (name != null && name.length() != 0) {
                this.printStream.println(">>> " + name);
            }
        }

        @Override
        public void setTaskName(String name) {
            if (name != null && name.length() != 0) {
                this.printStream.println("<>> " + name);
            }
        }

        @Override
        public void subTask(String name) {
            if (name != null && name.length() != 0) {
                this.printStream.println(">>  " + name);
            }
        }

        @Override
        public void setBlocked(Diagnostic reason) {
            super.setBlocked(reason);
            this.printStream.println("#>  " + reason.getMessage());
        }

        @Override
        public void clearBlocked() {
            this.printStream.println("=>  " + this.getBlockedReason().getMessage());
            super.clearBlocked();
        }
    }
}

