/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.common.util;

import java.io.PrintStream;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.Monitor;

public class BasicMonitor
implements Monitor {
    private boolean isCanceled;
    private Diagnostic blockedReason;

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public void setCanceled(boolean isCanceled) {
        this.isCanceled = isCanceled;
    }

    public Diagnostic getBlockedReason() {
        return this.blockedReason;
    }

    public void setBlocked(Diagnostic reason) {
        this.blockedReason = reason;
    }

    public void clearBlocked() {
        this.blockedReason = null;
    }

    public void beginTask(String name, int totalWork) {
    }

    public void setTaskName(String name) {
    }

    public void subTask(String name) {
    }

    public void worked(int work) {
    }

    public void internalWorked(double work) {
    }

    public void done() {
    }

    public static class Delegating
    implements Monitor {
        protected Monitor monitor;

        public Delegating(Monitor monitor) {
            this.monitor = monitor;
        }

        public boolean isCanceled() {
            return this.monitor.isCanceled();
        }

        public void setCanceled(boolean value) {
            this.monitor.setCanceled(value);
        }

        public void setBlocked(Diagnostic reason) {
            this.monitor.setBlocked(reason);
        }

        public void clearBlocked() {
            this.monitor.clearBlocked();
        }

        public void beginTask(String name, int totalWork) {
            this.monitor.beginTask(name, totalWork);
        }

        public void setTaskName(String name) {
            this.monitor.setTaskName(name);
        }

        public void subTask(String name) {
            this.monitor.subTask(name);
        }

        public void worked(int work) {
            this.monitor.worked(work);
        }

        public void internalWorked(double work) {
            this.monitor.internalWorked(work);
        }

        public void done() {
            this.monitor.done();
        }
    }

    public static class Printing
    extends BasicMonitor {
        protected PrintStream printStream;

        public Printing(PrintStream printStream) {
            this.printStream = printStream;
        }

        public void beginTask(String name, int totalWork) {
            if (name != null && name.length() != 0) {
                this.printStream.println(">>> " + name);
            }
        }

        public void setTaskName(String name) {
            if (name != null && name.length() != 0) {
                this.printStream.println("<>> " + name);
            }
        }

        public void subTask(String name) {
            if (name != null && name.length() != 0) {
                this.printStream.println(">>  " + name);
            }
        }

        public void setBlocked(Diagnostic reason) {
            super.setBlocked(reason);
            this.printStream.println("#>  " + reason.getMessage());
        }

        public void clearBlocked() {
            this.printStream.println("=>  " + this.getBlockedReason().getMessage());
            super.clearBlocked();
        }
    }
}

