/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ha.backend;

import org.apache.catalina.ContainerEvent;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.ha.backend.CollectedInfo;
import org.apache.catalina.ha.backend.MultiCastSender;
import org.apache.catalina.ha.backend.Sender;
import org.apache.catalina.ha.backend.TcpSender;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class HeartbeatListener
implements LifecycleListener,
ContainerListener {
    private static final Log log = LogFactory.getLog(HeartbeatListener.class);
    private int port = 0;
    private String host = null;
    private final String ip = "224.0.1.105";
    private final int multiport = 23364;
    private final int ttl = 16;
    private final String proxyList;
    private final String proxyURL = "/HeartbeatListener";
    private CollectedInfo coll = null;
    private Sender sender = null;

    public HeartbeatListener() {
        this.proxyList = null;
    }

    public String getHost() {
        return this.host;
    }

    public String getGroup() {
        return "224.0.1.105";
    }

    public int getMultiport() {
        return 23364;
    }

    public int getTtl() {
        return 16;
    }

    public String getProxyList() {
        return this.proxyList;
    }

    public String getProxyURL() {
        return "/HeartbeatListener";
    }

    @Override
    public void containerEvent(ContainerEvent event) {
    }

    @Override
    public void lifecycleEvent(LifecycleEvent event) {
        if ("periodic".equals(event.getType())) {
            if (this.sender == null) {
                this.sender = this.proxyList == null ? new MultiCastSender() : new TcpSender();
            }
            if (this.coll == null) {
                try {
                    this.coll = new CollectedInfo(this.host, this.port);
                    this.port = this.coll.port;
                    this.host = this.coll.host;
                }
                catch (Exception ex) {
                    log.error("Unable to initialize info collection: " + ex);
                    this.coll = null;
                    return;
                }
            }
            try {
                this.sender.init(this);
            }
            catch (Exception ex) {
                log.error("Unable to initialize Sender: " + ex);
                this.sender = null;
                return;
            }
            try {
                this.coll.refresh();
            }
            catch (Exception ex) {
                log.error("Unable to collect load information: " + ex);
                this.coll = null;
                return;
            }
            String output = "v=1&ready=" + this.coll.ready + "&busy=" + this.coll.busy + "&port=" + this.port;
            try {
                this.sender.send(output);
            }
            catch (Exception ex) {
                log.error("Unable to send colllected load information: " + ex);
            }
        }
    }
}

