/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.commons.process;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.input.BoundedInputStream;

public class Piper
implements Runnable {
    private static final String BROKEN_PIPE = "Broken pipe";
    private static final long MAX_COMMAND_OUTPUT_LENGTH = 0x200000L;
    private InputStream input;
    private OutputStream output;

    public Piper(InputStream input, OutputStream output) {
        this.input = new BoundedInputStream(input, 0x200000L);
        this.output = output;
    }

    @Override
    public void run() {
        try {
            byte[] b = new byte[512];
            int read = 1;
            int sum = 0;
            while (read > -1) {
                read = this.input.read(b, 0, b.length);
                sum += read;
                if (read <= -1) continue;
                this.output.write(b, 0, read);
            }
            if ((long)sum >= 0x1FFFFFL) {
                this.output.write("\n...".getBytes(StandardCharsets.UTF_8));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(BROKEN_PIPE, e);
        }
        finally {
            try {
                this.input.close();
            }
            catch (Exception exception) {}
            try {
                this.output.close();
            }
            catch (Exception exception) {}
        }
    }
}

