/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.cms.managed;

import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.eclipse.dirigible.cms.api.ICmsProvider;
import org.eclipse.dirigible.commons.config.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmsProviderManaged
implements ICmsProvider {
    public static final String DIRIGIBLE_CMS_MANAGED_CONFIGURATION_JNDI_NAME = "DIRIGIBLE_CMS_MANAGED_CONFIGURATION_JNDI_NAME";
    public static final String DIRIGIBLE_CMS_MANAGED_CONFIGURATION_AUTH_METHOD = "DIRIGIBLE_CMS_MANAGED_CONFIGURATION_AUTH_METHOD";
    public static final String DIRIGIBLE_CMS_MANAGED_CONFIGURATION_AUTH_METHOD_KEY = "key";
    public static final String DIRIGIBLE_CMS_MANAGED_CONFIGURATION_AUTH_METHOD_DEST = "destination";
    public static final String DIRIGIBLE_CMS_MANAGED_CONFIGURATION_NAME = "DIRIGIBLE_CMS_MANAGED_CONFIGURATION_NAME";
    public static final String DIRIGIBLE_CMS_MANAGED_CONFIGURATION_KEY = "DIRIGIBLE_CMS_MANAGED_CONFIGURATION_KEY";
    public static final String DIRIGIBLE_CMS_MANAGED_CONFIGURATION_DESTINATION = "DIRIGIBLE_CMS_MANAGED_CONFIGURATION_DESTINATION";
    public static final String DIRIGIBLE_CONNECTIVITY_CONFIGURATION_JNDI_NAME = "DIRIGIBLE_CONNECTIVITY_CONFIGURATION_JNDI_NAME";
    public static final String NAME = "cmis";
    public static final String TYPE = "managed";
    private static final String PARAM_USER = "User";
    private static final String PARAM_PASSWORD = "Password";
    private static final Logger logger = LoggerFactory.getLogger(CmsProviderManaged.class);
    private Object cmisSession;

    public String getName() {
        return NAME;
    }

    public String getType() {
        return TYPE;
    }

    public Object getSession() {
        if (this.cmisSession == null) {
            try {
                this.cmisSession = this.lookupCmisSession();
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException | NamingException e) {
                String message = "Error in initializing the managed CMIS session";
                logger.error(message, (Throwable)e);
                throw new IllegalStateException(message, e);
            }
        }
        return this.cmisSession;
    }

    public Object lookupCmisSession() throws NamingException, NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        block9: {
            InitialContext ctx = new InitialContext();
            Configuration.load((String)"/dirigible-cms.properties");
            String key = Configuration.get((String)DIRIGIBLE_CMS_MANAGED_CONFIGURATION_JNDI_NAME);
            if (key != null) {
                Object ecmService = ctx.lookup(key);
                if (ecmService != null) {
                    String authMethod = Configuration.get((String)DIRIGIBLE_CMS_MANAGED_CONFIGURATION_AUTH_METHOD);
                    logger.debug(String.format("CMIS Authentication Method: %s", authMethod));
                    String uniqueName = null;
                    String secretKey = null;
                    if (DIRIGIBLE_CMS_MANAGED_CONFIGURATION_AUTH_METHOD_KEY.equals(authMethod)) {
                        uniqueName = Configuration.get((String)DIRIGIBLE_CMS_MANAGED_CONFIGURATION_NAME);
                        secretKey = Configuration.get((String)DIRIGIBLE_CMS_MANAGED_CONFIGURATION_KEY);
                    } else if (DIRIGIBLE_CMS_MANAGED_CONFIGURATION_AUTH_METHOD_DEST.equals(authMethod)) {
                        String destinationName = Configuration.get((String)DIRIGIBLE_CMS_MANAGED_CONFIGURATION_DESTINATION);
                        Properties destinationPropeties = this.initializeFromDestination(destinationName);
                        uniqueName = destinationPropeties.getProperty(PARAM_USER);
                        secretKey = destinationPropeties.getProperty(PARAM_PASSWORD);
                    } else {
                        String message = String.format("Connection to CMIS Repository was failed. Invalid Authentication Method: %s", authMethod);
                        logger.error(message);
                        throw new SecurityException(message);
                    }
                    logger.debug(String.format("Connecting to CMIS Repository with name: %s and key: %s", uniqueName, secretKey));
                    try {
                        Method connectMethod = ecmService.getClass().getMethod("connect", String.class, String.class);
                        Object openCmisSession = connectMethod.invoke(ecmService, uniqueName, secretKey);
                        if (openCmisSession != null) {
                            logger.debug("Connection to CMIS Repository was successful.");
                            return openCmisSession;
                        }
                        break block9;
                    }
                    catch (Throwable t) {
                        String message = "Connection to CMIS Repository was failed.";
                        logger.error(message, t);
                        throw new IllegalStateException(message, t);
                    }
                }
                String message = "ECM is requested as CMIS service, but it is not available.";
                logger.error(message);
                throw new IllegalStateException(message);
            }
            String message = "CMIS service JNDI name has not been provided.";
            logger.error(message);
            throw new IllegalArgumentException(message);
        }
        String message = "Initializing the managed CMIS session failed.";
        logger.error(message);
        throw new IllegalStateException(message);
    }

    private Properties initializeFromDestination(String destinationName) throws NamingException, NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        logger.debug(String.format("CMIS Lookup Destination: %s", destinationName));
        Object connectivityService = CmsProviderManaged.lookupConnectivityConfiguration();
        Method connectivityMethod = connectivityService.getClass().getMethod("getConnectivityConfiguration", new Class[0]);
        Object configuration = connectivityMethod.invoke(connectivityService, new Object[0]);
        Method configurationMethod = configuration.getClass().getMethod("getConfiguration", String.class);
        Object destinationConfiguration = configurationMethod.invoke(configuration, destinationName);
        Method propertiesMethod = destinationConfiguration.getClass().getMethod("getAllProperties", new Class[0]);
        Properties destinationPropeties = (Properties)propertiesMethod.invoke(destinationConfiguration, new Object[0]);
        logger.debug(String.format("CMIS Destination Properties: %s", CmsProviderManaged.getPropertiesAsString(destinationPropeties)));
        return destinationPropeties;
    }

    static Object lookupConnectivityConfiguration() throws NamingException {
        InitialContext ctx = new InitialContext();
        String key = Configuration.get((String)DIRIGIBLE_CONNECTIVITY_CONFIGURATION_JNDI_NAME);
        if (key != null) {
            return ctx.lookup(key);
        }
        return null;
    }

    private static String getPropertiesAsString(Properties prop) {
        if (prop == null) {
            return "null properties";
        }
        StringWriter writer = new StringWriter();
        try {
            prop.store(writer, "");
        }
        catch (IOException e) {
            logger.error("Connection to CMIS Repository was failed.", (Throwable)e);
        }
        return writer.getBuffer().toString();
    }
}

