/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspaceconnector.sql.lease;

import java.sql.Connection;
import java.time.Duration;
import java.util.Objects;
import org.eclipse.dataspaceconnector.spi.transaction.TransactionContext;
import org.eclipse.dataspaceconnector.sql.lease.LeaseStatements;
import org.eclipse.dataspaceconnector.sql.lease.SqlLeaseContext;

public class SqlLeaseContextBuilder {
    private final TransactionContext trxContext;
    private final LeaseStatements statements;
    private String leaseHolder;
    private Duration leaseDuration;

    private SqlLeaseContextBuilder(TransactionContext trxContext, LeaseStatements statements, String leaseHolder) {
        this.trxContext = trxContext;
        this.statements = statements;
        this.leaseHolder = leaseHolder;
    }

    public static SqlLeaseContextBuilder with(TransactionContext trxContext, String leaseHolder, LeaseStatements statements) {
        Objects.requireNonNull(trxContext, "trxContext");
        Objects.requireNonNull(leaseHolder, "leaseHolder");
        Objects.requireNonNull(statements, "statements");
        return new SqlLeaseContextBuilder(trxContext, statements, leaseHolder);
    }

    public SqlLeaseContextBuilder by(String leaseHolder) {
        this.leaseHolder = leaseHolder;
        return this;
    }

    public SqlLeaseContextBuilder forTime(Duration duration) {
        this.leaseDuration = duration;
        return this;
    }

    public SqlLeaseContext withConnection(Connection connection) {
        Objects.requireNonNull(connection, "connection");
        return new SqlLeaseContext(this.trxContext, this.statements, this.leaseHolder, this.leaseDuration, connection);
    }
}

