/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspaceconnector.sql.lease;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.eclipse.dataspaceconnector.spi.persistence.LeaseContext;
import org.eclipse.dataspaceconnector.spi.transaction.TransactionContext;
import org.eclipse.dataspaceconnector.sql.SqlQueryExecutor;
import org.eclipse.dataspaceconnector.sql.lease.LeaseStatements;
import org.eclipse.dataspaceconnector.sql.lease.SqlLease;
import org.jetbrains.annotations.Nullable;

public class SqlLeaseContext
implements LeaseContext {
    private static final long DEFAULT_LEASE_DURATION = 60000L;
    private final TransactionContext trxContext;
    private final LeaseStatements statements;
    private final String leaseHolder;
    private final Connection connection;
    private final Duration leaseDuration;

    SqlLeaseContext(TransactionContext trxContext, LeaseStatements statements, String leaseHolder, Duration leaseDuration, Connection connection) {
        this.trxContext = trxContext;
        this.statements = statements;
        this.leaseHolder = leaseHolder;
        this.leaseDuration = leaseDuration;
        this.connection = connection;
    }

    public void breakLease(String entityId) {
        this.trxContext.execute(() -> {
            SqlLease l = this.getLease(entityId);
            if (l != null) {
                if (!Objects.equals(this.leaseHolder, l.getLeasedBy())) {
                    throw new IllegalStateException("Current runtime does not hold the lease for Object (id [" + entityId + "]), cannot break lease!");
                }
                String stmt = this.statements.getDeleteLeaseTemplate();
                SqlQueryExecutor.executeQuery((Connection)this.connection, (String)stmt, (Object[])new Object[]{l.getLeaseId()});
            }
        });
    }

    public void acquireLease(String entityId) {
        this.trxContext.execute(() -> {
            long now = Instant.now().toEpochMilli();
            SqlLease lease = this.getLease(entityId);
            if (lease != null && !lease.isExpired()) {
                throw new IllegalStateException("Entity is currently leased!");
            }
            String deleteStmt = this.statements.getDeleteLeaseTemplate();
            SqlQueryExecutor.executeQuery((Connection)this.connection, (String)deleteStmt, (Object[])new Object[]{entityId});
            String id = UUID.randomUUID().toString();
            long duration = this.leaseDuration != null ? this.leaseDuration.toMillis() : 60000L;
            String stmt = this.statements.getInsertLeaseTemplate();
            SqlQueryExecutor.executeQuery((Connection)this.connection, (String)stmt, (Object[])new Object[]{id, this.leaseHolder, now, duration});
            String updStmt = this.statements.getUpdateLeaseTemplate();
            SqlQueryExecutor.executeQuery((Connection)this.connection, (String)updStmt, (Object[])new Object[]{id, entityId});
        });
    }

    @Nullable
    public SqlLease getLease(String entityId) {
        String stmt = this.statements.getFindLeaseByEntityTemplate();
        List leases = SqlQueryExecutor.executeQuery((Connection)this.connection, this::mapLease, (String)stmt, (Object[])new Object[]{entityId});
        return leases.stream().findFirst().orElse(null);
    }

    private SqlLease mapLease(ResultSet resultSet) throws SQLException {
        SqlLease lease = new SqlLease(resultSet.getString(this.statements.getLeasedByColumn()), resultSet.getLong(this.statements.getLeasedAtColumn()), resultSet.getLong(this.statements.getLeaseDurationColumn()));
        lease.setLeaseId(resultSet.getString(this.statements.getLeaseIdColumn()));
        return lease;
    }
}

