/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.immutable.primitive;

import org.eclipse.collections.api.BooleanIterable;
import org.eclipse.collections.api.factory.set.primitive.ImmutableBooleanSetFactory;
import org.eclipse.collections.api.set.primitive.ImmutableBooleanSet;
import org.eclipse.collections.impl.set.immutable.primitive.ImmutableBooleanEmptySet;
import org.eclipse.collections.impl.set.immutable.primitive.ImmutableFalseSet;
import org.eclipse.collections.impl.set.immutable.primitive.ImmutableTrueSet;

public enum ImmutableBooleanSetFactoryImpl implements ImmutableBooleanSetFactory
{
    INSTANCE;


    public ImmutableBooleanSet empty() {
        return ImmutableBooleanEmptySet.INSTANCE;
    }

    public ImmutableBooleanSet of() {
        return this.empty();
    }

    public ImmutableBooleanSet with() {
        return this.empty();
    }

    public ImmutableBooleanSet of(boolean one) {
        return this.with(one);
    }

    public ImmutableBooleanSet with(boolean one) {
        return one ? ImmutableTrueSet.INSTANCE : ImmutableFalseSet.INSTANCE;
    }

    public ImmutableBooleanSet of(boolean ... items) {
        return this.with(items);
    }

    public ImmutableBooleanSet with(boolean ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        ImmutableBooleanSet result = ImmutableBooleanEmptySet.INSTANCE;
        for (boolean item : items) {
            result = result.newWith(item);
        }
        return result;
    }

    public ImmutableBooleanSet ofAll(BooleanIterable items) {
        return this.withAll(items);
    }

    public ImmutableBooleanSet withAll(BooleanIterable items) {
        if (items instanceof ImmutableBooleanSet) {
            return (ImmutableBooleanSet)items;
        }
        return this.with(items.toArray());
    }
}

