/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.stack.mutable;

import org.eclipse.collections.api.factory.stack.MutableStackFactory;
import org.eclipse.collections.api.stack.MutableStack;
import org.eclipse.collections.impl.stack.mutable.ArrayStack;

public enum MutableStackFactoryImpl implements MutableStackFactory
{
    INSTANCE;


    public <T> MutableStack<T> empty() {
        return ArrayStack.newStack();
    }

    public <T> MutableStack<T> of() {
        return this.empty();
    }

    public <T> MutableStack<T> with() {
        return this.empty();
    }

    public <T> MutableStack<T> of(T ... elements) {
        return this.with(elements);
    }

    public <T> MutableStack<T> with(T ... elements) {
        return ArrayStack.newStackWith(elements);
    }

    public <T> MutableStack<T> ofAll(Iterable<? extends T> elements) {
        return this.withAll(elements);
    }

    public <T> MutableStack<T> withAll(Iterable<? extends T> elements) {
        return ArrayStack.newStack(elements);
    }

    public <T> MutableStack<T> ofReversed(T ... elements) {
        return this.withReversed(elements);
    }

    public <T> MutableStack<T> withReversed(T ... elements) {
        return ArrayStack.newStackFromTopToBottom(elements);
    }

    public <T> MutableStack<T> ofAllReversed(Iterable<? extends T> items) {
        return this.withAllReversed(items);
    }

    public <T> MutableStack<T> withAllReversed(Iterable<? extends T> items) {
        return ArrayStack.newStackFromTopToBottom(items);
    }
}

