/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.list.mutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.LazyByteIterable;
import org.eclipse.collections.api.block.function.primitive.ByteToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectByteIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BytePredicate;
import org.eclipse.collections.api.block.procedure.primitive.ByteIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ByteProcedure;
import org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import org.eclipse.collections.api.iterator.ByteIterator;
import org.eclipse.collections.api.iterator.MutableByteIterator;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.ByteList;
import org.eclipse.collections.api.list.primitive.ImmutableByteList;
import org.eclipse.collections.api.list.primitive.MutableByteList;
import org.eclipse.collections.api.set.primitive.ByteSet;
import org.eclipse.collections.api.tuple.primitive.ByteBytePair;
import org.eclipse.collections.api.tuple.primitive.ByteObjectPair;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.ByteLists;
import org.eclipse.collections.impl.lazy.primitive.ReverseByteIterable;
import org.eclipse.collections.impl.list.mutable.FastList;
import org.eclipse.collections.impl.list.mutable.primitive.SynchronizedByteList;
import org.eclipse.collections.impl.list.mutable.primitive.UnmodifiableByteList;
import org.eclipse.collections.impl.primitive.AbstractByteIterable;
import org.eclipse.collections.impl.set.mutable.primitive.ByteHashSet;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;
import org.eclipse.collections.impl.utility.Iterate;

public class ByteArrayList
extends AbstractByteIterable
implements MutableByteList,
Externalizable {
    private static final long serialVersionUID = 1L;
    private static final byte[] DEFAULT_SIZED_EMPTY_ARRAY = new byte[0];
    private static final byte[] ZERO_SIZED_ARRAY = new byte[0];
    private static final int MAXIMUM_ARRAY_SIZE = 0x7FFFFFF7;
    protected int size;
    protected transient byte[] items = DEFAULT_SIZED_EMPTY_ARRAY;

    public ByteArrayList() {
    }

    public ByteArrayList(int initialCapacity) {
        this.items = initialCapacity == 0 ? ZERO_SIZED_ARRAY : new byte[initialCapacity];
    }

    public ByteArrayList(byte ... array) {
        this.size = array.length;
        this.items = array;
    }

    public static ByteArrayList newListWith(byte ... elements) {
        return new ByteArrayList(elements);
    }

    public static ByteArrayList newList(ByteIterable source) {
        return ByteArrayList.newListWith(source.toArray());
    }

    public static ByteArrayList newWithNValues(int size, byte value) {
        ByteArrayList newList = new ByteArrayList(size);
        newList.size = size;
        Arrays.fill(newList.items, value);
        return newList;
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        Arrays.fill(this.items, 0, this.size, (byte)0);
        this.size = 0;
    }

    public boolean contains(byte value) {
        for (int i = 0; i < this.size; ++i) {
            if (this.items[i] != value) continue;
            return true;
        }
        return false;
    }

    public byte get(int index) {
        if (index < this.size) {
            return this.items[index];
        }
        throw this.newIndexOutOfBoundsException(index);
    }

    private IndexOutOfBoundsException newIndexOutOfBoundsException(int index) {
        return new IndexOutOfBoundsException("Index: " + index + " Size: " + this.size);
    }

    public byte getFirst() {
        this.checkEmpty();
        return this.items[0];
    }

    public byte getLast() {
        this.checkEmpty();
        return this.items[this.size() - 1];
    }

    private void checkEmpty() {
        if (this.isEmpty()) {
            throw this.newIndexOutOfBoundsException(0);
        }
    }

    public int indexOf(byte value) {
        for (int i = 0; i < this.size; ++i) {
            if (this.items[i] != value) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(byte value) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (this.items[i] != value) continue;
            return i;
        }
        return -1;
    }

    public void trimToSize() {
        if (this.size < this.items.length) {
            this.transferItemsToNewArrayWithCapacity(this.size);
        }
    }

    private void transferItemsToNewArrayWithCapacity(int newCapacity) {
        this.items = this.copyItemsWithNewCapacity(newCapacity);
    }

    private byte[] copyItemsWithNewCapacity(int newCapacity) {
        byte[] newItems = new byte[newCapacity];
        System.arraycopy(this.items, 0, newItems, 0, Math.min(this.size, newCapacity));
        return newItems;
    }

    private int sizePlusFiftyPercent(int oldSize) {
        int result = oldSize + (oldSize >> 1) + 1;
        return result < oldSize ? 0x7FFFFFF7 : result;
    }

    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.items.length;
        if (minCapacity > oldCapacity) {
            int newCapacity = Math.max(this.sizePlusFiftyPercent(oldCapacity), minCapacity);
            this.transferItemsToNewArrayWithCapacity(newCapacity);
        }
    }

    private void ensureCapacityForAdd() {
        if (this.items == DEFAULT_SIZED_EMPTY_ARRAY) {
            this.items = new byte[10];
        } else {
            this.transferItemsToNewArrayWithCapacity(this.sizePlusFiftyPercent(this.size));
        }
    }

    public boolean add(byte newItem) {
        if (this.items.length == this.size) {
            this.ensureCapacityForAdd();
        }
        this.items[this.size] = newItem;
        ++this.size;
        return true;
    }

    public boolean addAll(byte ... source) {
        if (source.length < 1) {
            return false;
        }
        this.copyItems(source.length, source);
        return true;
    }

    public boolean addAll(ByteIterable source) {
        if (source instanceof ByteArrayList) {
            if (source.isEmpty()) {
                return false;
            }
            ByteArrayList other = (ByteArrayList)source;
            this.copyItems(other.size(), other.items);
            return true;
        }
        return this.addAll(source.toArray());
    }

    private void copyItems(int sourceSize, byte[] source) {
        int newSize = this.size + sourceSize;
        this.ensureCapacity(newSize);
        System.arraycopy(source, 0, this.items, this.size, sourceSize);
        this.size = newSize;
    }

    private void throwOutOfBounds(int index) {
        throw this.newIndexOutOfBoundsException(index);
    }

    public void addAtIndex(int index, byte element) {
        if (index > -1 && index < this.size) {
            this.addAtIndexLessThanSize(index, element);
        } else if (index == this.size) {
            this.add(element);
        } else {
            this.throwOutOfBounds(index);
        }
    }

    private void addAtIndexLessThanSize(int index, byte element) {
        int oldSize;
        if (this.items.length == (oldSize = this.size++)) {
            byte[] newItems = new byte[this.sizePlusFiftyPercent(oldSize)];
            if (index > 0) {
                System.arraycopy(this.items, 0, newItems, 0, index);
            }
            System.arraycopy(this.items, index, newItems, index + 1, oldSize - index);
            this.items = newItems;
        } else {
            System.arraycopy(this.items, index, this.items, index + 1, oldSize - index);
        }
        this.items[index] = element;
    }

    public boolean addAllAtIndex(int index, byte ... source) {
        if (index > this.size || index < 0) {
            this.throwOutOfBounds(index);
        }
        if (source.length == 0) {
            return false;
        }
        int sourceSize = source.length;
        int newSize = this.size + sourceSize;
        this.ensureCapacity(newSize);
        this.shiftElementsAtIndex(index, sourceSize);
        System.arraycopy(source, 0, this.items, index, sourceSize);
        this.size = newSize;
        return true;
    }

    public boolean addAllAtIndex(int index, ByteIterable source) {
        return this.addAllAtIndex(index, source.toArray());
    }

    private void shiftElementsAtIndex(int index, int sourceSize) {
        int numberToMove = this.size - index;
        if (numberToMove > 0) {
            System.arraycopy(this.items, index, this.items, index + sourceSize, numberToMove);
        }
    }

    public boolean remove(byte value) {
        int index = this.indexOf(value);
        if (index >= 0) {
            this.removeAtIndex(index);
            return true;
        }
        return false;
    }

    public boolean removeIf(BytePredicate predicate) {
        int currentFilledIndex = 0;
        for (int i = 0; i < this.size; ++i) {
            byte item = this.items[i];
            if (predicate.accept(item)) continue;
            if (currentFilledIndex != i) {
                this.items[currentFilledIndex] = item;
            }
            ++currentFilledIndex;
        }
        boolean changed = currentFilledIndex < this.size;
        this.wipeAndResetTheEnd(currentFilledIndex);
        return changed;
    }

    private void wipeAndResetTheEnd(int newCurrentFilledIndex) {
        for (int i = newCurrentFilledIndex; i < this.size; ++i) {
            this.items[i] = 0;
        }
        this.size = newCurrentFilledIndex;
    }

    public boolean removeAll(ByteIterable source) {
        boolean modified = false;
        for (int index = 0; index < this.size; ++index) {
            if (!source.contains(this.get(index))) continue;
            this.removeAtIndex(index);
            --index;
            modified = true;
        }
        return modified;
    }

    public boolean removeAll(byte ... source) {
        ByteHashSet set = ByteHashSet.newSetWith(source);
        byte[] newItems = new byte[this.size];
        int count = 0;
        int oldSize = this.size;
        for (int index = 0; index < this.size; ++index) {
            if (set.contains(this.items[index])) continue;
            newItems[count] = this.items[index];
            ++count;
        }
        this.items = newItems;
        this.size = count;
        return oldSize != this.size;
    }

    public boolean retainAll(ByteIterable source) {
        int oldSize = this.size();
        ByteSet sourceSet = source instanceof ByteSet ? (ByteSet)source : source.toSet();
        ByteArrayList retained = this.select(arg_0 -> ((ByteSet)sourceSet).contains(arg_0));
        this.size = retained.size;
        this.items = retained.items;
        return oldSize != this.size();
    }

    public boolean retainAll(byte ... source) {
        return this.retainAll((ByteIterable)ByteHashSet.newSetWith(source));
    }

    public byte removeAtIndex(int index) {
        byte previous = this.get(index);
        int totalOffset = this.size - index - 1;
        if (totalOffset > 0) {
            System.arraycopy(this.items, index + 1, this.items, index, totalOffset);
        }
        --this.size;
        this.items[this.size] = 0;
        return previous;
    }

    public byte set(int index, byte element) {
        byte previous = this.get(index);
        this.items[index] = element;
        return previous;
    }

    public ByteArrayList with(byte element) {
        this.add(element);
        return this;
    }

    public ByteArrayList without(byte element) {
        this.remove(element);
        return this;
    }

    public ByteArrayList withAll(ByteIterable elements) {
        this.addAll(elements.toArray());
        return this;
    }

    public ByteArrayList withoutAll(ByteIterable elements) {
        this.removeAll(elements);
        return this;
    }

    public ByteArrayList with(byte element1, byte element2) {
        this.add(element1);
        this.add(element2);
        return this;
    }

    public ByteArrayList with(byte element1, byte element2, byte element3) {
        this.add(element1);
        this.add(element2);
        this.add(element3);
        return this;
    }

    public ByteArrayList with(byte element1, byte element2, byte element3, byte ... elements) {
        this.add(element1);
        this.add(element2);
        this.add(element3);
        return this.withArrayCopy(elements, 0, elements.length);
    }

    private ByteArrayList withArrayCopy(byte[] elements, int begin, int length) {
        this.ensureCapacity(this.size + length);
        System.arraycopy(elements, begin, this.items, this.size, length);
        this.size += length;
        return this;
    }

    public MutableByteIterator byteIterator() {
        return new InternalByteIterator();
    }

    public void forEach(ByteProcedure procedure) {
        this.each(procedure);
    }

    public void each(ByteProcedure procedure) {
        for (int i = 0; i < this.size; ++i) {
            procedure.value(this.items[i]);
        }
    }

    public void forEachWithIndex(ByteIntProcedure procedure) {
        for (int i = 0; i < this.size; ++i) {
            procedure.value(this.items[i], i);
        }
    }

    public <T> T injectInto(T injectedValue, ObjectByteToObjectFunction<? super T, ? extends T> function) {
        Object result = injectedValue;
        for (int i = 0; i < this.size; ++i) {
            result = function.valueOf(result, this.items[i]);
        }
        return result;
    }

    public <T> T injectIntoWithIndex(T injectedValue, ObjectByteIntToObjectFunction<? super T, ? extends T> function) {
        Object result = injectedValue;
        for (int i = 0; i < this.size; ++i) {
            result = function.valueOf(result, this.items[i], i);
        }
        return result;
    }

    public int count(BytePredicate predicate) {
        int count = 0;
        for (int i = 0; i < this.size; ++i) {
            if (!predicate.accept(this.items[i])) continue;
            ++count;
        }
        return count;
    }

    public boolean anySatisfy(BytePredicate predicate) {
        for (int i = 0; i < this.size; ++i) {
            if (!predicate.accept(this.items[i])) continue;
            return true;
        }
        return false;
    }

    public boolean allSatisfy(BytePredicate predicate) {
        for (int i = 0; i < this.size; ++i) {
            if (predicate.accept(this.items[i])) continue;
            return false;
        }
        return true;
    }

    public boolean noneSatisfy(BytePredicate predicate) {
        return !this.anySatisfy(predicate);
    }

    public ByteArrayList select(BytePredicate predicate) {
        return this.select(predicate, new ByteArrayList());
    }

    public <R extends MutableByteCollection> R select(BytePredicate predicate, R target) {
        for (int i = 0; i < this.size; ++i) {
            byte item = this.items[i];
            if (!predicate.accept(item)) continue;
            target.add(item);
        }
        return target;
    }

    public ByteArrayList reject(BytePredicate predicate) {
        return this.reject(predicate, new ByteArrayList());
    }

    public <R extends MutableByteCollection> R reject(BytePredicate predicate, R target) {
        for (int i = 0; i < this.size; ++i) {
            byte item = this.items[i];
            if (predicate.accept(item)) continue;
            target.add(item);
        }
        return target;
    }

    public byte detectIfNone(BytePredicate predicate, byte ifNone) {
        for (int i = 0; i < this.size; ++i) {
            byte item = this.items[i];
            if (!predicate.accept(item)) continue;
            return item;
        }
        return ifNone;
    }

    public <V> MutableList<V> collect(ByteToObjectFunction<? extends V> function) {
        return this.collect(function, (Collection)((Object)FastList.newList(this.size)));
    }

    public <V, R extends Collection<V>> R collect(ByteToObjectFunction<? extends V> function, R target) {
        for (int i = 0; i < this.size; ++i) {
            target.add((Object)function.valueOf(this.items[i]));
        }
        return target;
    }

    public byte max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        byte max = this.items[0];
        for (int i = 1; i < this.size; ++i) {
            byte value = this.items[i];
            if (max >= value) continue;
            max = value;
        }
        return max;
    }

    public byte min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        byte min = this.items[0];
        for (int i = 1; i < this.size; ++i) {
            byte value = this.items[i];
            if (value >= min) continue;
            min = value;
        }
        return min;
    }

    public long sum() {
        long result = 0L;
        for (int i = 0; i < this.size; ++i) {
            result += (long)this.items[i];
        }
        return result;
    }

    public long dotProduct(ByteList list) {
        if (this.size != list.size()) {
            throw new IllegalArgumentException("Lists used in dotProduct must be the same size");
        }
        long sum = 0L;
        for (int i = 0; i < this.size; ++i) {
            sum += (long)this.items[i] * (long)list.get(i);
        }
        return sum;
    }

    public byte[] toArray() {
        byte[] newItems = new byte[this.size];
        System.arraycopy(this.items, 0, newItems, 0, this.size);
        return newItems;
    }

    public boolean equals(Object otherList) {
        if (otherList == this) {
            return true;
        }
        if (!(otherList instanceof ByteList)) {
            return false;
        }
        ByteList list = (ByteList)otherList;
        if (this.size != list.size()) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.items[i] == list.get(i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        for (int i = 0; i < this.size; ++i) {
            byte item = this.items[i];
            hashCode = 31 * hashCode + item;
        }
        return hashCode;
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            for (int i = 0; i < this.size; ++i) {
                if (i > 0) {
                    appendable.append(separator);
                }
                byte value = this.items[i];
                appendable.append(String.valueOf(value));
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public MutableByteList asUnmodifiable() {
        return new UnmodifiableByteList(this);
    }

    public MutableByteList asSynchronized() {
        return new SynchronizedByteList(this);
    }

    public ImmutableByteList toImmutable() {
        if (this.size == 0) {
            return ByteLists.immutable.empty();
        }
        if (this.size == 1) {
            return ByteLists.immutable.with(this.items[0]);
        }
        return ByteLists.immutable.with(this.toArray());
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size);
        for (int i = 0; i < this.size; ++i) {
            out.writeByte(this.items[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.size = in.readInt();
        this.items = new byte[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.items[i] = in.readByte();
        }
    }

    public LazyByteIterable asReversed() {
        return ReverseByteIterable.adapt((ByteList)this);
    }

    public ByteArrayList reverseThis() {
        int endIndex = this.size - 1;
        for (int i = 0; i < this.size / 2; ++i) {
            byte tempSwapValue = this.items[i];
            this.items[i] = this.items[endIndex - i];
            this.items[endIndex - i] = tempSwapValue;
        }
        return this;
    }

    public ByteArrayList sortThis() {
        Arrays.sort(this.items, 0, this.size);
        return this;
    }

    public ByteArrayList toReversed() {
        return ByteArrayList.newList((ByteIterable)this.asReversed());
    }

    public int binarySearch(byte value) {
        return Arrays.binarySearch(this.items, 0, this.size, value);
    }

    public MutableByteList distinct() {
        ByteArrayList target = new ByteArrayList();
        ByteHashSet seenSoFar = new ByteHashSet(this.size());
        for (int i = 0; i < this.size; ++i) {
            byte each = this.items[i];
            if (!seenSoFar.add(each)) continue;
            target.add(each);
        }
        return target;
    }

    public MutableByteList subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException("subList not yet implemented!");
    }

    public MutableList<ByteBytePair> zipByte(ByteIterable iterable) {
        int size = this.size();
        int otherSize = iterable.size();
        MutableList target = Lists.mutable.withInitialCapacity(Math.min(size, otherSize));
        ByteIterator iterator = iterable.byteIterator();
        for (int i = 0; i < size && i < otherSize; ++i) {
            target.add((Object)PrimitiveTuples.pair(this.items[i], iterator.next()));
        }
        return target;
    }

    public <T> MutableList<ByteObjectPair<T>> zip(Iterable<T> iterable) {
        int size = this.size();
        int otherSize = Iterate.sizeOf(iterable);
        MutableList target = Lists.mutable.withInitialCapacity(Math.min(size, otherSize));
        Iterator<T> iterator = iterable.iterator();
        for (int i = 0; i < size && iterator.hasNext(); ++i) {
            target.add(PrimitiveTuples.pair(this.items[i], iterator.next()));
        }
        return target;
    }

    private class InternalByteIterator
    implements MutableByteIterator {
        private int currentIndex;
        private int lastIndex = -1;

        private InternalByteIterator() {
        }

        public boolean hasNext() {
            return this.currentIndex != ByteArrayList.this.size();
        }

        public byte next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            byte next = ByteArrayList.this.items[this.currentIndex];
            this.lastIndex = this.currentIndex++;
            return next;
        }

        public void remove() {
            if (this.lastIndex == -1) {
                throw new IllegalStateException();
            }
            ByteArrayList.this.removeAtIndex(this.lastIndex);
            --this.currentIndex;
            this.lastIndex = -1;
        }
    }
}

