/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.LazyByteIterable;
import org.eclipse.collections.api.LazyFloatIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.primitive.ImmutableByteBag;
import org.eclipse.collections.api.bag.primitive.MutableByteBag;
import org.eclipse.collections.api.block.function.primitive.ByteToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BytePredicate;
import org.eclipse.collections.api.block.predicate.primitive.FloatBytePredicate;
import org.eclipse.collections.api.block.procedure.primitive.ByteProcedure;
import org.eclipse.collections.api.block.procedure.primitive.FloatByteProcedure;
import org.eclipse.collections.api.block.procedure.primitive.FloatProcedure;
import org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import org.eclipse.collections.api.iterator.ByteIterator;
import org.eclipse.collections.api.list.primitive.MutableByteList;
import org.eclipse.collections.api.map.primitive.FloatByteMap;
import org.eclipse.collections.api.map.primitive.ImmutableByteFloatMap;
import org.eclipse.collections.api.map.primitive.ImmutableFloatByteMap;
import org.eclipse.collections.api.set.primitive.MutableByteSet;
import org.eclipse.collections.api.set.primitive.MutableFloatSet;
import org.eclipse.collections.api.tuple.primitive.FloatBytePair;
import org.eclipse.collections.impl.bag.mutable.primitive.ByteHashBag;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableByteCollection;
import org.eclipse.collections.impl.factory.Bags;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.ByteBags;
import org.eclipse.collections.impl.factory.primitive.ByteFloatMaps;
import org.eclipse.collections.impl.factory.primitive.FloatByteMaps;
import org.eclipse.collections.impl.factory.primitive.FloatLists;
import org.eclipse.collections.impl.iterator.UnmodifiableByteIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyByteIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.ByteArrayList;
import org.eclipse.collections.impl.map.mutable.primitive.FloatByteHashMap;
import org.eclipse.collections.impl.set.mutable.primitive.ByteHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.FloatHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableFloatSet;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;

final class ImmutableFloatByteSingletonMap
implements ImmutableFloatByteMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final byte EMPTY_VALUE = 0;
    private final float key1;
    private final byte value1;

    ImmutableFloatByteSingletonMap(float key1, byte value1) {
        this.key1 = key1;
        this.value1 = value1;
    }

    public byte get(float key) {
        return this.getIfAbsent(key, (byte)0);
    }

    public byte getIfAbsent(float key, byte ifAbsent) {
        return Float.compare(this.key1, key) == 0 ? this.value1 : ifAbsent;
    }

    public byte getOrThrow(float key) {
        if (Float.compare(this.key1, key) == 0) {
            return this.value1;
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(float key) {
        return Float.compare(this.key1, key) == 0;
    }

    public boolean containsValue(byte value) {
        return this.value1 == value;
    }

    public void forEachValue(ByteProcedure procedure) {
        procedure.value(this.value1);
    }

    public void forEachKey(FloatProcedure procedure) {
        procedure.value(this.key1);
    }

    public void forEachKeyValue(FloatByteProcedure procedure) {
        procedure.value(this.key1, this.value1);
    }

    public LazyFloatIterable keysView() {
        return FloatLists.immutable.of(this.key1).asLazy();
    }

    public RichIterable<FloatBytePair> keyValuesView() {
        return Lists.immutable.of((Object)PrimitiveTuples.pair(this.key1, this.value1)).asLazy();
    }

    public ImmutableByteFloatMap flipUniqueValues() {
        return ByteFloatMaps.immutable.with(this.value1, this.key1);
    }

    public ImmutableFloatByteMap select(FloatBytePredicate predicate) {
        return predicate.accept(this.key1, this.value1) ? FloatByteHashMap.newWithKeysValues(this.key1, this.value1).toImmutable() : new FloatByteHashMap().toImmutable();
    }

    public ImmutableFloatByteMap reject(FloatBytePredicate predicate) {
        return predicate.accept(this.key1, this.value1) ? new FloatByteHashMap().toImmutable() : FloatByteHashMap.newWithKeysValues(this.key1, this.value1).toImmutable();
    }

    public <T> T injectInto(T injectedValue, ObjectByteToObjectFunction<? super T, ? extends T> function) {
        return (T)function.valueOf(injectedValue, this.value1);
    }

    public ImmutableFloatByteMap toImmutable() {
        return this;
    }

    public ByteIterator byteIterator() {
        return new UnmodifiableByteIterator((ByteIterator)FloatByteHashMap.newWithKeysValues(this.key1, this.value1).byteIterator());
    }

    public void forEach(ByteProcedure procedure) {
        this.each(procedure);
    }

    public void each(ByteProcedure procedure) {
        procedure.value(this.value1);
    }

    public int count(BytePredicate predicate) {
        return predicate.accept(this.value1) ? 1 : 0;
    }

    public long sum() {
        return this.value1;
    }

    public byte min() {
        return this.value1;
    }

    public byte max() {
        return this.value1;
    }

    public byte maxIfEmpty(byte defaultValue) {
        return this.value1;
    }

    public byte minIfEmpty(byte defaultValue) {
        return this.value1;
    }

    public double average() {
        return this.value1;
    }

    public double median() {
        return this.value1;
    }

    public byte[] toSortedArray() {
        return new byte[]{this.value1};
    }

    public MutableByteList toSortedList() {
        return ByteArrayList.newListWith(this.value1);
    }

    public boolean anySatisfy(BytePredicate predicate) {
        return predicate.accept(this.value1);
    }

    public boolean allSatisfy(BytePredicate predicate) {
        return predicate.accept(this.value1);
    }

    public boolean noneSatisfy(BytePredicate predicate) {
        return !predicate.accept(this.value1);
    }

    public ImmutableByteBag select(BytePredicate predicate) {
        return predicate.accept(this.value1) ? ByteHashBag.newBagWith(this.value1).toImmutable() : ByteBags.immutable.empty();
    }

    public ImmutableByteBag reject(BytePredicate predicate) {
        return predicate.accept(this.value1) ? ByteBags.immutable.empty() : ByteHashBag.newBagWith(this.value1).toImmutable();
    }

    public <V> ImmutableBag<V> collect(ByteToObjectFunction<? extends V> function) {
        return Bags.immutable.of(function.valueOf(this.value1));
    }

    public byte detectIfNone(BytePredicate predicate, byte ifNone) {
        return predicate.accept(this.value1) ? this.value1 : ifNone;
    }

    public byte[] toArray() {
        return new byte[]{this.value1};
    }

    public boolean contains(byte value) {
        return this.value1 == value;
    }

    public boolean containsAll(byte ... source) {
        for (byte value : source) {
            if (this.value1 == value) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(ByteIterable source) {
        ByteIterator iterator = source.byteIterator();
        while (iterator.hasNext()) {
            if (this.value1 == iterator.next()) continue;
            return false;
        }
        return true;
    }

    public MutableByteList toList() {
        return ByteArrayList.newListWith(this.value1);
    }

    public MutableByteSet toSet() {
        return ByteHashSet.newSetWith(this.value1);
    }

    public MutableByteBag toBag() {
        return ByteHashBag.newBagWith(this.value1);
    }

    public LazyByteIterable asLazy() {
        return new LazyByteIterableAdapter((ByteIterable)this);
    }

    public ImmutableFloatByteMap newWithKeyValue(float key, byte value) {
        return FloatByteMaps.immutable.withAll((FloatByteMap)FloatByteHashMap.newWithKeysValues(this.key1, this.value1, key, value));
    }

    public ImmutableFloatByteMap newWithoutKey(float key) {
        return Float.compare(this.key1, key) == 0 ? FloatByteMaps.immutable.with() : this;
    }

    public ImmutableFloatByteMap newWithoutAllKeys(FloatIterable keys) {
        return keys.contains(this.key1) ? FloatByteMaps.immutable.with() : this;
    }

    public int size() {
        return 1;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean notEmpty() {
        return true;
    }

    public MutableFloatSet keySet() {
        return UnmodifiableFloatSet.of(FloatHashSet.newSetWith(this.key1));
    }

    public MutableByteCollection values() {
        return UnmodifiableByteCollection.of((MutableByteCollection)ByteArrayList.newListWith(this.value1));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FloatByteMap)) {
            return false;
        }
        FloatByteMap map = (FloatByteMap)obj;
        if (map.size() != 1) {
            return false;
        }
        return map.containsKey(this.key1) && this.value1 == map.getOrThrow(this.key1);
    }

    public int hashCode() {
        return Float.floatToIntBits(this.key1) ^ this.value1;
    }

    public String toString() {
        return "{" + this.key1 + "=" + this.value1 + "}";
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.value1));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

