/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.sorted.mutable;

import java.util.SortedMap;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.collection.primitive.MutableBooleanCollection;
import org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import org.eclipse.collections.api.collection.primitive.MutableDoubleCollection;
import org.eclipse.collections.api.collection.primitive.MutableFloatCollection;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.collection.primitive.MutableShortCollection;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.MutableBooleanList;
import org.eclipse.collections.api.list.primitive.MutableByteList;
import org.eclipse.collections.api.list.primitive.MutableCharList;
import org.eclipse.collections.api.list.primitive.MutableDoubleList;
import org.eclipse.collections.api.list.primitive.MutableFloatList;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.list.primitive.MutableShortList;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.map.sorted.ImmutableSortedMap;
import org.eclipse.collections.api.map.sorted.MutableSortedMap;
import org.eclipse.collections.api.multimap.list.MutableListMultimap;
import org.eclipse.collections.api.multimap.sortedset.MutableSortedSetMultimap;
import org.eclipse.collections.api.ordered.OrderedIterable;
import org.eclipse.collections.api.partition.list.PartitionMutableList;
import org.eclipse.collections.api.stack.MutableStack;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.block.factory.Functions;
import org.eclipse.collections.impl.block.factory.Predicates;
import org.eclipse.collections.impl.block.procedure.MapCollectProcedure;
import org.eclipse.collections.impl.block.procedure.PartitionPredicate2Procedure;
import org.eclipse.collections.impl.block.procedure.PartitionProcedure;
import org.eclipse.collections.impl.block.procedure.SelectInstancesOfProcedure;
import org.eclipse.collections.impl.block.procedure.primitive.CollectBooleanProcedure;
import org.eclipse.collections.impl.block.procedure.primitive.CollectByteProcedure;
import org.eclipse.collections.impl.block.procedure.primitive.CollectCharProcedure;
import org.eclipse.collections.impl.block.procedure.primitive.CollectDoubleProcedure;
import org.eclipse.collections.impl.block.procedure.primitive.CollectFloatProcedure;
import org.eclipse.collections.impl.block.procedure.primitive.CollectIntProcedure;
import org.eclipse.collections.impl.block.procedure.primitive.CollectLongProcedure;
import org.eclipse.collections.impl.block.procedure.primitive.CollectShortProcedure;
import org.eclipse.collections.impl.factory.SortedMaps;
import org.eclipse.collections.impl.list.fixed.ArrayAdapter;
import org.eclipse.collections.impl.list.mutable.FastList;
import org.eclipse.collections.impl.list.mutable.primitive.BooleanArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.ByteArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.CharArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.DoubleArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.FloatArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.IntArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.LongArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.ShortArrayList;
import org.eclipse.collections.impl.map.mutable.AbstractMutableMapIterable;
import org.eclipse.collections.impl.map.mutable.UnifiedMap;
import org.eclipse.collections.impl.map.sorted.mutable.SynchronizedSortedMap;
import org.eclipse.collections.impl.map.sorted.mutable.TreeSortedMap;
import org.eclipse.collections.impl.map.sorted.mutable.UnmodifiableTreeMap;
import org.eclipse.collections.impl.multimap.list.FastListMultimap;
import org.eclipse.collections.impl.partition.list.PartitionFastList;
import org.eclipse.collections.impl.utility.Iterate;
import org.eclipse.collections.impl.utility.MapIterate;

public abstract class AbstractMutableSortedMap<K, V>
extends AbstractMutableMapIterable<K, V>
implements MutableSortedMap<K, V> {
    public abstract MutableSortedMap<K, V> clone();

    public MutableSortedMap<K, V> withKeyValue(K key, V value) {
        this.put(key, value);
        return this;
    }

    public MutableSortedMap<K, V> withAllKeyValues(Iterable<? extends Pair<? extends K, ? extends V>> keyValues) {
        for (Pair<K, V> pair : keyValues) {
            this.put(pair.getOne(), pair.getTwo());
        }
        return this;
    }

    public MutableSortedMap<K, V> withAllKeyValueArguments(Pair<? extends K, ? extends V> ... keyValues) {
        return this.withAllKeyValues((Iterable<? extends Pair<? extends K, ? extends V>>)((Object)ArrayAdapter.adapt(keyValues)));
    }

    public MutableSortedMap<K, V> withoutKey(K key) {
        this.removeKey(key);
        return this;
    }

    public MutableSortedMap<K, V> withoutAllKeys(Iterable<? extends K> keys) {
        for (K key : keys) {
            this.removeKey(key);
        }
        return this;
    }

    public MutableSortedMap<K, V> asUnmodifiable() {
        return UnmodifiableTreeMap.of(this);
    }

    public ImmutableSortedMap<K, V> toImmutable() {
        return SortedMaps.immutable.withSortedMap((SortedMap)((Object)this));
    }

    public MutableSortedMap<K, V> asSynchronized() {
        return SynchronizedSortedMap.of(this);
    }

    public MutableSortedSetMultimap<V, K> flip() {
        return MapIterate.flip(this);
    }

    public MutableBooleanList collectBoolean(BooleanFunction<? super V> booleanFunction) {
        BooleanArrayList result = new BooleanArrayList(this.size());
        this.forEach(new CollectBooleanProcedure<V>(booleanFunction, (MutableBooleanCollection)result));
        return result;
    }

    public MutableByteList collectByte(ByteFunction<? super V> byteFunction) {
        ByteArrayList result = new ByteArrayList(this.size());
        this.forEach(new CollectByteProcedure<V>(byteFunction, (MutableByteCollection)result));
        return result;
    }

    public MutableCharList collectChar(CharFunction<? super V> charFunction) {
        CharArrayList result = new CharArrayList(this.size());
        this.forEach(new CollectCharProcedure<V>(charFunction, (MutableCharCollection)result));
        return result;
    }

    public MutableDoubleList collectDouble(DoubleFunction<? super V> doubleFunction) {
        DoubleArrayList result = new DoubleArrayList(this.size());
        this.forEach(new CollectDoubleProcedure<V>(doubleFunction, (MutableDoubleCollection)result));
        return result;
    }

    public MutableFloatList collectFloat(FloatFunction<? super V> floatFunction) {
        FloatArrayList result = new FloatArrayList(this.size());
        this.forEach(new CollectFloatProcedure<V>(floatFunction, (MutableFloatCollection)result));
        return result;
    }

    public MutableIntList collectInt(IntFunction<? super V> intFunction) {
        IntArrayList result = new IntArrayList(this.size());
        this.forEach(new CollectIntProcedure<V>(intFunction, (MutableIntCollection)result));
        return result;
    }

    public MutableLongList collectLong(LongFunction<? super V> longFunction) {
        LongArrayList result = new LongArrayList(this.size());
        this.forEach(new CollectLongProcedure<V>(longFunction, (MutableLongCollection)result));
        return result;
    }

    public MutableShortList collectShort(ShortFunction<? super V> shortFunction) {
        ShortArrayList result = new ShortArrayList(this.size());
        this.forEach(new CollectShortProcedure<V>(shortFunction, (MutableShortCollection)result));
        return result;
    }

    public <E> MutableSortedMap<K, V> collectKeysAndValues(Iterable<E> iterable, Function<? super E, ? extends K> keyFunction, Function<? super E, ? extends V> valueFunction) {
        Iterate.forEach(iterable, new MapCollectProcedure<E, K, V>(this, keyFunction, valueFunction));
        return this;
    }

    public <R> MutableSortedMap<K, R> collectValues(Function2<? super K, ? super V, ? extends R> function) {
        return MapIterate.collectValues(this, function, TreeSortedMap.newMap(this.comparator()));
    }

    public MutableSortedMap<K, V> tap(Procedure<? super V> procedure) {
        this.forEach(procedure);
        return this;
    }

    public MutableSortedMap<K, V> select(Predicate2<? super K, ? super V> predicate) {
        return MapIterate.selectMapOnEntry(this, predicate, this.newEmpty());
    }

    public MutableSortedMap<K, V> reject(Predicate2<? super K, ? super V> predicate) {
        return MapIterate.rejectMapOnEntry(this, predicate, this.newEmpty());
    }

    public <R> MutableList<R> collect(Function<? super V, ? extends R> function) {
        return this.collect(function, FastList.newList(this.size()));
    }

    public <P, VV> MutableList<VV> collectWith(Function2<? super V, ? super P, ? extends VV> function, P parameter) {
        return this.collect((Function<? super V, ? extends R>)((Function)Functions.bind(function, parameter)));
    }

    public <R> MutableList<R> collectIf(Predicate<? super V> predicate, Function<? super V, ? extends R> function) {
        return this.collectIf(predicate, function, FastList.newList(this.size()));
    }

    public <R> MutableList<R> flatCollect(Function<? super V, ? extends Iterable<R>> function) {
        return this.flatCollect(function, FastList.newList(this.size()));
    }

    public MutableList<V> reject(Predicate<? super V> predicate) {
        return this.reject(predicate, FastList.newList(this.size()));
    }

    public <P> MutableList<V> selectWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return this.select(Predicates.bind(predicate, parameter));
    }

    public <P> MutableList<V> rejectWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return this.reject(Predicates.bind(predicate, parameter));
    }

    public MutableList<V> select(Predicate<? super V> predicate) {
        return this.select(predicate, FastList.newList(this.size()));
    }

    public PartitionMutableList<V> partition(Predicate<? super V> predicate) {
        PartitionFastList partitionMutableList = new PartitionFastList();
        this.forEach(new PartitionProcedure<V>(predicate, partitionMutableList));
        return partitionMutableList;
    }

    public <P> PartitionMutableList<V> partitionWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        PartitionFastList partitionMutableList = new PartitionFastList();
        this.forEach(new PartitionPredicate2Procedure<V, P>(predicate, parameter, partitionMutableList));
        return partitionMutableList;
    }

    public <S> MutableList<S> selectInstancesOf(Class<S> clazz) {
        FastList result = FastList.newList(this.size());
        this.forEach(new SelectInstancesOfProcedure<S>(clazz, result));
        result.trimToSize();
        return result;
    }

    public <S> MutableList<Pair<V, S>> zip(Iterable<S> that) {
        return this.zip(that, FastList.newList(this.size()));
    }

    public MutableList<Pair<V, Integer>> zipWithIndex() {
        return this.zipWithIndex(FastList.newList(this.size()));
    }

    public <VV> MutableListMultimap<VV, V> groupBy(Function<? super V, ? extends VV> function) {
        return this.groupBy(function, FastListMultimap.newMultimap());
    }

    public <VV> MutableListMultimap<VV, V> groupByEach(Function<? super V, ? extends Iterable<VV>> function) {
        return this.groupByEach(function, FastListMultimap.newMultimap());
    }

    @Override
    public <VV> MutableMap<VV, V> groupByUniqueKey(Function<? super V, ? extends VV> function) {
        return this.groupByUniqueKey(function, UnifiedMap.newMap());
    }

    public void reverseForEach(Procedure<? super V> procedure) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".reverseForEach() not implemented yet");
    }

    public void reverseForEachWithIndex(ObjectIntProcedure<? super V> procedure) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".reverseForEachWithIndex() not implemented yet");
    }

    public LazyIterable<V> asReversed() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".asReversed() not implemented yet");
    }

    public int detectLastIndex(Predicate<? super V> predicate) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".detectLastIndex() not implemented yet");
    }

    public int indexOf(Object object) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".indexOf() not implemented yet");
    }

    public <S> boolean corresponds(OrderedIterable<S> other, Predicate2<? super V, ? super S> predicate) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".corresponds() not implemented yet");
    }

    public void forEach(int startIndex, int endIndex, Procedure<? super V> procedure) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".forEach() not implemented yet");
    }

    public void forEachWithIndex(int fromIndex, int toIndex, ObjectIntProcedure<? super V> objectIntProcedure) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".forEachWithIndex() not implemented yet");
    }

    public MutableStack<V> toStack() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".toStack() not implemented yet");
    }

    public int detectIndex(Predicate<? super V> predicate) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".detectIndex() not implemented yet");
    }
}

