/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable.primitive;

import java.io.Serializable;
import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.LazyCharIterable;
import org.eclipse.collections.api.LazyLongIterable;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.primitive.MutableLongBag;
import org.eclipse.collections.api.block.function.primitive.CharToLongFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction0;
import org.eclipse.collections.api.block.function.primitive.LongToLongFunction;
import org.eclipse.collections.api.block.function.primitive.LongToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectLongToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.CharLongPredicate;
import org.eclipse.collections.api.block.predicate.primitive.LongPredicate;
import org.eclipse.collections.api.block.procedure.primitive.CharLongProcedure;
import org.eclipse.collections.api.block.procedure.primitive.CharProcedure;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.iterator.MutableLongIterator;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.map.primitive.CharLongMap;
import org.eclipse.collections.api.map.primitive.ImmutableCharLongMap;
import org.eclipse.collections.api.map.primitive.MutableCharLongMap;
import org.eclipse.collections.api.map.primitive.MutableLongCharMap;
import org.eclipse.collections.api.set.primitive.MutableCharSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.api.tuple.primitive.CharLongPair;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableLongCollection;
import org.eclipse.collections.impl.factory.primitive.CharLongMaps;
import org.eclipse.collections.impl.iterator.UnmodifiableLongIterator;
import org.eclipse.collections.impl.map.mutable.primitive.SynchronizedCharLongMap;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableCharSet;

public final class UnmodifiableCharLongMap
implements MutableCharLongMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableCharLongMap map;

    public UnmodifiableCharLongMap(MutableCharLongMap map) {
        if (map == null) {
            throw new IllegalArgumentException("Cannot create a UnmodifiableCharLongMap on a null map");
        }
        this.map = map;
    }

    public void clear() {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    public void put(char key, long value) {
        throw new UnsupportedOperationException("Cannot call put() on " + this.getClass().getSimpleName());
    }

    public void putAll(CharLongMap map) {
        throw new UnsupportedOperationException("Cannot call putAll() on " + this.getClass().getSimpleName());
    }

    public void removeKey(char key) {
        throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
    }

    public void remove(char key) {
        throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
    }

    public long removeKeyIfAbsent(char key, long value) {
        if (this.map.containsKey(key)) {
            throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
        }
        return value;
    }

    public long getIfAbsentPut(char key, long value) {
        return this.map.getIfAbsentPut(key, (LongFunction0 & Serializable)() -> {
            throw new UnsupportedOperationException();
        });
    }

    public long getIfAbsentPut(char key, LongFunction0 function) {
        return this.map.getIfAbsentPut(key, (LongFunction0 & Serializable)() -> {
            throw new UnsupportedOperationException();
        });
    }

    public long getIfAbsentPutWithKey(char key, CharToLongFunction function) {
        return this.map.getIfAbsentPut(key, (LongFunction0 & Serializable)() -> {
            throw new UnsupportedOperationException();
        });
    }

    public <P> long getIfAbsentPutWith(char key, LongFunction<? super P> function, P parameter) {
        return this.map.getIfAbsentPut(key, (LongFunction0 & Serializable)() -> {
            throw new UnsupportedOperationException();
        });
    }

    public long updateValue(char key, long initialValueIfAbsent, LongToLongFunction function) {
        throw new UnsupportedOperationException("Cannot call updateValue() on " + this.getClass().getSimpleName());
    }

    public long get(char key) {
        return this.map.get(key);
    }

    public long getIfAbsent(char key, long ifAbsent) {
        return this.map.getIfAbsent(key, ifAbsent);
    }

    public long getOrThrow(char key) {
        return this.map.getOrThrow(key);
    }

    public boolean containsKey(char key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(long value) {
        return this.map.containsValue(value);
    }

    public void forEachValue(LongProcedure procedure) {
        this.map.forEachValue(procedure);
    }

    public void forEachKey(CharProcedure procedure) {
        this.map.forEachKey(procedure);
    }

    public void forEachKeyValue(CharLongProcedure procedure) {
        this.map.forEachKeyValue(procedure);
    }

    public LazyCharIterable keysView() {
        return this.map.keysView();
    }

    public RichIterable<CharLongPair> keyValuesView() {
        return this.map.keyValuesView();
    }

    public MutableLongCharMap flipUniqueValues() {
        return this.map.flipUniqueValues().asUnmodifiable();
    }

    public MutableCharLongMap select(CharLongPredicate predicate) {
        return this.map.select(predicate);
    }

    public MutableCharLongMap reject(CharLongPredicate predicate) {
        return this.map.reject(predicate);
    }

    public MutableLongIterator longIterator() {
        return new UnmodifiableLongIterator((LongIterator)this.map.longIterator());
    }

    public void forEach(LongProcedure procedure) {
        this.each(procedure);
    }

    public void each(LongProcedure procedure) {
        this.map.forEach(procedure);
    }

    public int count(LongPredicate predicate) {
        return this.map.count(predicate);
    }

    public boolean anySatisfy(LongPredicate predicate) {
        return this.map.anySatisfy(predicate);
    }

    public boolean allSatisfy(LongPredicate predicate) {
        return this.map.allSatisfy(predicate);
    }

    public boolean noneSatisfy(LongPredicate predicate) {
        return this.map.noneSatisfy(predicate);
    }

    public MutableLongBag select(LongPredicate predicate) {
        return this.map.select(predicate);
    }

    public MutableLongBag reject(LongPredicate predicate) {
        return this.map.reject(predicate);
    }

    public <V> MutableBag<V> collect(LongToObjectFunction<? extends V> function) {
        return this.map.collect(function);
    }

    public long detectIfNone(LongPredicate predicate, long ifNone) {
        return this.map.detectIfNone(predicate, ifNone);
    }

    public long sum() {
        return this.map.sum();
    }

    public long max() {
        return this.map.max();
    }

    public long maxIfEmpty(long defaultValue) {
        return this.map.maxIfEmpty(defaultValue);
    }

    public long min() {
        return this.map.min();
    }

    public long minIfEmpty(long defaultValue) {
        return this.map.minIfEmpty(defaultValue);
    }

    public double average() {
        return this.map.average();
    }

    public double median() {
        return this.map.median();
    }

    public long addToValue(char key, long toBeAdded) {
        throw new UnsupportedOperationException("Cannot call addToValue() on " + this.getClass().getSimpleName());
    }

    public long[] toSortedArray() {
        return this.map.toSortedArray();
    }

    public MutableLongList toSortedList() {
        return this.map.toSortedList();
    }

    public long[] toArray() {
        return this.map.toArray();
    }

    public boolean contains(long value) {
        return this.map.contains(value);
    }

    public boolean containsAll(long ... source) {
        return this.map.containsAll(source);
    }

    public boolean containsAll(LongIterable source) {
        return this.map.containsAll(source);
    }

    public MutableLongList toList() {
        return this.map.toList();
    }

    public MutableLongSet toSet() {
        return this.map.toSet();
    }

    public MutableLongBag toBag() {
        return this.map.toBag();
    }

    public LazyLongIterable asLazy() {
        return this.map.asLazy();
    }

    public MutableCharLongMap withKeyValue(char key, long value) {
        throw new UnsupportedOperationException("Cannot call withKeyValue() on " + this.getClass().getSimpleName());
    }

    public MutableCharLongMap withoutKey(char key) {
        throw new UnsupportedOperationException("Cannot call withoutKey() on " + this.getClass().getSimpleName());
    }

    public MutableCharLongMap withoutAllKeys(CharIterable keys) {
        throw new UnsupportedOperationException("Cannot call withoutAllKeys() on " + this.getClass().getSimpleName());
    }

    public MutableCharLongMap asUnmodifiable() {
        return this;
    }

    public MutableCharLongMap asSynchronized() {
        return new SynchronizedCharLongMap(this);
    }

    public ImmutableCharLongMap toImmutable() {
        return CharLongMaps.immutable.withAll((CharLongMap)this);
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean notEmpty() {
        return this.map.notEmpty();
    }

    public MutableCharSet keySet() {
        return UnmodifiableCharSet.of(this.map.keySet());
    }

    public MutableLongCollection values() {
        return UnmodifiableLongCollection.of(this.map.values());
    }

    public boolean equals(Object otherMap) {
        return this.map.equals(otherMap);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return this.map.toString();
    }

    public String makeString() {
        return this.map.makeString();
    }

    public String makeString(String separator) {
        return this.map.makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.map.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.map.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.map.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.map.appendString(appendable, start, separator, end);
    }

    public <T> T injectInto(T injectedValue, ObjectLongToObjectFunction<? super T, ? extends T> function) {
        return (T)this.map.injectInto(injectedValue, function);
    }
}

