/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.immutable.primitive;

import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.factory.set.primitive.ImmutableByteSetFactory;
import org.eclipse.collections.api.set.primitive.ImmutableByteSet;
import org.eclipse.collections.impl.set.immutable.primitive.ImmutableByteEmptySet;
import org.eclipse.collections.impl.set.immutable.primitive.ImmutableByteSingletonSet;
import org.eclipse.collections.impl.set.mutable.primitive.ByteHashSet;

public enum ImmutableByteSetFactoryImpl implements ImmutableByteSetFactory
{
    INSTANCE;


    public ImmutableByteSet empty() {
        return ImmutableByteEmptySet.INSTANCE;
    }

    public ImmutableByteSet of() {
        return this.empty();
    }

    public ImmutableByteSet with() {
        return this.empty();
    }

    public ImmutableByteSet of(byte one) {
        return this.with(one);
    }

    public ImmutableByteSet with(byte one) {
        return new ImmutableByteSingletonSet(one);
    }

    public ImmutableByteSet of(byte ... items) {
        return this.with(items);
    }

    public ImmutableByteSet with(byte ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return ByteHashSet.newSetWith(items).toImmutable();
    }

    public ImmutableByteSet ofAll(ByteIterable items) {
        return this.withAll(items);
    }

    public ImmutableByteSet withAll(ByteIterable items) {
        if (items instanceof ImmutableByteSet) {
            return (ImmutableByteSet)items;
        }
        return this.with(items.toArray());
    }
}

