/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.block.function.primitive.FloatToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectFloatToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.FloatPredicate;
import org.eclipse.collections.api.block.procedure.primitive.FloatProcedure;
import org.eclipse.collections.api.iterator.FloatIterator;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.api.set.primitive.ImmutableFloatSet;
import org.eclipse.collections.impl.SpreadFunctions;
import org.eclipse.collections.impl.set.immutable.primitive.AbstractImmutableFloatSet;
import org.eclipse.collections.impl.set.immutable.primitive.ImmutableFloatSetSerializationProxy;
import org.eclipse.collections.impl.set.mutable.UnifiedSet;
import org.eclipse.collections.impl.set.mutable.primitive.FloatHashSet;

class ImmutableFloatFloatMapKeySet
extends AbstractImmutableFloatSet
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final float EMPTY_KEY = 0.0f;
    private static final float REMOVED_KEY = 1.0f;
    private static final int CACHE_LINE_SIZE = 64;
    private static final int KEY_SIZE = 4;
    private static final int INITIAL_LINEAR_PROBE = 8;
    private final float[] keysValues;
    private final int occupiedWithData;
    private final boolean containsZeroKey;
    private final boolean containsOneKey;

    ImmutableFloatFloatMapKeySet(float[] keysValues, int occupiedWithData, boolean containsZeroKey, boolean containsOneKey) {
        this.keysValues = keysValues;
        this.occupiedWithData = occupiedWithData;
        this.containsZeroKey = containsZeroKey;
        this.containsOneKey = containsOneKey;
    }

    private static boolean isEmptyKey(float key) {
        return Float.compare(key, 0.0f) == 0;
    }

    private static boolean isRemovedKey(float key) {
        return Float.compare(key, 1.0f) == 0;
    }

    private static boolean isNonSentinel(float key) {
        return !ImmutableFloatFloatMapKeySet.isEmptyKey(key) && !ImmutableFloatFloatMapKeySet.isRemovedKey(key);
    }

    @Override
    public int hashCode() {
        int result = 0;
        if (this.containsZeroKey) {
            result += Float.floatToIntBits(0.0f);
        }
        if (this.containsOneKey) {
            result += Float.floatToIntBits(1.0f);
        }
        if (this.keysValues != null) {
            for (int i = 0; i < this.keysValues.length; i += 2) {
                if (!ImmutableFloatFloatMapKeySet.isNonSentinel(this.keysValues[i])) continue;
                result += Float.floatToIntBits(this.keysValues[i]);
            }
        }
        return result;
    }

    public int size() {
        return this.occupiedWithData + (this.containsOneKey ? 1 : 0) + (this.containsZeroKey ? 1 : 0);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            int count = 0;
            if (this.containsZeroKey) {
                appendable.append(String.valueOf(0.0f));
                ++count;
            }
            if (this.containsOneKey) {
                if (count > 0) {
                    appendable.append(separator);
                }
                ++count;
                appendable.append(String.valueOf(1.0f));
            }
            for (int i = 0; i < this.keysValues.length; i += 2) {
                if (!ImmutableFloatFloatMapKeySet.isNonSentinel(this.keysValues[i])) continue;
                if (count > 0) {
                    appendable.append(separator);
                }
                ++count;
                appendable.append(String.valueOf(this.keysValues[i]));
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public FloatIterator floatIterator() {
        return new InternalFloatIterator();
    }

    public float[] toArray() {
        float[] array = new float[this.size()];
        int index = 0;
        if (this.containsZeroKey) {
            array[index] = 0.0f;
            ++index;
        }
        if (this.containsOneKey) {
            array[index] = 1.0f;
            ++index;
        }
        if (this.keysValues != null) {
            for (int i = 0; i < this.keysValues.length; i += 2) {
                if (!ImmutableFloatFloatMapKeySet.isNonSentinel(this.keysValues[i])) continue;
                array[index] = this.keysValues[i];
                ++index;
            }
        }
        return array;
    }

    public boolean contains(float value) {
        if (Float.compare(value, 0.0f) == 0) {
            return this.containsZeroKey;
        }
        if (Float.compare(value, 1.0f) == 0) {
            return this.containsOneKey;
        }
        return Float.compare(this.keysValues[this.probe(value)], value) == 0;
    }

    public void forEach(FloatProcedure procedure) {
        this.each(procedure);
    }

    public void each(FloatProcedure procedure) {
        if (this.containsZeroKey) {
            procedure.value(0.0f);
        }
        if (this.containsOneKey) {
            procedure.value(1.0f);
        }
        if (this.keysValues != null) {
            for (int i = 0; i < this.keysValues.length; i += 2) {
                if (!ImmutableFloatFloatMapKeySet.isNonSentinel(this.keysValues[i])) continue;
                procedure.value(this.keysValues[i]);
            }
        }
    }

    public ImmutableFloatSet select(FloatPredicate predicate) {
        FloatHashSet result = new FloatHashSet();
        if (this.containsZeroKey && predicate.accept(0.0f)) {
            result.add(0.0f);
        }
        if (this.containsOneKey && predicate.accept(1.0f)) {
            result.add(1.0f);
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!ImmutableFloatFloatMapKeySet.isNonSentinel(this.keysValues[i]) || !predicate.accept(this.keysValues[i])) continue;
            result.add(this.keysValues[i]);
        }
        return result.toImmutable();
    }

    public ImmutableFloatSet reject(FloatPredicate predicate) {
        FloatHashSet result = new FloatHashSet();
        if (this.containsZeroKey && !predicate.accept(0.0f)) {
            result.add(0.0f);
        }
        if (this.containsOneKey && !predicate.accept(1.0f)) {
            result.add(1.0f);
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!ImmutableFloatFloatMapKeySet.isNonSentinel(this.keysValues[i]) || predicate.accept(this.keysValues[i])) continue;
            result.add(this.keysValues[i]);
        }
        return result.toImmutable();
    }

    public <V> ImmutableSet<V> collect(FloatToObjectFunction<? extends V> function) {
        UnifiedSet target = UnifiedSet.newSet(this.size());
        if (this.containsZeroKey) {
            target.add(function.valueOf(0.0f));
        }
        if (this.containsOneKey) {
            target.add(function.valueOf(1.0f));
        }
        if (this.keysValues != null) {
            for (int i = 0; i < this.keysValues.length; i += 2) {
                if (!ImmutableFloatFloatMapKeySet.isNonSentinel(this.keysValues[i])) continue;
                target.add(function.valueOf(this.keysValues[i]));
            }
        }
        return target.toImmutable();
    }

    public float detectIfNone(FloatPredicate predicate, float ifNone) {
        if (this.containsZeroKey && predicate.accept(0.0f)) {
            return 0.0f;
        }
        if (this.containsOneKey && predicate.accept(1.0f)) {
            return 1.0f;
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!ImmutableFloatFloatMapKeySet.isNonSentinel(this.keysValues[i]) || !predicate.accept(this.keysValues[i])) continue;
            return this.keysValues[i];
        }
        return ifNone;
    }

    public int count(FloatPredicate predicate) {
        int count = 0;
        if (this.containsZeroKey && predicate.accept(0.0f)) {
            ++count;
        }
        if (this.containsOneKey && predicate.accept(1.0f)) {
            ++count;
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!ImmutableFloatFloatMapKeySet.isNonSentinel(this.keysValues[i]) || !predicate.accept(this.keysValues[i])) continue;
            ++count;
        }
        return count;
    }

    public boolean anySatisfy(FloatPredicate predicate) {
        if (this.containsZeroKey && predicate.accept(0.0f)) {
            return true;
        }
        if (this.containsOneKey && predicate.accept(1.0f)) {
            return true;
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!ImmutableFloatFloatMapKeySet.isNonSentinel(this.keysValues[i]) || !predicate.accept(this.keysValues[i])) continue;
            return true;
        }
        return false;
    }

    public boolean allSatisfy(FloatPredicate predicate) {
        if (this.containsZeroKey && !predicate.accept(0.0f)) {
            return false;
        }
        if (this.containsOneKey && !predicate.accept(1.0f)) {
            return false;
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!ImmutableFloatFloatMapKeySet.isNonSentinel(this.keysValues[i]) || predicate.accept(this.keysValues[i])) continue;
            return false;
        }
        return true;
    }

    public boolean noneSatisfy(FloatPredicate predicate) {
        if (this.containsZeroKey && predicate.accept(0.0f)) {
            return false;
        }
        if (this.containsOneKey && predicate.accept(1.0f)) {
            return false;
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!ImmutableFloatFloatMapKeySet.isNonSentinel(this.keysValues[i]) || !predicate.accept(this.keysValues[i])) continue;
            return false;
        }
        return true;
    }

    public double sum() {
        double nextSum;
        double adjustedValue;
        double result = 0.0;
        double compensation = 0.0;
        if (this.containsZeroKey) {
            adjustedValue = 0.0 - compensation;
            nextSum = result + adjustedValue;
            compensation = nextSum - result - adjustedValue;
            result = nextSum;
        }
        if (this.containsOneKey) {
            adjustedValue = 1.0 - compensation;
            nextSum = result + adjustedValue;
            compensation = nextSum - result - adjustedValue;
            result = nextSum;
        }
        if (this.keysValues != null) {
            for (int i = 0; i < this.keysValues.length; i += 2) {
                if (!ImmutableFloatFloatMapKeySet.isNonSentinel(this.keysValues[i])) continue;
                double adjustedValue2 = (double)this.keysValues[i] - compensation;
                double nextSum2 = result + adjustedValue2;
                compensation = nextSum2 - result - adjustedValue2;
                result = nextSum2;
            }
        }
        return result;
    }

    public float max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        float max = 0.0f;
        boolean isMaxSet = false;
        if (this.containsZeroKey) {
            max = 0.0f;
            isMaxSet = true;
        }
        if (this.containsOneKey && (!isMaxSet || Float.compare(max, 1.0f) < 0)) {
            max = 1.0f;
            isMaxSet = true;
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!ImmutableFloatFloatMapKeySet.isNonSentinel(this.keysValues[i]) || isMaxSet && Float.compare(max, this.keysValues[i]) >= 0) continue;
            max = this.keysValues[i];
            isMaxSet = true;
        }
        return max;
    }

    public float min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        float min = 0.0f;
        boolean isMinSet = false;
        if (this.containsZeroKey) {
            min = 0.0f;
            isMinSet = true;
        }
        if (this.containsOneKey && (!isMinSet || 1.0f < min)) {
            min = 1.0f;
            isMinSet = true;
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!ImmutableFloatFloatMapKeySet.isNonSentinel(this.keysValues[i]) || isMinSet && Float.compare(this.keysValues[i], min) >= 0) continue;
            min = this.keysValues[i];
            isMinSet = true;
        }
        return min;
    }

    public <T> T injectInto(T injectedValue, ObjectFloatToObjectFunction<? super T, ? extends T> function) {
        Object result = injectedValue;
        if (this.containsZeroKey) {
            result = function.valueOf(result, 0.0f);
        }
        if (this.containsOneKey) {
            result = function.valueOf(result, 1.0f);
        }
        if (this.keysValues != null) {
            for (int i = 0; i < this.keysValues.length; i += 2) {
                if (!ImmutableFloatFloatMapKeySet.isNonSentinel(this.keysValues[i])) continue;
                result = function.valueOf(result, this.keysValues[i]);
            }
        }
        return result;
    }

    private Object writeReplace() {
        return new ImmutableFloatSetSerializationProxy(this);
    }

    int probe(float element) {
        int index = this.mask((int)element) << 1;
        float keyAtIndex = this.keysValues[index];
        if (Float.compare(keyAtIndex, element) == 0 || Float.compare(keyAtIndex, 0.0f) == 0) {
            return index;
        }
        int removedIndex = Float.compare(keyAtIndex, 1.0f) == 0 ? index : -1;
        for (int i = 2; i < 8; i += 2) {
            int nextIndex = index + i & this.keysValues.length - 1;
            keyAtIndex = this.keysValues[nextIndex];
            if (Float.compare(keyAtIndex, element) == 0) {
                return nextIndex;
            }
            if (Float.compare(keyAtIndex, 0.0f) == 0) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (Float.compare(keyAtIndex, 1.0f) != 0 || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return this.probeTwo(element, removedIndex);
    }

    int probeTwo(float element, int removedIndex) {
        int index = this.spreadTwoAndMask(element) << 1;
        for (int i = 0; i < 8; i += 2) {
            int nextIndex = index + i & this.keysValues.length - 1;
            float keyAtIndex = this.keysValues[nextIndex];
            if (Float.compare(keyAtIndex, element) == 0) {
                return nextIndex;
            }
            if (Float.compare(keyAtIndex, 0.0f) == 0) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (Float.compare(keyAtIndex, 1.0f) != 0 || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return this.probeThree(element, removedIndex);
    }

    int probeThree(float element, int removedIndex) {
        int nextIndex = SpreadFunctions.floatSpreadOne(element) << 1;
        int spreadTwo = Integer.reverse(SpreadFunctions.floatSpreadTwo(element)) | 1;
        float keyAtIndex;
        while (Float.compare(keyAtIndex = this.keysValues[nextIndex = this.mask((nextIndex >> 1) + spreadTwo) << 1], element) != 0) {
            if (Float.compare(keyAtIndex, 0.0f) == 0) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (Float.compare(keyAtIndex, 1.0f) != 0 || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return nextIndex;
    }

    int spreadAndMask(float element) {
        int code = SpreadFunctions.floatSpreadOne(element);
        return this.mask(code);
    }

    int spreadTwoAndMask(float element) {
        int code = SpreadFunctions.floatSpreadTwo(element);
        return this.mask(code);
    }

    private int mask(int spread) {
        return spread & (this.keysValues.length >> 1) - 1;
    }

    private class InternalFloatIterator
    implements FloatIterator {
        private int count;
        private int position;
        private boolean handledZero;
        private boolean handledOne;

        private InternalFloatIterator() {
        }

        public boolean hasNext() {
            return this.count < ImmutableFloatFloatMapKeySet.this.size();
        }

        public float next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            if (!this.handledZero) {
                this.handledZero = true;
                if (ImmutableFloatFloatMapKeySet.this.containsZeroKey) {
                    return 0.0f;
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (ImmutableFloatFloatMapKeySet.this.containsOneKey) {
                    return 1.0f;
                }
            }
            float[] keysValues = ImmutableFloatFloatMapKeySet.this.keysValues;
            while (!ImmutableFloatFloatMapKeySet.isNonSentinel(keysValues[this.position])) {
                this.position += 2;
            }
            float result = ImmutableFloatFloatMapKeySet.this.keysValues[this.position];
            this.position += 2;
            return result;
        }
    }
}

