/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.LazyByteIterable;
import org.eclipse.collections.api.LazyFloatIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.primitive.ImmutableByteBag;
import org.eclipse.collections.api.bag.primitive.MutableByteBag;
import org.eclipse.collections.api.block.function.primitive.ByteToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BytePredicate;
import org.eclipse.collections.api.block.predicate.primitive.FloatBytePredicate;
import org.eclipse.collections.api.block.procedure.primitive.ByteProcedure;
import org.eclipse.collections.api.block.procedure.primitive.FloatByteProcedure;
import org.eclipse.collections.api.block.procedure.primitive.FloatProcedure;
import org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import org.eclipse.collections.api.iterator.ByteIterator;
import org.eclipse.collections.api.list.primitive.MutableByteList;
import org.eclipse.collections.api.map.primitive.FloatByteMap;
import org.eclipse.collections.api.map.primitive.ImmutableFloatByteMap;
import org.eclipse.collections.api.set.primitive.MutableByteSet;
import org.eclipse.collections.api.set.primitive.MutableFloatSet;
import org.eclipse.collections.api.tuple.primitive.FloatBytePair;
import org.eclipse.collections.impl.bag.mutable.primitive.ByteHashBag;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableByteCollection;
import org.eclipse.collections.impl.factory.Bags;
import org.eclipse.collections.impl.factory.primitive.ByteBags;
import org.eclipse.collections.impl.iterator.ImmutableEmptyByteIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyByteIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.ByteArrayList;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableFloatByteSingletonMap;
import org.eclipse.collections.impl.set.mutable.primitive.ByteHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.FloatHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableFloatSet;
import org.eclipse.collections.impl.utility.LazyIterate;
import org.eclipse.collections.impl.utility.primitive.LazyFloatIterate;

final class ImmutableFloatByteEmptyMap
implements ImmutableFloatByteMap,
Serializable {
    static final ImmutableFloatByteMap INSTANCE = new ImmutableFloatByteEmptyMap();
    private static final long serialVersionUID = 1L;
    private static final byte EMPTY_VALUE = 0;

    ImmutableFloatByteEmptyMap() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    public byte get(float key) {
        return 0;
    }

    public byte getIfAbsent(float key, byte ifAbsent) {
        return ifAbsent;
    }

    public byte getOrThrow(float key) {
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(float key) {
        return false;
    }

    public boolean containsValue(byte value) {
        return false;
    }

    public void forEachValue(ByteProcedure procedure) {
    }

    public void forEachKey(FloatProcedure procedure) {
    }

    public void forEachKeyValue(FloatByteProcedure procedure) {
    }

    public LazyFloatIterable keysView() {
        return LazyFloatIterate.empty();
    }

    public RichIterable<FloatBytePair> keyValuesView() {
        return LazyIterate.empty();
    }

    public ImmutableFloatByteMap select(FloatBytePredicate predicate) {
        return this;
    }

    public ImmutableFloatByteMap reject(FloatBytePredicate predicate) {
        return this;
    }

    public ImmutableFloatByteMap toImmutable() {
        return this;
    }

    public ByteIterator byteIterator() {
        return ImmutableEmptyByteIterator.INSTANCE;
    }

    public void forEach(ByteProcedure procedure) {
    }

    public void each(ByteProcedure procedure) {
    }

    public int count(BytePredicate predicate) {
        return 0;
    }

    public long sum() {
        return 0L;
    }

    public byte min() {
        throw new NoSuchElementException();
    }

    public byte max() {
        throw new NoSuchElementException();
    }

    public byte maxIfEmpty(byte defaultValue) {
        return defaultValue;
    }

    public byte minIfEmpty(byte defaultValue) {
        return defaultValue;
    }

    public double average() {
        throw new ArithmeticException();
    }

    public double median() {
        throw new ArithmeticException();
    }

    public byte[] toSortedArray() {
        return new byte[0];
    }

    public MutableByteList toSortedList() {
        return new ByteArrayList();
    }

    public boolean anySatisfy(BytePredicate predicate) {
        return false;
    }

    public boolean allSatisfy(BytePredicate predicate) {
        return true;
    }

    public boolean noneSatisfy(BytePredicate predicate) {
        return true;
    }

    public ImmutableByteBag select(BytePredicate predicate) {
        return ByteBags.immutable.empty();
    }

    public ImmutableByteBag reject(BytePredicate predicate) {
        return ByteBags.immutable.empty();
    }

    public <V> ImmutableBag<V> collect(ByteToObjectFunction<? extends V> function) {
        return Bags.immutable.empty();
    }

    public byte detectIfNone(BytePredicate predicate, byte ifNone) {
        return ifNone;
    }

    public <T> T injectInto(T injectedValue, ObjectByteToObjectFunction<? super T, ? extends T> function) {
        return injectedValue;
    }

    public byte[] toArray() {
        return new byte[0];
    }

    public boolean contains(byte value) {
        return false;
    }

    public boolean containsAll(byte ... source) {
        return source.length == 0;
    }

    public boolean containsAll(ByteIterable source) {
        return source.isEmpty();
    }

    public MutableByteList toList() {
        return new ByteArrayList();
    }

    public MutableByteSet toSet() {
        return new ByteHashSet();
    }

    public MutableByteBag toBag() {
        return new ByteHashBag();
    }

    public LazyByteIterable asLazy() {
        return new LazyByteIterableAdapter((ByteIterable)this);
    }

    public ImmutableFloatByteMap newWithKeyValue(float key, byte value) {
        return new ImmutableFloatByteSingletonMap(key, value);
    }

    public ImmutableFloatByteMap newWithoutKey(float key) {
        return this;
    }

    public ImmutableFloatByteMap newWithoutAllKeys(FloatIterable keys) {
        return this;
    }

    public int size() {
        return 0;
    }

    public boolean isEmpty() {
        return true;
    }

    public boolean notEmpty() {
        return false;
    }

    public MutableFloatSet keySet() {
        return UnmodifiableFloatSet.of(new FloatHashSet());
    }

    public MutableByteCollection values() {
        return UnmodifiableByteCollection.of((MutableByteCollection)new ByteArrayList());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FloatByteMap)) {
            return false;
        }
        FloatByteMap map = (FloatByteMap)obj;
        return map.isEmpty();
    }

    public int hashCode() {
        return 0;
    }

    public String toString() {
        return "{}";
    }

    public String makeString() {
        return "";
    }

    public String makeString(String separator) {
        return "";
    }

    public String makeString(String start, String separator, String end) {
        return start + end;
    }

    public void appendString(Appendable appendable) {
    }

    public void appendString(Appendable appendable, String separator) {
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

