/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import org.eclipse.collections.api.factory.map.primitive.ImmutableByteCharMapFactory;
import org.eclipse.collections.api.map.primitive.ByteCharMap;
import org.eclipse.collections.api.map.primitive.ImmutableByteCharMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableByteCharEmptyMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableByteCharHashMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableByteCharSingletonMap;

public enum ImmutableByteCharMapFactoryImpl implements ImmutableByteCharMapFactory
{
    INSTANCE;


    public ImmutableByteCharMap empty() {
        return ImmutableByteCharEmptyMap.INSTANCE;
    }

    public ImmutableByteCharMap of() {
        return this.empty();
    }

    public ImmutableByteCharMap with() {
        return this.empty();
    }

    public ImmutableByteCharMap of(byte key, char value) {
        return this.with(key, value);
    }

    public ImmutableByteCharMap with(byte key, char value) {
        return new ImmutableByteCharSingletonMap(key, value);
    }

    public ImmutableByteCharMap ofAll(ByteCharMap map) {
        return this.withAll(map);
    }

    public ImmutableByteCharMap withAll(ByteCharMap map) {
        if (map instanceof ImmutableByteCharMap) {
            return (ImmutableByteCharMap)map;
        }
        if (map.isEmpty()) {
            return this.with();
        }
        if (map.size() == 1) {
            byte key = map.keysView().byteIterator().next();
            return new ImmutableByteCharSingletonMap(key, map.get(key));
        }
        return new ImmutableByteCharHashMap(map);
    }
}

