/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.list.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.LazyDoubleIterable;
import org.eclipse.collections.api.bag.primitive.MutableDoubleBag;
import org.eclipse.collections.api.block.function.primitive.DoubleToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectDoubleIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectDoubleToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.DoublePredicate;
import org.eclipse.collections.api.block.procedure.primitive.DoubleIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.DoubleProcedure;
import org.eclipse.collections.api.collection.primitive.MutableDoubleCollection;
import org.eclipse.collections.api.iterator.DoubleIterator;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.primitive.DoubleList;
import org.eclipse.collections.api.list.primitive.ImmutableDoubleList;
import org.eclipse.collections.api.list.primitive.MutableDoubleList;
import org.eclipse.collections.api.set.primitive.MutableDoubleSet;
import org.eclipse.collections.impl.bag.mutable.primitive.DoubleHashBag;
import org.eclipse.collections.impl.factory.primitive.DoubleLists;
import org.eclipse.collections.impl.lazy.primitive.LazyDoubleIterableAdapter;
import org.eclipse.collections.impl.lazy.primitive.ReverseDoubleIterable;
import org.eclipse.collections.impl.list.mutable.FastList;
import org.eclipse.collections.impl.list.mutable.primitive.DoubleArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.DoubleHashSet;

final class ImmutableDoubleArrayList
implements ImmutableDoubleList,
Serializable {
    private static final long serialVersionUID = 1L;
    private final double[] items;

    private ImmutableDoubleArrayList(double[] newElements) {
        if (newElements.length <= 1) {
            throw new IllegalArgumentException("Use DoubleLists.immutable.with() to instantiate an optimized collection");
        }
        this.items = newElements;
    }

    public static ImmutableDoubleArrayList newList(DoubleIterable iterable) {
        return new ImmutableDoubleArrayList(iterable.toArray());
    }

    public static ImmutableDoubleArrayList newListWith(double ... elements) {
        double[] newArray = new double[elements.length];
        System.arraycopy(elements, 0, newArray, 0, elements.length);
        return new ImmutableDoubleArrayList(newArray);
    }

    public double get(int index) {
        return this.items[index];
    }

    public double getFirst() {
        return this.items[0];
    }

    public double getLast() {
        return this.items[this.items.length - 1];
    }

    public int indexOf(double value) {
        for (int i = 0; i < this.items.length; ++i) {
            if (Double.compare(this.items[i], value) != 0) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(double value) {
        for (int i = this.items.length - 1; i >= 0; --i) {
            if (Double.compare(this.items[i], value) != 0) continue;
            return i;
        }
        return -1;
    }

    public DoubleIterator doubleIterator() {
        return new InternalDoubleIterator();
    }

    public void forEach(DoubleProcedure procedure) {
        this.each(procedure);
    }

    public void each(DoubleProcedure procedure) {
        for (double item : this.items) {
            procedure.value(item);
        }
    }

    public void forEachWithIndex(DoubleIntProcedure procedure) {
        for (int i = 0; i < this.items.length; ++i) {
            procedure.value(this.items[i], i);
        }
    }

    public int count(DoublePredicate predicate) {
        int count = 0;
        for (double item : this.items) {
            if (!predicate.accept(item)) continue;
            ++count;
        }
        return count;
    }

    public boolean anySatisfy(DoublePredicate predicate) {
        for (double item : this.items) {
            if (!predicate.accept(item)) continue;
            return true;
        }
        return false;
    }

    public boolean allSatisfy(DoublePredicate predicate) {
        for (double item : this.items) {
            if (predicate.accept(item)) continue;
            return false;
        }
        return true;
    }

    public boolean noneSatisfy(DoublePredicate predicate) {
        return !this.anySatisfy(predicate);
    }

    public ImmutableDoubleList select(DoublePredicate predicate) {
        return this.select(predicate, new DoubleArrayList()).toImmutable();
    }

    public <R extends MutableDoubleCollection> R select(DoublePredicate predicate, R target) {
        for (double item : this.items) {
            if (!predicate.accept(item)) continue;
            target.add(item);
        }
        return target;
    }

    public ImmutableDoubleList reject(DoublePredicate predicate) {
        return this.reject(predicate, new DoubleArrayList()).toImmutable();
    }

    public <R extends MutableDoubleCollection> R reject(DoublePredicate predicate, R target) {
        for (double item : this.items) {
            if (predicate.accept(item)) continue;
            target.add(item);
        }
        return target;
    }

    public double detectIfNone(DoublePredicate predicate, double ifNone) {
        for (double item : this.items) {
            if (!predicate.accept(item)) continue;
            return item;
        }
        return ifNone;
    }

    public <V> ImmutableList<V> collect(DoubleToObjectFunction<? extends V> function) {
        FastList list = this.collect(function, (Collection)((Object)FastList.newList(this.items.length)));
        return list.toImmutable();
    }

    public <V, R extends Collection<V>> R collect(DoubleToObjectFunction<? extends V> function, R target) {
        for (double item : this.items) {
            target.add((Object)function.valueOf(item));
        }
        return target;
    }

    public double sum() {
        double result = 0.0;
        double compensation = 0.0;
        for (double item : this.items) {
            double adjustedValue = item - compensation;
            double nextSum = result + adjustedValue;
            compensation = nextSum - result - adjustedValue;
            result = nextSum;
        }
        return result;
    }

    public double max() {
        double max = this.items[0];
        for (int i = 1; i < this.items.length; ++i) {
            double value = this.items[i];
            if (Double.compare(max, value) >= 0) continue;
            max = value;
        }
        return max;
    }

    public double maxIfEmpty(double defaultValue) {
        return this.max();
    }

    public double min() {
        double min = this.items[0];
        for (int i = 1; i < this.items.length; ++i) {
            double value = this.items[i];
            if (Double.compare(value, min) >= 0) continue;
            min = value;
        }
        return min;
    }

    public double minIfEmpty(double defaultValue) {
        return this.min();
    }

    public double average() {
        return this.sum() / (double)this.size();
    }

    public double median() {
        double[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            double first = sortedArray[middleIndex];
            double second = sortedArray[middleIndex - 1];
            return (first + second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    public double[] toSortedArray() {
        double[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    public double dotProduct(DoubleList list) {
        if (this.size() != list.size()) {
            throw new IllegalArgumentException("Lists used in dotProduct must be the same size");
        }
        double sum = 0.0;
        for (int i = 0; i < this.size(); ++i) {
            sum += this.items[i] * list.get(i);
        }
        return sum;
    }

    public LazyDoubleIterable asReversed() {
        return ReverseDoubleIterable.adapt((DoubleList)this);
    }

    public MutableDoubleList toSortedList() {
        return DoubleArrayList.newList((DoubleIterable)this).sortThis();
    }

    public int binarySearch(double value) {
        return Arrays.binarySearch(this.items, value);
    }

    public double[] toArray() {
        double[] newItems = new double[this.items.length];
        System.arraycopy(this.items, 0, newItems, 0, this.items.length);
        return newItems;
    }

    public boolean contains(double value) {
        for (double item : this.items) {
            if (Double.compare(item, value) != 0) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(double ... source) {
        for (double value : source) {
            if (this.contains(value)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(DoubleIterable source) {
        DoubleIterator iterator = source.doubleIterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public MutableDoubleList toList() {
        return DoubleArrayList.newList((DoubleIterable)this);
    }

    public MutableDoubleSet toSet() {
        return DoubleHashSet.newSet((DoubleIterable)this);
    }

    public MutableDoubleBag toBag() {
        return DoubleHashBag.newBag((DoubleIterable)this);
    }

    public LazyDoubleIterable asLazy() {
        return new LazyDoubleIterableAdapter((DoubleIterable)this);
    }

    public ImmutableDoubleList toImmutable() {
        return this;
    }

    public ImmutableDoubleArrayList toReversed() {
        return ImmutableDoubleArrayList.newList((DoubleIterable)this.asReversed());
    }

    public ImmutableDoubleList newWith(double element) {
        double[] newItems = new double[this.items.length + 1];
        System.arraycopy(this.items, 0, newItems, 0, this.items.length);
        newItems[this.items.length] = element;
        return new ImmutableDoubleArrayList(newItems);
    }

    public ImmutableDoubleList newWithout(double element) {
        int index = this.indexOf(element);
        if (index != -1) {
            double[] newItems = new double[this.items.length - 1];
            System.arraycopy(this.items, 0, newItems, 0, index);
            System.arraycopy(this.items, index + 1, newItems, index, this.items.length - index - 1);
            return DoubleLists.immutable.with(newItems);
        }
        return this;
    }

    public ImmutableDoubleList newWithAll(DoubleIterable elements) {
        double[] newItems = new double[this.items.length + elements.size()];
        System.arraycopy(this.items, 0, newItems, 0, this.items.length);
        int index = 0;
        DoubleIterator iterator = elements.doubleIterator();
        while (iterator.hasNext()) {
            newItems[this.items.length + index] = iterator.next();
            ++index;
        }
        return new ImmutableDoubleArrayList(newItems);
    }

    public ImmutableDoubleList newWithoutAll(DoubleIterable elements) {
        MutableDoubleList mutableDoubleList = this.toList();
        mutableDoubleList.removeAll(elements);
        return mutableDoubleList.toImmutable();
    }

    public int size() {
        return this.items.length;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean notEmpty() {
        return true;
    }

    public <T> T injectInto(T injectedValue, ObjectDoubleToObjectFunction<? super T, ? extends T> function) {
        Object result = injectedValue;
        for (int i = 0; i < this.items.length; ++i) {
            result = function.valueOf(result, this.items[i]);
        }
        return result;
    }

    public <T> T injectIntoWithIndex(T injectedValue, ObjectDoubleIntToObjectFunction<? super T, ? extends T> function) {
        Object result = injectedValue;
        for (int i = 0; i < this.items.length; ++i) {
            result = function.valueOf(result, this.items[i], i);
        }
        return result;
    }

    public boolean equals(Object otherList) {
        if (otherList == this) {
            return true;
        }
        if (!(otherList instanceof DoubleList)) {
            return false;
        }
        DoubleList list = (DoubleList)otherList;
        if (this.items.length != list.size()) {
            return false;
        }
        for (int i = 0; i < this.items.length; ++i) {
            if (Double.compare(this.items[i], list.get(i)) == 0) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        for (double item : this.items) {
            hashCode = 31 * hashCode + (int)(Double.doubleToLongBits(item) ^ Double.doubleToLongBits(item) >>> 32);
        }
        return hashCode;
    }

    public String toString() {
        return this.makeString("[", ", ", "]");
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            for (int i = 0; i < this.items.length; ++i) {
                if (i > 0) {
                    appendable.append(separator);
                }
                double value = this.items[i];
                appendable.append(String.valueOf(value));
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ImmutableDoubleList distinct() {
        DoubleArrayList target = new DoubleArrayList();
        DoubleHashSet seenSoFar = new DoubleHashSet(this.size());
        for (double each : this.items) {
            if (!seenSoFar.add(each)) continue;
            target.add(each);
        }
        return target.toImmutable();
    }

    public ImmutableDoubleList subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException("subList not yet implemented!");
    }

    private class InternalDoubleIterator
    implements DoubleIterator {
        private int currentIndex;

        private InternalDoubleIterator() {
        }

        public boolean hasNext() {
            return this.currentIndex != ImmutableDoubleArrayList.this.items.length;
        }

        public double next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            double next = ImmutableDoubleArrayList.this.items[this.currentIndex];
            ++this.currentIndex;
            return next;
        }
    }
}

