/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.LazyFloatIterable;
import org.eclipse.collections.api.bag.primitive.MutableFloatBag;
import org.eclipse.collections.api.block.function.primitive.FloatToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectFloatToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.FloatPredicate;
import org.eclipse.collections.api.block.procedure.primitive.FloatIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.FloatProcedure;
import org.eclipse.collections.api.iterator.FloatIterator;
import org.eclipse.collections.api.list.primitive.MutableFloatList;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.api.set.primitive.FloatSet;
import org.eclipse.collections.api.set.primitive.ImmutableFloatSet;
import org.eclipse.collections.api.set.primitive.MutableFloatSet;
import org.eclipse.collections.impl.bag.mutable.primitive.FloatHashBag;
import org.eclipse.collections.impl.factory.primitive.FloatSets;
import org.eclipse.collections.impl.iterator.UnmodifiableFloatIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyFloatIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.FloatArrayList;
import org.eclipse.collections.impl.set.mutable.UnifiedSet;
import org.eclipse.collections.impl.set.mutable.primitive.FloatHashSet;

final class ImmutableFloatSingletonSet
implements ImmutableFloatSet,
Serializable {
    private static final long serialVersionUID = 1L;
    private final float element;

    ImmutableFloatSingletonSet(float element) {
        this.element = element;
    }

    public ImmutableFloatSet newWith(float element) {
        return FloatSets.immutable.with(new float[]{this.element, element});
    }

    public ImmutableFloatSet newWithout(float element) {
        return Float.compare(this.element, element) == 0 ? FloatSets.immutable.with() : this;
    }

    public ImmutableFloatSet newWithAll(FloatIterable elements) {
        return FloatHashSet.newSet(elements).with(this.element).toImmutable();
    }

    public ImmutableFloatSet newWithoutAll(FloatIterable elements) {
        return elements.contains(this.element) ? FloatSets.immutable.with() : this;
    }

    public int size() {
        return 1;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean notEmpty() {
        return true;
    }

    public boolean contains(float value) {
        return Float.compare(this.element, value) == 0;
    }

    public boolean containsAll(FloatIterable source) {
        FloatIterator iterator = source.floatIterator();
        while (iterator.hasNext()) {
            if (Float.compare(this.element, iterator.next()) == 0) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(float ... source) {
        for (float value : source) {
            if (Float.compare(this.element, value) == 0) continue;
            return false;
        }
        return true;
    }

    public void forEach(FloatProcedure procedure) {
        this.each(procedure);
    }

    public void each(FloatProcedure procedure) {
        procedure.value(this.element);
    }

    public ImmutableFloatSet select(FloatPredicate predicate) {
        return predicate.accept(this.element) ? FloatHashSet.newSetWith(this.element).toImmutable() : new FloatHashSet().toImmutable();
    }

    public ImmutableFloatSet reject(FloatPredicate predicate) {
        return predicate.accept(this.element) ? new FloatHashSet().toImmutable() : FloatHashSet.newSetWith(this.element).toImmutable();
    }

    public <V> ImmutableSet<V> collect(FloatToObjectFunction<? extends V> function) {
        return UnifiedSet.newSetWith(function.valueOf(this.element)).toImmutable();
    }

    public MutableFloatList toList() {
        return FloatArrayList.newListWith(this.element);
    }

    public int sizeDistinct() {
        return 1;
    }

    public int occurrencesOf(float item) {
        return Float.compare(this.element, item) == 0 ? 1 : 0;
    }

    public void forEachWithOccurrences(FloatIntProcedure floatIntProcedure) {
        floatIntProcedure.value(this.element, 1);
    }

    public float detectIfNone(FloatPredicate predicate, float ifNone) {
        return predicate.accept(this.element) ? this.element : ifNone;
    }

    public int count(FloatPredicate predicate) {
        return predicate.accept(this.element) ? 1 : 0;
    }

    public boolean anySatisfy(FloatPredicate predicate) {
        return predicate.accept(this.element);
    }

    public double sum() {
        return this.element;
    }

    public float min() {
        return this.element;
    }

    public float max() {
        return this.element;
    }

    public float maxIfEmpty(float defaultValue) {
        return this.element;
    }

    public float minIfEmpty(float defaultValue) {
        return this.element;
    }

    public double average() {
        return this.element;
    }

    public double median() {
        return this.element;
    }

    public float[] toSortedArray() {
        return new float[]{this.element};
    }

    public MutableFloatList toSortedList() {
        return FloatArrayList.newListWith(this.element);
    }

    public boolean noneSatisfy(FloatPredicate predicate) {
        return !predicate.accept(this.element);
    }

    public boolean allSatisfy(FloatPredicate predicate) {
        return predicate.accept(this.element);
    }

    public <T> T injectInto(T injectedValue, ObjectFloatToObjectFunction<? super T, ? extends T> function) {
        return (T)function.valueOf(injectedValue, this.element);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FloatSet)) {
            return false;
        }
        FloatSet set = (FloatSet)obj;
        if (set.size() != 1) {
            return false;
        }
        return set.contains(this.element);
    }

    public int hashCode() {
        return Float.floatToIntBits(this.element);
    }

    public MutableFloatSet toSet() {
        return FloatHashSet.newSetWith(this.element);
    }

    public MutableFloatBag toBag() {
        return FloatHashBag.newBagWith(this.element);
    }

    public FloatSet freeze() {
        return this;
    }

    public ImmutableFloatSet toImmutable() {
        return this;
    }

    public LazyFloatIterable asLazy() {
        return new LazyFloatIterableAdapter((FloatIterable)this);
    }

    public float[] toArray() {
        return new float[]{this.element};
    }

    public String toString() {
        return '[' + this.makeString() + ']';
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.element));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public FloatIterator floatIterator() {
        return new UnmodifiableFloatIterator((FloatIterator)FloatHashSet.newSetWith(this.element).floatIterator());
    }
}

