/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.LazyCharIterable;
import org.eclipse.collections.api.LazyIntIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.primitive.ImmutableIntBag;
import org.eclipse.collections.api.bag.primitive.MutableIntBag;
import org.eclipse.collections.api.block.function.primitive.IntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.CharIntPredicate;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.procedure.primitive.CharIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.CharProcedure;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.iterator.CharIterator;
import org.eclipse.collections.api.iterator.IntIterator;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.api.map.primitive.CharIntMap;
import org.eclipse.collections.api.map.primitive.ImmutableCharIntMap;
import org.eclipse.collections.api.map.primitive.MutableCharIntMap;
import org.eclipse.collections.api.set.primitive.MutableCharSet;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.api.tuple.primitive.CharIntPair;
import org.eclipse.collections.impl.block.procedure.checked.primitive.CheckedCharIntProcedure;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableIntCollection;
import org.eclipse.collections.impl.iterator.UnmodifiableIntIterator;
import org.eclipse.collections.impl.map.mutable.primitive.CharIntHashMap;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableCharSet;

final class ImmutableCharIntHashMap
implements ImmutableCharIntMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableCharIntMap delegate;

    ImmutableCharIntHashMap(CharIntMap delegate) {
        this.delegate = new CharIntHashMap(delegate);
    }

    public int get(char key) {
        return this.delegate.get(key);
    }

    public int getIfAbsent(char key, int ifAbsent) {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    public int getOrThrow(char key) {
        return this.delegate.getOrThrow(key);
    }

    public boolean containsKey(char key) {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(int value) {
        return this.delegate.containsValue(value);
    }

    public void forEachValue(IntProcedure procedure) {
        this.delegate.forEachValue(procedure);
    }

    public void forEachKey(CharProcedure procedure) {
        this.delegate.forEachKey(procedure);
    }

    public void forEachKeyValue(CharIntProcedure procedure) {
        this.delegate.forEachKeyValue(procedure);
    }

    public LazyCharIterable keysView() {
        return this.delegate.keysView();
    }

    public RichIterable<CharIntPair> keyValuesView() {
        return this.delegate.keyValuesView();
    }

    public ImmutableCharIntMap select(CharIntPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableCharIntMap reject(CharIntPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    public <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function) {
        return (T)this.delegate.injectInto(injectedValue, function);
    }

    public ImmutableCharIntMap toImmutable() {
        return this;
    }

    public IntIterator intIterator() {
        return new UnmodifiableIntIterator((IntIterator)this.delegate.intIterator());
    }

    public void forEach(IntProcedure procedure) {
        this.each(procedure);
    }

    public void each(IntProcedure procedure) {
        this.delegate.forEach(procedure);
    }

    public int count(IntPredicate predicate) {
        return this.delegate.count(predicate);
    }

    public boolean anySatisfy(IntPredicate predicate) {
        return this.delegate.anySatisfy(predicate);
    }

    public boolean allSatisfy(IntPredicate predicate) {
        return this.delegate.allSatisfy(predicate);
    }

    public boolean noneSatisfy(IntPredicate predicate) {
        return this.delegate.noneSatisfy(predicate);
    }

    public ImmutableIntBag select(IntPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableIntBag reject(IntPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    public <V> ImmutableBag<V> collect(IntToObjectFunction<? extends V> function) {
        MutableBag bag = this.delegate.collect(function);
        return bag.toImmutable();
    }

    public int detectIfNone(IntPredicate predicate, int ifNone) {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    public long sum() {
        return this.delegate.sum();
    }

    public int max() {
        return this.delegate.max();
    }

    public int maxIfEmpty(int defaultValue) {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    public int min() {
        return this.delegate.min();
    }

    public int minIfEmpty(int defaultValue) {
        return this.delegate.minIfEmpty(defaultValue);
    }

    public double average() {
        return this.delegate.average();
    }

    public double median() {
        return this.delegate.median();
    }

    public int[] toSortedArray() {
        return this.delegate.toSortedArray();
    }

    public MutableIntList toSortedList() {
        return this.delegate.toSortedList();
    }

    public int[] toArray() {
        return this.delegate.toArray();
    }

    public boolean contains(int value) {
        return this.delegate.contains(value);
    }

    public boolean containsAll(int ... source) {
        return this.delegate.containsAll(source);
    }

    public boolean containsAll(IntIterable source) {
        return this.delegate.containsAll(source);
    }

    public MutableIntList toList() {
        return this.delegate.toList();
    }

    public MutableIntSet toSet() {
        return this.delegate.toSet();
    }

    public MutableIntBag toBag() {
        return this.delegate.toBag();
    }

    public LazyIntIterable asLazy() {
        return this.delegate.asLazy();
    }

    public ImmutableCharIntMap newWithKeyValue(char key, int value) {
        CharIntHashMap map = new CharIntHashMap(this.size() + 1);
        map.putAll((CharIntMap)this);
        map.put(key, value);
        return map.toImmutable();
    }

    public ImmutableCharIntMap newWithoutKey(char key) {
        CharIntHashMap map = new CharIntHashMap(this.size());
        map.putAll((CharIntMap)this);
        map.removeKey(key);
        return map.toImmutable();
    }

    public ImmutableCharIntMap newWithoutAllKeys(CharIterable keys) {
        CharIntHashMap map = new CharIntHashMap(this.size());
        map.putAll((CharIntMap)this);
        CharIterator iterator = keys.charIterator();
        while (iterator.hasNext()) {
            map.removeKey(iterator.next());
        }
        return map.toImmutable();
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public boolean notEmpty() {
        return this.delegate.notEmpty();
    }

    public String makeString() {
        return this.delegate.makeString();
    }

    public String makeString(String separator) {
        return this.delegate.makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.delegate.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.delegate.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.delegate.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.appendString(appendable, start, separator, end);
    }

    public MutableCharSet keySet() {
        return UnmodifiableCharSet.of(this.delegate.keySet());
    }

    public MutableIntCollection values() {
        return UnmodifiableIntCollection.of(this.delegate.values());
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return this.delegate.toString();
    }

    private Object writeReplace() {
        return new ImmutableCharIntMapSerializationProxy((CharIntMap)this);
    }

    protected static class ImmutableCharIntMapSerializationProxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private CharIntMap map;

        public ImmutableCharIntMapSerializationProxy() {
        }

        protected ImmutableCharIntMapSerializationProxy(CharIntMap map) {
            this.map = map;
        }

        @Override
        public void writeExternal(final ObjectOutput out) throws IOException {
            out.writeInt(this.map.size());
            try {
                this.map.forEachKeyValue((CharIntProcedure)new CheckedCharIntProcedure(){

                    @Override
                    public void safeValue(char key, int value) throws IOException {
                        out.writeChar(key);
                        out.writeInt(value);
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            CharIntHashMap deserializedMap = new CharIntHashMap();
            for (int i = 0; i < size; ++i) {
                deserializedMap.put(in.readChar(), in.readInt());
            }
            this.map = deserializedMap;
        }

        protected Object readResolve() {
            return this.map.toImmutable();
        }
    }
}

