/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.bag.mutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.primitive.ByteBag;
import org.eclipse.collections.api.bag.primitive.ImmutableByteBag;
import org.eclipse.collections.api.bag.primitive.MutableByteBag;
import org.eclipse.collections.api.block.function.primitive.ByteToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.IntToIntFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BytePredicate;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.procedure.primitive.ByteIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ByteProcedure;
import org.eclipse.collections.api.iterator.ByteIterator;
import org.eclipse.collections.api.iterator.MutableByteIterator;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.set.primitive.ByteSet;
import org.eclipse.collections.api.tuple.primitive.ByteIntPair;
import org.eclipse.collections.impl.Counter;
import org.eclipse.collections.impl.bag.mutable.HashBag;
import org.eclipse.collections.impl.bag.mutable.primitive.SynchronizedByteBag;
import org.eclipse.collections.impl.bag.mutable.primitive.UnmodifiableByteBag;
import org.eclipse.collections.impl.block.factory.primitive.IntToIntFunctions;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.ByteBags;
import org.eclipse.collections.impl.list.mutable.FastList;
import org.eclipse.collections.impl.map.mutable.primitive.ByteIntHashMap;
import org.eclipse.collections.impl.primitive.AbstractByteIterable;
import org.eclipse.collections.impl.set.mutable.primitive.ByteHashSet;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;

public final class ByteHashBag
extends AbstractByteIterable
implements MutableByteBag,
Externalizable {
    private static final long serialVersionUID = 1L;
    private ByteIntHashMap items;
    private int size;

    public ByteHashBag() {
        this.items = new ByteIntHashMap();
    }

    public ByteHashBag(int size) {
        this.items = new ByteIntHashMap(size);
    }

    public ByteHashBag(ByteIterable iterable) {
        this();
        this.addAll(iterable);
    }

    public ByteHashBag(byte ... elements) {
        this();
        this.addAll(elements);
    }

    public ByteHashBag(ByteHashBag bag) {
        this.items = new ByteIntHashMap(bag.sizeDistinct());
        this.addAll(bag);
    }

    public static ByteHashBag newBag(int size) {
        return new ByteHashBag(size);
    }

    public static ByteHashBag newBagWith(byte ... source) {
        return new ByteHashBag(source);
    }

    public static ByteHashBag newBag(ByteIterable source) {
        if (source instanceof ByteHashBag) {
            return new ByteHashBag((ByteHashBag)source);
        }
        return new ByteHashBag(source);
    }

    public static ByteHashBag newBag(ByteBag source) {
        return new ByteHashBag((ByteIterable)source);
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public boolean notEmpty() {
        return this.items.notEmpty();
    }

    public int size() {
        return this.size;
    }

    public int sizeDistinct() {
        return this.items.size();
    }

    public void clear() {
        this.items.clear();
        this.size = 0;
    }

    public ByteHashBag with(byte element) {
        this.add(element);
        return this;
    }

    public ByteHashBag with(byte element1, byte element2) {
        this.add(element1);
        this.add(element2);
        return this;
    }

    public ByteHashBag with(byte element1, byte element2, byte element3) {
        this.add(element1);
        this.add(element2);
        this.add(element3);
        return this;
    }

    public ByteHashBag withAll(ByteIterable iterable) {
        this.addAll(iterable);
        return this;
    }

    public ByteHashBag without(byte element) {
        this.remove(element);
        return this;
    }

    public ByteHashBag withoutAll(ByteIterable iterable) {
        this.removeAll(iterable);
        return this;
    }

    public boolean contains(byte value) {
        return this.items.containsKey(value);
    }

    public int occurrencesOf(byte item) {
        return this.items.get(item);
    }

    public void forEachWithOccurrences(ByteIntProcedure procedure) {
        this.items.forEachKeyValue(procedure);
    }

    public ByteHashBag selectByOccurrences(IntPredicate predicate) {
        ByteHashBag result = new ByteHashBag();
        this.forEachWithOccurrences((ByteIntProcedure & Serializable)(each, occurrences) -> {
            if (predicate.accept(occurrences)) {
                result.addOccurrences(each, occurrences);
            }
        });
        return result;
    }

    public MutableList<ByteIntPair> topOccurrences(int count) {
        return this.occurrencesSortingBy(count, (IntFunction<ByteIntPair>)(IntFunction & Serializable)item -> -item.getTwo(), (MutableList<ByteIntPair>)Lists.mutable.empty());
    }

    public MutableList<ByteIntPair> bottomOccurrences(int count) {
        return this.occurrencesSortingBy(count, (IntFunction<ByteIntPair>)((IntFunction & Serializable)ByteIntPair::getTwo), (MutableList<ByteIntPair>)Lists.mutable.empty());
    }

    protected MutableList<ByteIntPair> occurrencesSortingBy(int n, IntFunction<ByteIntPair> function, MutableList<ByteIntPair> returnWhenEmpty) {
        int keySize;
        if (n < 0) {
            throw new IllegalArgumentException("Cannot use a value of n < 0");
        }
        if (n == 0) {
            return returnWhenEmpty;
        }
        MutableList sorted = this.toListWithOccurrences().sortThisByInt(function);
        MutableList results = sorted.subList(0, keySize).toList();
        for (keySize = Math.min(n, this.sizeDistinct()); keySize < sorted.size() && ((ByteIntPair)results.getLast()).getTwo() == ((ByteIntPair)sorted.get(keySize)).getTwo(); ++keySize) {
            results.add(sorted.get(keySize));
        }
        return results;
    }

    protected MutableList<ByteIntPair> toListWithOccurrences() {
        FastList<ByteIntPair> result = FastList.newList(this.sizeDistinct());
        this.forEachWithOccurrences((ByteIntProcedure & Serializable)(each, count) -> result.add(PrimitiveTuples.pair(each, count)));
        return result;
    }

    public boolean add(byte item) {
        this.items.updateValue(item, 0, IntToIntFunctions.increment());
        ++this.size;
        return true;
    }

    public boolean remove(byte item) {
        int newValue = this.items.updateValue(item, 0, IntToIntFunctions.decrement());
        if (newValue <= 0) {
            this.items.removeKey(item);
            if (newValue == 0) {
                --this.size;
            }
            return newValue == 0;
        }
        --this.size;
        return true;
    }

    public boolean addAll(byte ... source) {
        if (source.length == 0) {
            return false;
        }
        for (byte each : source) {
            this.add(each);
        }
        return true;
    }

    public boolean addAll(ByteIterable source) {
        if (source.isEmpty()) {
            return false;
        }
        if (source instanceof ByteBag) {
            ByteBag otherBag = (ByteBag)source;
            otherBag.forEachWithOccurrences(this::addOccurrences);
        } else {
            ByteIterator iterator = source.byteIterator();
            while (iterator.hasNext()) {
                byte each = iterator.next();
                this.add(each);
            }
        }
        return true;
    }

    public boolean removeAll(byte ... source) {
        if (source.length == 0) {
            return false;
        }
        int oldSize = this.size();
        for (byte each : source) {
            int occurrences = this.items.removeKeyIfAbsent(each, 0);
            this.size -= occurrences;
        }
        return this.size() != oldSize;
    }

    public boolean removeAll(ByteIterable source) {
        if (source.isEmpty()) {
            return false;
        }
        int oldSize = this.size();
        if (source instanceof ByteBag) {
            ByteBag otherBag = (ByteBag)source;
            otherBag.forEachWithOccurrences((ByteIntProcedure & Serializable)(each, occurrences) -> {
                int oldOccurrences = this.items.removeKeyIfAbsent(each, 0);
                this.size -= oldOccurrences;
            });
        } else {
            ByteIterator iterator = source.byteIterator();
            while (iterator.hasNext()) {
                byte each2 = iterator.next();
                int occurrences2 = this.items.removeKeyIfAbsent(each2, 0);
                this.size -= occurrences2;
            }
        }
        return this.size() != oldSize;
    }

    public boolean retainAll(ByteIterable source) {
        int oldSize = this.size();
        ByteSet sourceSet = source instanceof ByteSet ? (ByteSet)source : source.toSet();
        ByteHashBag retained = this.select(arg_0 -> ((ByteSet)sourceSet).contains(arg_0));
        if (retained.size() != oldSize) {
            this.items = retained.items;
            this.size = retained.size;
            return true;
        }
        return false;
    }

    public boolean retainAll(byte ... source) {
        return this.retainAll((ByteIterable)ByteHashSet.newSetWith(source));
    }

    public void addOccurrences(byte item, int occurrences) {
        if (occurrences < 0) {
            throw new IllegalArgumentException("Cannot add a negative number of occurrences");
        }
        if (occurrences > 0) {
            this.items.updateValue(item, 0, (IntToIntFunction & Serializable)intParameter -> intParameter + occurrences);
            this.size += occurrences;
        }
    }

    public boolean removeOccurrences(byte item, int occurrences) {
        if (occurrences < 0) {
            throw new IllegalArgumentException("Cannot remove a negative number of occurrences");
        }
        if (occurrences == 0) {
            return false;
        }
        int newValue = this.items.updateValue(item, 0, (IntToIntFunction & Serializable)intParameter -> intParameter - occurrences);
        if (newValue <= 0) {
            this.size -= occurrences - newValue;
            this.items.removeKey(item);
            return newValue + occurrences != 0;
        }
        this.size -= occurrences;
        return true;
    }

    public void forEach(ByteProcedure procedure) {
        this.each(procedure);
    }

    public void each(ByteProcedure procedure) {
        this.items.forEachKeyValue((ByteIntProcedure & Serializable)(key, occurrences) -> {
            for (int i = 0; i < occurrences; ++i) {
                procedure.value(key);
            }
        });
    }

    public ByteHashBag select(BytePredicate predicate) {
        ByteHashBag result = new ByteHashBag();
        this.forEachWithOccurrences((ByteIntProcedure & Serializable)(each, occurrences) -> {
            if (predicate.accept(each)) {
                result.addOccurrences(each, occurrences);
            }
        });
        return result;
    }

    public ByteHashBag reject(BytePredicate predicate) {
        ByteHashBag result = new ByteHashBag();
        this.forEachWithOccurrences((ByteIntProcedure & Serializable)(each, occurrences) -> {
            if (!predicate.accept(each)) {
                result.addOccurrences(each, occurrences);
            }
        });
        return result;
    }

    public <T> T injectInto(T injectedValue, ObjectByteToObjectFunction<? super T, ? extends T> function) {
        Object[] result = new Object[]{injectedValue};
        this.forEachWithOccurrences((ByteIntProcedure & Serializable)(each, occurrences) -> {
            for (int i = 0; i < occurrences; ++i) {
                result[0] = function.valueOf(result[0], each);
            }
        });
        return (T)result[0];
    }

    public boolean equals(Object otherBag) {
        if (otherBag == this) {
            return true;
        }
        if (!(otherBag instanceof ByteBag)) {
            return false;
        }
        ByteBag bag = (ByteBag)otherBag;
        if (this.sizeDistinct() != bag.sizeDistinct()) {
            return false;
        }
        return this.items.keysView().allSatisfy((BytePredicate & Serializable)key -> this.occurrencesOf(key) == bag.occurrencesOf(key));
    }

    public int hashCode() {
        Counter result = new Counter();
        this.forEachWithOccurrences((ByteIntProcedure & Serializable)(eachItem, occurrences) -> result.add(eachItem ^ occurrences));
        return result.getCount();
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        boolean[] firstItem = new boolean[]{true};
        try {
            appendable.append(start);
            this.items.forEachKeyValue((ByteIntProcedure & Serializable)(each, occurrences) -> {
                try {
                    for (int i = 0; i < occurrences; ++i) {
                        if (!firstItem[0]) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(each));
                        firstItem[0] = false;
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int count(BytePredicate predicate) {
        Counter result = new Counter();
        this.forEachWithOccurrences((ByteIntProcedure & Serializable)(each, occurrences) -> {
            if (predicate.accept(each)) {
                result.add(occurrences);
            }
        });
        return result.getCount();
    }

    public boolean anySatisfy(BytePredicate predicate) {
        return this.items.keysView().anySatisfy(predicate);
    }

    public boolean allSatisfy(BytePredicate predicate) {
        return this.items.keysView().allSatisfy(predicate);
    }

    public boolean noneSatisfy(BytePredicate predicate) {
        return this.items.keysView().noneSatisfy(predicate);
    }

    public byte detectIfNone(BytePredicate predicate, byte ifNone) {
        return this.items.keysView().detectIfNone(predicate, ifNone);
    }

    public <V> MutableBag<V> collect(ByteToObjectFunction<? extends V> function) {
        HashBag result = HashBag.newBag(this.items.size());
        this.forEachWithOccurrences((ByteIntProcedure & Serializable)(each, occurrences) -> result.addOccurrences(function.valueOf(each), occurrences));
        return result;
    }

    public byte max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.items.keysView().max();
    }

    public byte min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.items.keysView().min();
    }

    public long sum() {
        long[] result = new long[]{0L};
        this.forEachWithOccurrences((ByteIntProcedure & Serializable)(each, occurrences) -> {
            result[0] = result[0] + (long)each * (long)occurrences;
        });
        return result[0];
    }

    public byte[] toArray() {
        byte[] array = new byte[this.size()];
        int[] index = new int[]{0};
        this.forEachWithOccurrences((ByteIntProcedure & Serializable)(each, occurrences) -> {
            for (int i = 0; i < occurrences; ++i) {
                array[index[0]] = each;
                index[0] = index[0] + 1;
            }
        });
        return array;
    }

    public MutableByteBag asUnmodifiable() {
        return new UnmodifiableByteBag(this);
    }

    public MutableByteBag asSynchronized() {
        return new SynchronizedByteBag(this);
    }

    public ImmutableByteBag toImmutable() {
        return ByteBags.immutable.withAll((ByteIterable)this);
    }

    public MutableByteIterator byteIterator() {
        return new InternalIterator();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.items.size());
        try {
            this.items.forEachKeyValue((ByteIntProcedure & Serializable)(each, occurrences) -> {
                try {
                    out.writeByte(each);
                    out.writeInt(occurrences);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        int size = in.readInt();
        this.items = new ByteIntHashMap(size);
        for (int i = 0; i < size; ++i) {
            this.addOccurrences(in.readByte(), in.readInt());
        }
    }

    private class InternalIterator
    implements MutableByteIterator {
        private final MutableByteIterator byteIterator;
        private byte currentItem;
        private int occurrences;
        private boolean canRemove;

        private InternalIterator() {
            this.byteIterator = ByteHashBag.this.items.keySet().byteIterator();
        }

        public boolean hasNext() {
            return this.occurrences > 0 || this.byteIterator.hasNext();
        }

        public byte next() {
            if (this.occurrences == 0) {
                this.currentItem = this.byteIterator.next();
                this.occurrences = ByteHashBag.this.occurrencesOf(this.currentItem);
            }
            --this.occurrences;
            this.canRemove = true;
            return this.currentItem;
        }

        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            if (this.occurrences == 0) {
                this.byteIterator.remove();
                ByteHashBag.this.size--;
            } else {
                ByteHashBag.this.remove(this.currentItem);
            }
            this.canRemove = false;
        }
    }
}

