/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.utility.primitive;

import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.LazyByteIterable;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.block.function.primitive.ByteToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BytePredicate;
import org.eclipse.collections.impl.factory.primitive.ByteLists;
import org.eclipse.collections.impl.lazy.primitive.CollectByteToObjectIterable;
import org.eclipse.collections.impl.lazy.primitive.FlatCollectByteToObjectIterable;
import org.eclipse.collections.impl.lazy.primitive.LazyByteIterableAdapter;
import org.eclipse.collections.impl.lazy.primitive.SelectByteIterable;

public final class LazyByteIterate {
    private static final LazyByteIterable EMPTY_ITERABLE = ByteLists.immutable.empty().asLazy();

    private LazyByteIterate() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static LazyByteIterable adapt(ByteIterable iterable) {
        return new LazyByteIterableAdapter(iterable);
    }

    public static LazyByteIterable select(ByteIterable iterable, BytePredicate predicate) {
        return new SelectByteIterable(iterable, predicate);
    }

    public static <V> LazyIterable<V> collect(ByteIterable iterable, ByteToObjectFunction<? extends V> function) {
        return new CollectByteToObjectIterable<V>(iterable, function);
    }

    public static <V> LazyIterable<V> flatCollect(ByteIterable iterable, ByteToObjectFunction<? extends Iterable<V>> function) {
        return new FlatCollectByteToObjectIterable(iterable, function);
    }

    public static <V> LazyIterable<V> collectIf(ByteIterable iterable, BytePredicate predicate, ByteToObjectFunction<? extends V> function) {
        return LazyByteIterate.select(iterable, predicate).collect(function);
    }

    public static LazyByteIterable empty() {
        return EMPTY_ITERABLE;
    }
}

