/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.LazyIntIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction0;
import org.eclipse.collections.api.block.function.primitive.DoubleToDoubleFunction;
import org.eclipse.collections.api.block.function.primitive.IntToDoubleFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectDoubleToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.IntDoublePredicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.IntDoubleProcedure;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.collection.primitive.MutableDoubleCollection;
import org.eclipse.collections.api.iterator.IntIterator;
import org.eclipse.collections.api.iterator.MutableDoubleIterator;
import org.eclipse.collections.api.iterator.MutableIntIterator;
import org.eclipse.collections.api.map.primitive.ImmutableIntDoubleMap;
import org.eclipse.collections.api.map.primitive.IntDoubleMap;
import org.eclipse.collections.api.map.primitive.MutableIntDoubleMap;
import org.eclipse.collections.api.set.primitive.DoubleSet;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.api.tuple.primitive.IntDoublePair;
import org.eclipse.collections.impl.SpreadFunctions;
import org.eclipse.collections.impl.factory.primitive.IntDoubleMaps;
import org.eclipse.collections.impl.iterator.UnmodifiableIntIterator;
import org.eclipse.collections.impl.lazy.AbstractLazyIterable;
import org.eclipse.collections.impl.lazy.primitive.AbstractLazyIntIterable;
import org.eclipse.collections.impl.map.mutable.primitive.AbstractMutableDoubleValuesMap;
import org.eclipse.collections.impl.map.mutable.primitive.AbstractMutableIntKeySet;
import org.eclipse.collections.impl.map.mutable.primitive.ImmutableIntMapKeySet;
import org.eclipse.collections.impl.map.mutable.primitive.MutableIntKeysMap;
import org.eclipse.collections.impl.map.mutable.primitive.SynchronizedIntDoubleMap;
import org.eclipse.collections.impl.map.mutable.primitive.UnmodifiableIntDoubleMap;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;

public class IntDoubleHashMap
extends AbstractMutableDoubleValuesMap
implements MutableIntDoubleMap,
Externalizable,
MutableIntKeysMap {
    private static final double EMPTY_VALUE = 0.0;
    private static final long serialVersionUID = 1L;
    private static final int EMPTY_KEY = 0;
    private static final int REMOVED_KEY = 1;
    private static final int CACHE_LINE_SIZE = 64;
    private static final int KEY_SIZE = 4;
    private static final int INITIAL_LINEAR_PROBE = 8;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private int[] keys;
    private double[] values;
    private int occupiedWithData;
    private int occupiedWithSentinels;
    private AbstractMutableDoubleValuesMap.SentinelValues sentinelValues;
    private boolean copyKeysOnWrite;

    public IntDoubleHashMap() {
        this.allocateTable(16);
    }

    public IntDoubleHashMap(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        int capacity = this.smallestPowerOfTwoGreaterThan(initialCapacity << 1);
        this.allocateTable(capacity);
    }

    public IntDoubleHashMap(IntDoubleMap map) {
        if (map instanceof IntDoubleHashMap && ((IntDoubleHashMap)map).occupiedWithSentinels == 0) {
            IntDoubleHashMap hashMap = (IntDoubleHashMap)map;
            this.occupiedWithData = hashMap.occupiedWithData;
            if (hashMap.sentinelValues != null) {
                this.sentinelValues = hashMap.sentinelValues.copy();
            }
            this.keys = Arrays.copyOf(hashMap.keys, hashMap.keys.length);
            this.values = Arrays.copyOf(hashMap.values, hashMap.values.length);
        } else {
            int capacity = this.smallestPowerOfTwoGreaterThan(Math.max(map.size(), 8) << 1);
            this.allocateTable(capacity);
            this.putAll(map);
        }
    }

    public static IntDoubleHashMap newWithKeysValues(int key1, double value1) {
        return new IntDoubleHashMap(1).withKeyValue(key1, value1);
    }

    public static IntDoubleHashMap newWithKeysValues(int key1, double value1, int key2, double value2) {
        return new IntDoubleHashMap(2).withKeysValues(key1, value1, key2, value2);
    }

    public static IntDoubleHashMap newWithKeysValues(int key1, double value1, int key2, double value2, int key3, double value3) {
        return new IntDoubleHashMap(3).withKeysValues(key1, value1, key2, value2, key3, value3);
    }

    public static IntDoubleHashMap newWithKeysValues(int key1, double value1, int key2, double value2, int key3, double value3, int key4, double value4) {
        return new IntDoubleHashMap(4).withKeysValues(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    @Override
    protected int getOccupiedWithData() {
        return this.occupiedWithData;
    }

    @Override
    protected AbstractMutableDoubleValuesMap.SentinelValues getSentinelValues() {
        return this.sentinelValues;
    }

    @Override
    protected void setSentinelValuesNull() {
        this.sentinelValues = null;
    }

    @Override
    protected double getEmptyValue() {
        return 0.0;
    }

    @Override
    protected int getTableSize() {
        return this.values.length;
    }

    @Override
    protected double getValueAtIndex(int index) {
        return this.values[index];
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IntDoubleMap)) {
            return false;
        }
        IntDoubleMap other = (IntDoubleMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        if (this.sentinelValues == null) {
            if (other.containsKey(0) || other.containsKey(1)) {
                return false;
            }
        } else {
            if (this.sentinelValues.containsZeroKey && (!other.containsKey(0) || Double.compare(this.sentinelValues.zeroValue, other.getOrThrow(0)) != 0)) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && (!other.containsKey(1) || Double.compare(this.sentinelValues.oneValue, other.getOrThrow(1)) != 0)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            int key = this.keys[i];
            if (!IntDoubleHashMap.isNonSentinel(key) || other.containsKey(key) && Double.compare(this.values[i], other.getOrThrow(key)) == 0) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result += 0 ^ (int)(Double.doubleToLongBits(this.sentinelValues.zeroValue) ^ Double.doubleToLongBits(this.sentinelValues.zeroValue) >>> 32);
            }
            if (this.sentinelValues.containsOneKey) {
                result += 1 ^ (int)(Double.doubleToLongBits(this.sentinelValues.oneValue) ^ Double.doubleToLongBits(this.sentinelValues.oneValue) >>> 32);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntDoubleHashMap.isNonSentinel(this.keys[i])) continue;
            result += this.keys[i] ^ (int)(Double.doubleToLongBits(this.values[i]) ^ Double.doubleToLongBits(this.values[i]) >>> 32);
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuilder appendable = new StringBuilder();
        appendable.append("{");
        boolean first = true;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                appendable.append(0).append("=").append(this.sentinelValues.zeroValue);
                first = false;
            }
            if (this.sentinelValues.containsOneKey) {
                if (!first) {
                    appendable.append(", ");
                }
                appendable.append(1).append("=").append(this.sentinelValues.oneValue);
                first = false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            int key = this.keys[i];
            if (!IntDoubleHashMap.isNonSentinel(key)) continue;
            if (!first) {
                appendable.append(", ");
            }
            appendable.append(key).append("=").append(this.values[i]);
            first = false;
        }
        appendable.append("}");
        return appendable.toString();
    }

    public MutableDoubleIterator doubleIterator() {
        return new InternalDoubleIterator();
    }

    public <V> V injectInto(V injectedValue, ObjectDoubleToObjectFunction<? super V, ? extends V> function) {
        Object result = injectedValue;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result = function.valueOf(result, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                result = function.valueOf(result, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntDoubleHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.valueOf(result, this.values[i]);
        }
        return result;
    }

    @Override
    public void clear() {
        this.sentinelValues = null;
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        if (this.copyKeysOnWrite) {
            this.copyKeys();
        }
        Arrays.fill(this.keys, 0);
        Arrays.fill(this.values, 0.0);
    }

    public void put(int key, double value) {
        if (IntDoubleHashMap.isEmptyKey(key)) {
            this.putForEmptySentinel(value);
            return;
        }
        if (IntDoubleHashMap.isRemovedKey(key)) {
            this.putForRemovedSentinel(value);
            return;
        }
        int index = this.probe(key);
        int keyAtIndex = this.keys[index];
        if (keyAtIndex == key) {
            this.values[index] = value;
        } else {
            this.addKeyValueAtIndex(key, value, index);
        }
    }

    private void putForRemovedSentinel(double value) {
        if (this.sentinelValues == null) {
            this.sentinelValues = new AbstractMutableDoubleValuesMap.SentinelValues();
        }
        this.addRemovedKeyValue(value);
    }

    private void putForEmptySentinel(double value) {
        if (this.sentinelValues == null) {
            this.sentinelValues = new AbstractMutableDoubleValuesMap.SentinelValues();
        }
        this.addEmptyKeyValue(value);
    }

    public void putAll(IntDoubleMap map) {
        map.forEachKeyValue(this::put);
    }

    @Override
    public void removeKey(int key) {
        if (IntDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return;
            }
            this.removeEmptyKey();
            return;
        }
        if (IntDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return;
            }
            this.removeRemovedKey();
            return;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.removeKeyAtIndex(index);
        }
    }

    public void remove(int key) {
        this.removeKey(key);
    }

    public double removeKeyIfAbsent(int key, double value) {
        if (IntDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return value;
            }
            double oldValue = this.sentinelValues.zeroValue;
            this.removeEmptyKey();
            return oldValue;
        }
        if (IntDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return value;
            }
            double oldValue = this.sentinelValues.oneValue;
            this.removeRemovedKey();
            return oldValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            double oldValue = this.values[index];
            this.removeKeyAtIndex(index);
            return oldValue;
        }
        return value;
    }

    public double getIfAbsentPut(int key, double value) {
        if (IntDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableDoubleValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            this.addEmptyKeyValue(value);
            return value;
        }
        if (IntDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableDoubleValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public double getIfAbsentPut(int key, DoubleFunction0 function) {
        if (IntDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                double value = function.value();
                this.sentinelValues = new AbstractMutableDoubleValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            double value = function.value();
            this.addEmptyKeyValue(value);
            return value;
        }
        if (IntDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                double value = function.value();
                this.sentinelValues = new AbstractMutableDoubleValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            double value = function.value();
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        double value = function.value();
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public <P> double getIfAbsentPutWith(int key, DoubleFunction<? super P> function, P parameter) {
        if (IntDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                double value = function.doubleValueOf(parameter);
                this.sentinelValues = new AbstractMutableDoubleValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            double value = function.doubleValueOf(parameter);
            this.addEmptyKeyValue(value);
            return value;
        }
        if (IntDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                double value = function.doubleValueOf(parameter);
                this.sentinelValues = new AbstractMutableDoubleValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            double value = function.doubleValueOf(parameter);
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        double value = function.doubleValueOf(parameter);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public double getIfAbsentPutWithKey(int key, IntToDoubleFunction function) {
        if (IntDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                double value = function.valueOf(key);
                this.sentinelValues = new AbstractMutableDoubleValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            double value = function.valueOf(key);
            this.addEmptyKeyValue(value);
            return value;
        }
        if (IntDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                double value = function.valueOf(key);
                this.sentinelValues = new AbstractMutableDoubleValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            double value = function.valueOf(key);
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        double value = function.valueOf(key);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public double addToValue(int key, double toBeAdded) {
        if (IntDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableDoubleValuesMap.SentinelValues();
                this.addEmptyKeyValue(toBeAdded);
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue += toBeAdded;
            } else {
                this.addEmptyKeyValue(toBeAdded);
            }
            return this.sentinelValues.zeroValue;
        }
        if (IntDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableDoubleValuesMap.SentinelValues();
                this.addRemovedKeyValue(toBeAdded);
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue += toBeAdded;
            } else {
                this.addRemovedKeyValue(toBeAdded);
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            int n = index;
            this.values[n] = this.values[n] + toBeAdded;
            return this.values[index];
        }
        this.addKeyValueAtIndex(key, toBeAdded, index);
        return toBeAdded;
    }

    private void addKeyValueAtIndex(int key, double value, int index) {
        if (this.keys[index] == 1) {
            --this.occupiedWithSentinels;
        }
        if (this.copyKeysOnWrite) {
            this.copyKeys();
        }
        this.keys[index] = key;
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData + this.occupiedWithSentinels > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
    }

    private void removeKeyAtIndex(int index) {
        if (this.copyKeysOnWrite) {
            this.copyKeys();
        }
        this.keys[index] = 1;
        this.values[index] = 0.0;
        --this.occupiedWithData;
        ++this.occupiedWithSentinels;
    }

    private void copyKeys() {
        int[] copy = new int[this.keys.length];
        System.arraycopy(this.keys, 0, copy, 0, this.keys.length);
        this.keys = copy;
        this.copyKeysOnWrite = false;
    }

    public double updateValue(int key, double initialValueIfAbsent, DoubleToDoubleFunction function) {
        if (IntDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableDoubleValuesMap.SentinelValues();
                this.addEmptyKeyValue(function.valueOf(initialValueIfAbsent));
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue = function.valueOf(this.sentinelValues.zeroValue);
            } else {
                this.addEmptyKeyValue(function.valueOf(initialValueIfAbsent));
            }
            return this.sentinelValues.zeroValue;
        }
        if (IntDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableDoubleValuesMap.SentinelValues();
                this.addRemovedKeyValue(function.valueOf(initialValueIfAbsent));
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue = function.valueOf(this.sentinelValues.oneValue);
            } else {
                this.addRemovedKeyValue(function.valueOf(initialValueIfAbsent));
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.values[index] = function.valueOf(this.values[index]);
            return this.values[index];
        }
        double value = function.valueOf(initialValueIfAbsent);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public IntDoubleHashMap withKeyValue(int key1, double value1) {
        this.put(key1, value1);
        return this;
    }

    public IntDoubleHashMap withKeysValues(int key1, double value1, int key2, double value2) {
        this.put(key1, value1);
        this.put(key2, value2);
        return this;
    }

    public IntDoubleHashMap withKeysValues(int key1, double value1, int key2, double value2, int key3, double value3) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        return this;
    }

    public IntDoubleHashMap withKeysValues(int key1, double value1, int key2, double value2, int key3, double value3, int key4, double value4) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        this.put(key4, value4);
        return this;
    }

    public IntDoubleHashMap withoutKey(int key) {
        this.removeKey(key);
        return this;
    }

    public IntDoubleHashMap withoutAllKeys(IntIterable keys) {
        keys.forEach(this::removeKey);
        return this;
    }

    public MutableIntDoubleMap asUnmodifiable() {
        return new UnmodifiableIntDoubleMap(this);
    }

    public MutableIntDoubleMap asSynchronized() {
        return new SynchronizedIntDoubleMap(this);
    }

    public ImmutableIntDoubleMap toImmutable() {
        return IntDoubleMaps.immutable.ofAll((IntDoubleMap)this);
    }

    public double get(int key) {
        return this.getIfAbsent(key, 0.0);
    }

    public double getIfAbsent(int key, double ifAbsent) {
        if (IntDoubleHashMap.isEmptyKey(key) || IntDoubleHashMap.isRemovedKey(key)) {
            return this.getForSentinel(key, ifAbsent);
        }
        if (this.occupiedWithSentinels == 0) {
            return this.fastGetIfAbsent(key, ifAbsent);
        }
        return this.slowGetIfAbsent(key, ifAbsent);
    }

    private double getForSentinel(int key, double ifAbsent) {
        if (IntDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return ifAbsent;
            }
            return this.sentinelValues.zeroValue;
        }
        if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
            return ifAbsent;
        }
        return this.sentinelValues.oneValue;
    }

    private double slowGetIfAbsent(int key, double ifAbsent) {
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        return ifAbsent;
    }

    private double fastGetIfAbsent(int key, double ifAbsent) {
        int index = this.mask(key);
        for (int i = 0; i < 8; ++i) {
            int keyAtIndex = this.keys[index];
            if (keyAtIndex == key) {
                return this.values[index];
            }
            if (keyAtIndex == 0) {
                return ifAbsent;
            }
            index = index + 1 & this.keys.length - 1;
        }
        return this.slowGetIfAbsentTwo(key, ifAbsent);
    }

    private double slowGetIfAbsentTwo(int key, double ifAbsent) {
        int index = this.probeTwo(key, -1);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        return ifAbsent;
    }

    public double getOrThrow(int key) {
        if (IntDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.zeroValue;
        }
        if (IntDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (IntDoubleHashMap.isNonSentinel(this.keys[index])) {
            return this.values[index];
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    @Override
    public boolean containsKey(int key) {
        if (IntDoubleHashMap.isEmptyKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsZeroKey;
        }
        if (IntDoubleHashMap.isRemovedKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsOneKey;
        }
        return this.keys[this.probe(key)] == key;
    }

    @Override
    public void forEachKey(IntProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(0);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(1);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntDoubleHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.keys[i]);
        }
    }

    public void forEachKeyValue(IntDoubleProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(1, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntDoubleHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.keys[i], this.values[i]);
        }
    }

    public LazyIntIterable keysView() {
        return new KeysView();
    }

    public RichIterable<IntDoublePair> keyValuesView() {
        return new KeyValuesView();
    }

    public IntDoubleHashMap select(IntDoublePredicate predicate) {
        IntDoubleHashMap result = new IntDoubleHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(0, this.sentinelValues.zeroValue)) {
                result.put(0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(1, this.sentinelValues.oneValue)) {
                result.put(1, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntDoubleHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    public IntDoubleHashMap reject(IntDoublePredicate predicate) {
        IntDoubleHashMap result = new IntDoubleHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(0, this.sentinelValues.zeroValue)) {
                result.put(0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(1, this.sentinelValues.oneValue)) {
                result.put(1, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntDoubleHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                out.writeInt(0);
                out.writeDouble(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                out.writeInt(1);
                out.writeDouble(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntDoubleHashMap.isNonSentinel(this.keys[i])) continue;
            out.writeInt(this.keys[i]);
            out.writeDouble(this.values[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.put(in.readInt(), in.readDouble());
        }
    }

    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehashAndGrow() {
        this.rehash(this.keys.length << 1);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.keys.length;
        int[] old = this.keys;
        double[] oldValues = this.values;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (!IntDoubleHashMap.isNonSentinel(old[i])) continue;
            this.put(old[i], oldValues[i]);
        }
    }

    int probe(int element) {
        int index = this.mask(element);
        int keyAtIndex = this.keys[index];
        if (keyAtIndex == element || keyAtIndex == 0) {
            return index;
        }
        int removedIndex = keyAtIndex == 1 ? index : -1;
        for (int i = 1; i < 8; ++i) {
            int nextIndex = index + i & this.keys.length - 1;
            keyAtIndex = this.keys[nextIndex];
            if (keyAtIndex == element) {
                return nextIndex;
            }
            if (keyAtIndex == 0) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (keyAtIndex != 1 || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return this.probeTwo(element, removedIndex);
    }

    int probeTwo(int element, int removedIndex) {
        int index = this.spreadTwoAndMask(element);
        for (int i = 0; i < 8; ++i) {
            int nextIndex = index + i & this.keys.length - 1;
            int keyAtIndex = this.keys[nextIndex];
            if (keyAtIndex == element) {
                return nextIndex;
            }
            if (keyAtIndex == 0) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (keyAtIndex != 1 || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return this.probeThree(element, removedIndex);
    }

    int probeThree(int element, int removedIndex) {
        int nextIndex = SpreadFunctions.intSpreadOne(element);
        int spreadTwo = Integer.reverse(SpreadFunctions.intSpreadTwo(element)) | 1;
        int keyAtIndex;
        while ((keyAtIndex = this.keys[nextIndex = this.mask(nextIndex + spreadTwo)]) != element) {
            if (keyAtIndex == 0) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (keyAtIndex != 1 || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return nextIndex;
    }

    int spreadAndMask(int element) {
        int code = SpreadFunctions.intSpreadOne(element);
        return this.mask(code);
    }

    int spreadTwoAndMask(int element) {
        int code = SpreadFunctions.intSpreadTwo(element);
        return this.mask(code);
    }

    private int mask(int spread) {
        return spread & this.keys.length - 1;
    }

    private void allocateTable(int sizeToAllocate) {
        this.keys = new int[sizeToAllocate];
        this.values = new double[sizeToAllocate];
    }

    private static boolean isEmptyKey(int key) {
        return key == 0;
    }

    private static boolean isRemovedKey(int key) {
        return key == 1;
    }

    private static boolean isNonSentinel(int key) {
        return !IntDoubleHashMap.isEmptyKey(key) && !IntDoubleHashMap.isRemovedKey(key);
    }

    @Override
    protected boolean isNonSentinelAtIndex(int index) {
        return !IntDoubleHashMap.isEmptyKey(this.keys[index]) && !IntDoubleHashMap.isRemovedKey(this.keys[index]);
    }

    private int maxOccupiedWithData() {
        return this.keys.length >> 1;
    }

    private int maxOccupiedWithSentinels() {
        return this.keys.length >> 2;
    }

    public MutableIntSet keySet() {
        return new KeySet();
    }

    public MutableDoubleCollection values() {
        return new ValuesCollection();
    }

    static /* synthetic */ int[] access$302(IntDoubleHashMap x0, int[] x1) {
        x0.keys = x1;
        return x1;
    }

    static /* synthetic */ double[] access$502(IntDoubleHashMap x0, double[] x1) {
        x0.values = x1;
        return x1;
    }

    private class KeyValuesView
    extends AbstractLazyIterable<IntDoublePair> {
        private KeyValuesView() {
        }

        public void each(Procedure<? super IntDoublePair> procedure) {
            if (IntDoubleHashMap.this.sentinelValues != null) {
                if (((IntDoubleHashMap)IntDoubleHashMap.this).sentinelValues.containsZeroKey) {
                    procedure.value((Object)PrimitiveTuples.pair(0, ((IntDoubleHashMap)IntDoubleHashMap.this).sentinelValues.zeroValue));
                }
                if (((IntDoubleHashMap)IntDoubleHashMap.this).sentinelValues.containsOneKey) {
                    procedure.value((Object)PrimitiveTuples.pair(1, ((IntDoubleHashMap)IntDoubleHashMap.this).sentinelValues.oneValue));
                }
            }
            for (int i = 0; i < IntDoubleHashMap.this.keys.length; ++i) {
                if (!IntDoubleHashMap.isNonSentinel(IntDoubleHashMap.this.keys[i])) continue;
                procedure.value((Object)PrimitiveTuples.pair(IntDoubleHashMap.this.keys[i], IntDoubleHashMap.this.values[i]));
            }
        }

        @Override
        public void forEachWithIndex(ObjectIntProcedure<? super IntDoublePair> objectIntProcedure) {
            int index = 0;
            if (IntDoubleHashMap.this.sentinelValues != null) {
                if (((IntDoubleHashMap)IntDoubleHashMap.this).sentinelValues.containsZeroKey) {
                    objectIntProcedure.value((Object)PrimitiveTuples.pair(0, ((IntDoubleHashMap)IntDoubleHashMap.this).sentinelValues.zeroValue), index);
                    ++index;
                }
                if (((IntDoubleHashMap)IntDoubleHashMap.this).sentinelValues.containsOneKey) {
                    objectIntProcedure.value((Object)PrimitiveTuples.pair(1, ((IntDoubleHashMap)IntDoubleHashMap.this).sentinelValues.oneValue), index);
                    ++index;
                }
            }
            for (int i = 0; i < IntDoubleHashMap.this.keys.length; ++i) {
                if (!IntDoubleHashMap.isNonSentinel(IntDoubleHashMap.this.keys[i])) continue;
                objectIntProcedure.value((Object)PrimitiveTuples.pair(IntDoubleHashMap.this.keys[i], IntDoubleHashMap.this.values[i]), index);
                ++index;
            }
        }

        @Override
        public <P> void forEachWith(Procedure2<? super IntDoublePair, ? super P> procedure, P parameter) {
            if (IntDoubleHashMap.this.sentinelValues != null) {
                if (((IntDoubleHashMap)IntDoubleHashMap.this).sentinelValues.containsZeroKey) {
                    procedure.value((Object)PrimitiveTuples.pair(0, ((IntDoubleHashMap)IntDoubleHashMap.this).sentinelValues.zeroValue), parameter);
                }
                if (((IntDoubleHashMap)IntDoubleHashMap.this).sentinelValues.containsOneKey) {
                    procedure.value((Object)PrimitiveTuples.pair(1, ((IntDoubleHashMap)IntDoubleHashMap.this).sentinelValues.oneValue), parameter);
                }
            }
            for (int i = 0; i < IntDoubleHashMap.this.keys.length; ++i) {
                if (!IntDoubleHashMap.isNonSentinel(IntDoubleHashMap.this.keys[i])) continue;
                procedure.value((Object)PrimitiveTuples.pair(IntDoubleHashMap.this.keys[i], IntDoubleHashMap.this.values[i]), parameter);
            }
        }

        public Iterator<IntDoublePair> iterator() {
            return new InternalKeyValuesIterator();
        }

        public class InternalKeyValuesIterator
        implements Iterator<IntDoublePair> {
            private int count;
            private int position;
            private boolean handledZero;
            private boolean handledOne;

            @Override
            public IntDoublePair next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("next() called, but the iterator is exhausted");
                }
                ++this.count;
                if (!this.handledZero) {
                    this.handledZero = true;
                    if (IntDoubleHashMap.this.containsKey(0)) {
                        return PrimitiveTuples.pair(0, ((IntDoubleHashMap)IntDoubleHashMap.this).sentinelValues.zeroValue);
                    }
                }
                if (!this.handledOne) {
                    this.handledOne = true;
                    if (IntDoubleHashMap.this.containsKey(1)) {
                        return PrimitiveTuples.pair(1, ((IntDoubleHashMap)IntDoubleHashMap.this).sentinelValues.oneValue);
                    }
                }
                int[] keys = IntDoubleHashMap.this.keys;
                while (!IntDoubleHashMap.isNonSentinel(keys[this.position])) {
                    ++this.position;
                }
                IntDoublePair result = PrimitiveTuples.pair(keys[this.position], IntDoubleHashMap.this.values[this.position]);
                ++this.position;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
            }

            @Override
            public boolean hasNext() {
                return this.count != IntDoubleHashMap.this.size();
            }
        }
    }

    private class ValuesCollection
    extends AbstractMutableDoubleValuesMap.AbstractDoubleValuesCollection {
        private ValuesCollection() {
        }

        public MutableDoubleIterator doubleIterator() {
            return IntDoubleHashMap.this.doubleIterator();
        }

        public boolean remove(double item) {
            int oldSize = IntDoubleHashMap.this.size();
            if (IntDoubleHashMap.this.sentinelValues != null) {
                if (((IntDoubleHashMap)IntDoubleHashMap.this).sentinelValues.containsZeroKey && Double.compare(item, ((IntDoubleHashMap)IntDoubleHashMap.this).sentinelValues.zeroValue) == 0) {
                    IntDoubleHashMap.this.removeKey(0);
                }
                if (((IntDoubleHashMap)IntDoubleHashMap.this).sentinelValues.containsOneKey && Double.compare(item, ((IntDoubleHashMap)IntDoubleHashMap.this).sentinelValues.oneValue) == 0) {
                    IntDoubleHashMap.this.removeKey(1);
                }
            }
            for (int i = 0; i < IntDoubleHashMap.this.keys.length; ++i) {
                if (!IntDoubleHashMap.isNonSentinel(IntDoubleHashMap.this.keys[i]) || Double.compare(item, IntDoubleHashMap.this.values[i]) != 0) continue;
                IntDoubleHashMap.this.removeKey(IntDoubleHashMap.this.keys[i]);
            }
            return oldSize != IntDoubleHashMap.this.size();
        }

        public boolean retainAll(DoubleIterable source) {
            int oldSize = IntDoubleHashMap.this.size();
            Object sourceSet = source instanceof DoubleSet ? (DoubleSet)source : source.toSet();
            IntDoubleHashMap retained = IntDoubleHashMap.this.select((arg_0, arg_1) -> ValuesCollection.lambda$retainAll$6aafd59c$1((DoubleSet)sourceSet, arg_0, arg_1));
            if (retained.size() != oldSize) {
                IntDoubleHashMap.access$302(IntDoubleHashMap.this, retained.keys);
                IntDoubleHashMap.access$502(IntDoubleHashMap.this, retained.values);
                IntDoubleHashMap.this.sentinelValues = retained.sentinelValues;
                IntDoubleHashMap.this.occupiedWithData = retained.occupiedWithData;
                IntDoubleHashMap.this.occupiedWithSentinels = retained.occupiedWithSentinels;
                return true;
            }
            return false;
        }

        private static /* synthetic */ boolean lambda$retainAll$6aafd59c$1(DoubleSet sourceSet, int key, double value) {
            return sourceSet.contains(value);
        }
    }

    private class KeySet
    extends AbstractMutableIntKeySet {
        private KeySet() {
        }

        @Override
        protected MutableIntKeysMap getOuter() {
            return IntDoubleHashMap.this;
        }

        @Override
        protected AbstractMutableDoubleValuesMap.SentinelValues getSentinelValues() {
            return IntDoubleHashMap.this.sentinelValues;
        }

        @Override
        protected int getKeyAtIndex(int index) {
            return IntDoubleHashMap.this.keys[index];
        }

        @Override
        protected int getTableSize() {
            return IntDoubleHashMap.this.keys.length;
        }

        public MutableIntIterator intIterator() {
            return new KeySetIterator();
        }

        public boolean retainAll(IntIterable source) {
            int oldSize = IntDoubleHashMap.this.size();
            Object sourceSet = source instanceof IntSet ? (IntSet)source : source.toSet();
            IntDoubleHashMap retained = IntDoubleHashMap.this.select((arg_0, arg_1) -> KeySet.lambda$retainAll$8a9b0f0a$1((IntSet)sourceSet, arg_0, arg_1));
            if (retained.size() != oldSize) {
                IntDoubleHashMap.access$302(IntDoubleHashMap.this, retained.keys);
                IntDoubleHashMap.access$502(IntDoubleHashMap.this, retained.values);
                IntDoubleHashMap.this.sentinelValues = retained.sentinelValues;
                IntDoubleHashMap.this.occupiedWithData = retained.occupiedWithData;
                IntDoubleHashMap.this.occupiedWithSentinels = retained.occupiedWithSentinels;
                return true;
            }
            return false;
        }

        public boolean retainAll(int ... source) {
            return this.retainAll(IntHashSet.newSetWith(source));
        }

        public IntSet freeze() {
            IntDoubleHashMap.this.copyKeysOnWrite = true;
            boolean containsZeroKey = false;
            boolean containsOneKey = false;
            if (IntDoubleHashMap.this.sentinelValues != null) {
                containsZeroKey = ((IntDoubleHashMap)IntDoubleHashMap.this).sentinelValues.containsZeroKey;
                containsOneKey = ((IntDoubleHashMap)IntDoubleHashMap.this).sentinelValues.containsOneKey;
            }
            return new ImmutableIntMapKeySet(IntDoubleHashMap.this.keys, IntDoubleHashMap.this.occupiedWithData, containsZeroKey, containsOneKey);
        }

        private static /* synthetic */ boolean lambda$retainAll$8a9b0f0a$1(IntSet sourceSet, int key, double value) {
            return sourceSet.contains(key);
        }
    }

    private class KeySetIterator
    implements MutableIntIterator {
        private int count;
        private int position;
        private int lastKey;
        private boolean handledZero;
        private boolean handledOne;
        private boolean canRemove;

        private KeySetIterator() {
        }

        public boolean hasNext() {
            return this.count < IntDoubleHashMap.this.size();
        }

        public int next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            this.canRemove = true;
            if (!this.handledZero) {
                this.handledZero = true;
                if (IntDoubleHashMap.this.containsKey(0)) {
                    this.lastKey = 0;
                    return this.lastKey;
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (IntDoubleHashMap.this.containsKey(1)) {
                    this.lastKey = 1;
                    return this.lastKey;
                }
            }
            int[] keys = IntDoubleHashMap.this.keys;
            while (!IntDoubleHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            this.lastKey = keys[this.position];
            ++this.position;
            return this.lastKey;
        }

        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            IntDoubleHashMap.this.removeKey(this.lastKey);
            --this.count;
            this.canRemove = false;
        }
    }

    private class KeysView
    extends AbstractLazyIntIterable {
        private KeysView() {
        }

        public IntIterator intIterator() {
            return new UnmodifiableIntIterator((IntIterator)new KeySetIterator());
        }

        public void each(IntProcedure procedure) {
            IntDoubleHashMap.this.forEachKey(procedure);
        }
    }

    private class InternalDoubleIterator
    implements MutableDoubleIterator {
        private int count;
        private int position;
        private int lastKey;
        private boolean handledZero;
        private boolean handledOne;
        private boolean canRemove;

        private InternalDoubleIterator() {
        }

        public boolean hasNext() {
            return this.count < IntDoubleHashMap.this.size();
        }

        public double next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            this.canRemove = true;
            if (!this.handledZero) {
                this.handledZero = true;
                if (IntDoubleHashMap.this.containsKey(0)) {
                    this.lastKey = 0;
                    return IntDoubleHashMap.this.get(0);
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (IntDoubleHashMap.this.containsKey(1)) {
                    this.lastKey = 1;
                    return IntDoubleHashMap.this.get(1);
                }
            }
            int[] keys = IntDoubleHashMap.this.keys;
            while (!IntDoubleHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            this.lastKey = keys[this.position];
            double result = IntDoubleHashMap.this.values[this.position];
            ++this.position;
            return result;
        }

        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            IntDoubleHashMap.this.removeKey(this.lastKey);
            --this.count;
            this.canRemove = false;
        }
    }
}

