/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.collection.mutable;

import java.util.Collection;
import net.jcip.annotations.ThreadSafe;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.Function3;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.collection.MutableCollection;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.map.primitive.MutableObjectDoubleMap;
import org.eclipse.collections.api.map.primitive.MutableObjectLongMap;
import org.eclipse.collections.api.tuple.Twin;
import org.eclipse.collections.impl.collection.AbstractSynchronizedRichIterable;

@ThreadSafe
public abstract class AbstractSynchronizedMutableCollection<T>
extends AbstractSynchronizedRichIterable<T>
implements MutableCollection<T> {
    protected AbstractSynchronizedMutableCollection(MutableCollection<T> delegate) {
        this(delegate, null);
    }

    protected AbstractSynchronizedMutableCollection(MutableCollection<T> delegate, Object lock) {
        super(delegate, lock);
    }

    @Override
    protected MutableCollection<T> getDelegate() {
        return (MutableCollection)super.getDelegate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(T o) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().add(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Object o) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().remove(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(Collection<? extends T> coll) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().addAll(coll);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAll(Collection<?> coll) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().removeAll(coll);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retainAll(Collection<?> coll) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().retainAll(coll);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.getLock();
        synchronized (object) {
            this.getDelegate().clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeIf(Predicate<? super T> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().removeIf(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> boolean removeIfWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().removeIfWith(predicate, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAllIterable(Iterable<? extends T> iterable) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().addAllIterable(iterable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAllIterable(Iterable<?> iterable) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().removeAllIterable(iterable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retainAllIterable(Iterable<?> iterable) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().retainAllIterable(iterable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> Twin<MutableList<T>> selectAndRejectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().selectAndRejectWith(predicate, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <IV, P> IV injectIntoWith(IV injectValue, Function3<? super IV, ? super T, ? super P, ? extends IV> function, P parameter) {
        Object object = this.lock;
        synchronized (object) {
            return (IV)this.getDelegate().injectIntoWith(injectValue, function, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> MutableMap<V, T> groupByUniqueKey(Function<? super T, ? extends V> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().groupByUniqueKey(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> MutableMap<K, V> aggregateInPlaceBy(Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Procedure2<? super V, ? super T> mutatingAggregator) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().aggregateInPlaceBy(groupBy, zeroValueFactory, mutatingAggregator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> MutableMap<K, V> aggregateBy(Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Function2<? super V, ? super T, ? extends V> nonMutatingAggregator) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().aggregateBy(groupBy, zeroValueFactory, nonMutatingAggregator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> MutableObjectLongMap<V> sumByInt(Function<? super T, ? extends V> groupBy, IntFunction<? super T> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().sumByInt(groupBy, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> MutableObjectDoubleMap<V> sumByFloat(Function<? super T, ? extends V> groupBy, FloatFunction<? super T> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().sumByFloat(groupBy, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> MutableObjectLongMap<V> sumByLong(Function<? super T, ? extends V> groupBy, LongFunction<? super T> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().sumByLong(groupBy, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> MutableObjectDoubleMap<V> sumByDouble(Function<? super T, ? extends V> groupBy, DoubleFunction<? super T> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().sumByDouble(groupBy, function);
        }
    }
}

