/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.mutable.primitive;

import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.eclipse.collections.api.BooleanIterable;
import org.eclipse.collections.api.LazyBooleanIterable;
import org.eclipse.collections.api.block.function.primitive.BooleanToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BooleanPredicate;
import org.eclipse.collections.api.collection.primitive.MutableBooleanCollection;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.set.primitive.BooleanSet;
import org.eclipse.collections.api.set.primitive.ImmutableBooleanSet;
import org.eclipse.collections.api.set.primitive.MutableBooleanSet;
import org.eclipse.collections.impl.collection.mutable.primitive.AbstractSynchronizedBooleanCollection;
import org.eclipse.collections.impl.lazy.primitive.LazyBooleanIterableAdapter;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableBooleanSet;

@ThreadSafe
public final class SynchronizedBooleanSet
extends AbstractSynchronizedBooleanCollection
implements MutableBooleanSet {
    private static final long serialVersionUID = 1L;

    SynchronizedBooleanSet(MutableBooleanSet set) {
        super((MutableBooleanCollection)set);
    }

    SynchronizedBooleanSet(MutableBooleanSet set, Object newLock) {
        super((MutableBooleanCollection)set, newLock);
    }

    public static SynchronizedBooleanSet of(MutableBooleanSet set) {
        return new SynchronizedBooleanSet(set);
    }

    public static SynchronizedBooleanSet of(MutableBooleanSet set, Object lock) {
        return new SynchronizedBooleanSet(set, lock);
    }

    @GuardedBy(value="getLock()")
    private MutableBooleanSet getMutableBooleanSet() {
        return (MutableBooleanSet)this.getBooleanCollection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedBooleanSet without(boolean element) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableBooleanSet().remove(element);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedBooleanSet with(boolean element) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableBooleanSet().add(element);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedBooleanSet withAll(BooleanIterable elements) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableBooleanSet().addAll(elements.toArray());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedBooleanSet withoutAll(BooleanIterable elements) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableBooleanSet().removeAll(elements);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableBooleanSet select(BooleanPredicate predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableBooleanSet().select(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableBooleanSet reject(BooleanPredicate predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableBooleanSet().reject(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> MutableSet<V> collect(BooleanToObjectFunction<? extends V> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableBooleanSet().collect(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object otherSet) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableBooleanSet().equals(otherSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableBooleanSet().hashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LazyBooleanIterable asLazy() {
        Object object = this.getLock();
        synchronized (object) {
            return new LazyBooleanIterableAdapter((BooleanIterable)this);
        }
    }

    public MutableBooleanSet asUnmodifiable() {
        return new UnmodifiableBooleanSet(this);
    }

    public MutableBooleanSet asSynchronized() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BooleanSet freeze() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableBooleanSet().freeze();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableBooleanSet toImmutable() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableBooleanSet().toImmutable();
        }
    }
}

