/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.block.procedure;

import java.util.List;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.tuple.Tuples;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CaseProcedure<T>
implements Procedure<T> {
    private static final long serialVersionUID = 1L;
    private final List<Pair<Predicate<? super T>, Procedure<? super T>>> predicateProcedures = Lists.mutable.empty();
    private Procedure<? super T> defaultProcedure;

    public CaseProcedure(Procedure<? super T> defaultProcedure) {
        this.defaultProcedure = defaultProcedure;
    }

    public CaseProcedure() {
    }

    public CaseProcedure<T> addCase(Predicate<? super T> predicate, Procedure<? super T> procedure) {
        this.predicateProcedures.add(Tuples.pair(predicate, procedure));
        return this;
    }

    public CaseProcedure<T> setDefault(Procedure<? super T> procedure) {
        this.defaultProcedure = procedure;
        return this;
    }

    public void value(T argument) {
        for (Pair<Predicate<? super T>, Procedure<? super T>> pair : this.predicateProcedures) {
            if (!((Predicate)pair.getOne()).accept(argument)) continue;
            ((Procedure)pair.getTwo()).value(argument);
            return;
        }
        if (this.defaultProcedure != null) {
            this.defaultProcedure.value(argument);
        }
    }

    public String toString() {
        return "new CaseProcedure(" + this.predicateProcedures + ')';
    }
}

